/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.ArmorWidget;
import ftjava.gui.ssd.CoreCommandBridgeWidget;
import ftjava.gui.ssd.CoreLifeSupportWidget;
import ftjava.gui.ssd.CorePowerCoreWidget;
import ftjava.gui.ssd.FTLDriveWidget;
import ftjava.gui.ssd.HullWidget;
import ftjava.gui.ssd.MainDriveWidget;
import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.ssd.WidgetFactory;
import ftjava.std.CargoHold;
import ftjava.std.Defense;
import ftjava.std.Electronics;
import ftjava.std.FTLDrive;
import ftjava.std.MainDrive;
import ftjava.std.SalvoMissileLauncher;
import ftjava.std.SalvoMissileMagazine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.JPanel;

public class SSDWidget
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Ship theShip;
    private boolean mutable;
    private Dimension bounds;
    private static final int DEFAULT_HEIGHT = 300;
    private static final GeneralPath coreBackground = new GeneralPath();

    public SSDWidget() {
        this(new Ship(), true);
    }

    public SSDWidget(Ship theShip) {
        this(theShip, false);
    }

    public SSDWidget(Ship theShip, boolean mutable) {
        this.theShip = theShip;
        this.mutable = mutable;
        this.bounds = new Dimension(this.getSSDWidth(), 300);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                SSDWidget.this.updateLayout();
            }
        });
        this.setPreferredSize(this.bounds);
        this.initSystemWidgets();
        this.bounds.width = this.getSSDWidth();
        this.bounds.height = this.getSSDHeight();
        this.setPreferredSize(this.bounds);
        this.updateLayout();
    }

    public void addSystem(ShipSystem theSystem) {
        ArrayList sysList;
        SystemWidget sysWidget = WidgetFactory.createWidgetFromSystem(theSystem, this.mutable);
        Dimension b = this.getSize();
        if (sysWidget == null) {
            return;
        }
        if (theSystem instanceof FTLDrive) {
            if (this.theShip.getFTLDrive() != null) {
                return;
            }
            this.theShip.setFTLDrive((FTLDrive)theSystem);
            sysWidget.setLocation(15, b.height - (15 + sysWidget.getHeight()));
            this.add(sysWidget);
            this.repaint();
            return;
        }
        if (theSystem instanceof MainDrive) {
            if (this.theShip.getMainDrive() != null) {
                return;
            }
            this.theShip.setMainDrive((MainDrive)theSystem);
            sysWidget.setLocation(FTLDriveWidget.FTL_SIZE.width + 25, b.height - (13 + sysWidget.getHeight()));
            this.add(sysWidget);
            this.repaint();
            return;
        }
        if (theSystem instanceof Defense) {
            sysList = this.theShip.getDefenseSystems();
        } else if (theSystem instanceof Electronics) {
            sysList = this.theShip.getElectronicsSystems();
        } else if (theSystem instanceof Weapon) {
            sysList = this.theShip.getWeaponSystems();
        } else if (theSystem instanceof CargoHold) {
            sysList = this.theShip.getShipHolds();
        } else {
            return;
        }
        sysList.add(theSystem);
        sysWidget.setLocation(theSystem.getXSSD() - sysWidget.getWidth() / 2, theSystem.getYSSD() - sysWidget.getHeight() / 2);
        this.add(sysWidget);
        this.repaint();
    }

    public void removeSystem(SystemWidget sysWidget) {
        ArrayList sysList;
        ShipSystem theSystem = sysWidget.getShipSystem();
        if (theSystem instanceof FTLDrive && this.theShip.getFTLDrive() != null) {
            this.remove(sysWidget);
            this.theShip.setFTLDrive(null);
            this.repaint();
            return;
        }
        if (theSystem instanceof MainDrive && this.theShip.getMainDrive() != null) {
            this.remove(sysWidget);
            this.theShip.setMainDrive(null);
            this.repaint();
            return;
        }
        if (theSystem instanceof Defense) {
            sysList = this.theShip.getDefenseSystems();
        } else if (theSystem instanceof Electronics) {
            sysList = this.theShip.getElectronicsSystems();
        } else if (theSystem instanceof Weapon) {
            sysList = this.theShip.getWeaponSystems();
        } else if (theSystem instanceof CargoHold) {
            sysList = this.theShip.getShipHolds();
        } else {
            return;
        }
        int i = sysList.indexOf(theSystem);
        if (i >= 0) {
            sysList.remove(i);
            this.remove(sysWidget);
        }
        this.repaint();
    }

    public void paintComponent(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        AffineTransform t = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        Paint oldPaint = g.getPaint();
        Rectangle r = this.getBounds(null);
        r.x = 0;
        r.y = 0;
        g.setPaint(SSDDrawingTools.backgroundPaint);
        g.fill(r);
        g.setPaint(oldPaint);
        g.translate(55 + FTLDriveWidget.FTL_SIZE.width + MainDriveWidget.MAINDRIVE_SIZE.width, r.height - 35);
        g.setColor(Color.white);
        g.fill(coreBackground);
        g.setColor(Color.black);
        g.draw(coreBackground);
        g.setTransform(t);
        ArrayList weapons = this.theShip.getWeaponSystems();
        for (int i = 0; i < weapons.size(); ++i) {
            SalvoMissileLauncher sml;
            SalvoMissileMagazine smm;
            if (!(weapons.get(i) instanceof SalvoMissileLauncher) || (smm = (SalvoMissileMagazine)this.theShip.getWeaponById((sml = (SalvoMissileLauncher)weapons.get(i)).getSalvoMagazineId())) == null) continue;
            g.drawLine(sml.getXSSD(), sml.getYSSD(), smm.getXSSD(), smm.getYSSD());
        }
    }

    private void initSystemWidgets() {
        SystemWidget theWidget;
        int i;
        Point cp = new Point(0, 0);
        this.setLayout(null);
        HullWidget hw = new HullWidget(this.theShip.getHull(), this.mutable);
        cp.x = 10;
        cp.y = this.bounds.height - (50 + hw.getHeight());
        hw.setLocation(cp);
        this.add(hw);
        ArmorWidget aw = new ArmorWidget(this.theShip.getArmor(), this.mutable);
        cp.y -= 12;
        aw.setLocation(cp);
        this.add(aw);
        FTLDriveWidget ftlw = null;
        if (this.theShip.getFTLDrive() != null) {
            ftlw = new FTLDriveWidget(this.theShip.getFTLDrive(), this.mutable);
            cp.x = 15;
            cp.y = this.bounds.height - (15 + ftlw.getHeight());
            ftlw.setLocation(cp);
            this.add(ftlw);
        }
        MainDriveWidget mdw = null;
        if (this.theShip.getMainDrive() != null) {
            mdw = new MainDriveWidget(this.theShip.getMainDrive(), this.mutable);
            mdw.setLocation(FTLDriveWidget.FTL_SIZE.width + 25, this.bounds.height - (13 + mdw.getHeight()));
            this.add(mdw);
        }
        ArrayList theSys = this.theShip.getCoreSystems();
        for (i = 0; i < theSys.size(); ++i) {
            theWidget = WidgetFactory.createWidgetFromSystem((ShipSystem)theSys.get(i), this.mutable);
            if (theWidget == null) continue;
            int x_base = 50 + FTLDriveWidget.FTL_SIZE.width + MainDriveWidget.MAINDRIVE_SIZE.width;
            int y = this.bounds.height - (15 + theWidget.getHeight());
            if (theWidget instanceof CoreCommandBridgeWidget) {
                theWidget.setLocation(x_base + 5, y);
            } else if (theWidget instanceof CoreLifeSupportWidget) {
                theWidget.setLocation(x_base + 10 + theWidget.getWidth(), y);
            } else if (theWidget instanceof CorePowerCoreWidget) {
                theWidget.setLocation(x_base + 15 + 2 * theWidget.getWidth(), y);
            }
            this.add(theWidget);
        }
        theSys = this.theShip.getDefenseSystems();
        for (i = 0; i < theSys.size(); ++i) {
            theWidget = WidgetFactory.createWidgetFromSystem((ShipSystem)theSys.get(i), this.mutable);
            if (theWidget == null) continue;
            theWidget.setLocation(((ShipSystem)theSys.get(i)).getXSSD() - theWidget.getWidth() / 2, ((ShipSystem)theSys.get(i)).getYSSD() - theWidget.getHeight() / 2);
            this.add(theWidget);
        }
        theSys = this.theShip.getWeaponSystems();
        for (i = 0; i < theSys.size(); ++i) {
            theWidget = WidgetFactory.createWidgetFromSystem((ShipSystem)theSys.get(i), this.mutable);
            if (theWidget == null) continue;
            theWidget.setLocation(((ShipSystem)theSys.get(i)).getXSSD() - theWidget.getWidth() / 2, ((ShipSystem)theSys.get(i)).getYSSD() - theWidget.getHeight() / 2);
            this.add(theWidget);
        }
        theSys = this.theShip.getElectronicsSystems();
        for (i = 0; i < theSys.size(); ++i) {
            theWidget = WidgetFactory.createWidgetFromSystem((ShipSystem)theSys.get(i), this.mutable);
            if (theWidget == null) continue;
            theWidget.setLocation(((ShipSystem)theSys.get(i)).getXSSD() - theWidget.getWidth() / 2, ((ShipSystem)theSys.get(i)).getYSSD() - theWidget.getHeight() / 2);
            this.add(theWidget);
        }
        theSys = this.theShip.getShipHolds();
        for (i = 0; i < theSys.size(); ++i) {
            theWidget = WidgetFactory.createWidgetFromSystem((ShipSystem)theSys.get(i), this.mutable);
            if (theWidget == null) continue;
            theWidget.setLocation(((ShipSystem)theSys.get(i)).getXSSD() - theWidget.getWidth() / 2, ((ShipSystem)theSys.get(i)).getYSSD() - theWidget.getHeight() / 2);
            this.add(theWidget);
        }
    }

    private void updateLayout() {
        Component[] widgets = this.getComponents();
        Dimension b = this.getSize();
        int core_x_base = 50 + FTLDriveWidget.FTL_SIZE.width + MainDriveWidget.MAINDRIVE_SIZE.width;
        int numberOfHullRows = this.theShip.getHull().getNumberOfRows();
        for (int i = 0; i < widgets.length; ++i) {
            int y;
            int x;
            if (widgets[i] instanceof HullWidget) {
                x = 10;
                y = b.height - (50 + widgets[i].getHeight());
                widgets[i].setLocation(x, y);
                continue;
            }
            if (widgets[i] instanceof ArmorWidget) {
                x = 10;
                y = b.height - (100 + (numberOfHullRows - 4) * 12 + widgets[i].getHeight());
                widgets[i].setLocation(x, y);
                continue;
            }
            if (widgets[i] instanceof MainDriveWidget) {
                widgets[i].setLocation(FTLDriveWidget.FTL_SIZE.width + 25, b.height - (13 + widgets[i].getHeight()));
                continue;
            }
            if (widgets[i] instanceof FTLDriveWidget) {
                widgets[i].setLocation(15, b.height - (15 + widgets[i].getHeight()));
                continue;
            }
            if (widgets[i] instanceof CoreCommandBridgeWidget) {
                widgets[i].setLocation(core_x_base + 5, b.height - (15 + widgets[i].getHeight()));
                continue;
            }
            if (widgets[i] instanceof CoreLifeSupportWidget) {
                widgets[i].setLocation(core_x_base + 10 + widgets[i].getWidth(), b.height - (15 + widgets[i].getHeight()));
                continue;
            }
            if (!(widgets[i] instanceof CorePowerCoreWidget)) continue;
            widgets[i].setLocation(core_x_base + 15 + 2 * widgets[i].getWidth(), b.height - (15 + widgets[i].getHeight()));
        }
    }

    private int getSSDWidth() {
        int x = 145 + FTLDriveWidget.FTL_SIZE.width + MainDriveWidget.MAINDRIVE_SIZE.width;
        Component[] widgets = this.getComponents();
        for (int i = 0; i < widgets.length; ++i) {
            if (!(widgets[i] instanceof SystemWidget) && !(widgets[i] instanceof HullWidget) && !(widgets[i] instanceof ArmorWidget)) continue;
            Rectangle b = widgets[i].getBounds();
            int x_i = b.x + b.width + 20;
            if (x_i <= x) continue;
            x = x_i;
        }
        return x;
    }

    private int getSSDHeight() {
        int y_min = 0;
        int y_max = 300;
        Component[] widgets = this.getComponents();
        for (int i = 0; i < widgets.length; ++i) {
            if (!(widgets[i] instanceof SystemWidget)) continue;
            Rectangle b = widgets[i].getBounds();
            int y_i = b.y + b.height;
            if (y_i > y_max) {
                y_max = y_i;
            }
            if ((y_i = b.y) >= y_min) continue;
            y_min = y_i;
        }
        return y_max - y_min;
    }

    static {
        coreBackground.moveTo(-5.0f, 0.0f);
        coreBackground.lineTo(-5.0f, 20.0f);
        coreBackground.lineTo(0.0f, 25.0f);
        coreBackground.lineTo(70.0f, 25.0f);
        coreBackground.lineTo(75.0f, 20.0f);
        coreBackground.lineTo(75.0f, 0.0f);
        coreBackground.lineTo(70.0f, -5.0f);
        coreBackground.lineTo(0.0f, -5.0f);
        coreBackground.closePath();
    }
}

