/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.Hexagon;
import ftjava.std.Pulser;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;

public class PulserWidget
extends SystemWidget {
    private static final Dimension PULSER_SIZE = new Dimension(44, 44);
    private static final Arc2D FRONT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 40.0, 40.0, 60.0, 60.0, 2);
    private static final Arc2D FRONT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 40.0, 40.0, 0.0, 60.0, 2);
    private static final Arc2D AFT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 40.0, 40.0, 300.0, 60.0, 2);
    private static final Arc2D AFT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 40.0, 40.0, 240.0, 60.0, 2);
    private static final Arc2D AFT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 40.0, 40.0, 180.0, 60.0, 2);
    private static final Arc2D FRONT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 40.0, 40.0, 120.0, 60.0, 2);
    private static final Ellipse2D CENTER_AREA = new Ellipse2D.Double(10.0, 10.0, 20.0, 20.0);
    private static final GeneralPath[] points;
    private static final Hexagon center;

    public PulserWidget(Pulser p) {
        this(p, false);
    }

    public PulserWidget() {
        this(new Pulser(Weapon.ALL_ARCS, '-'), true);
    }

    public PulserWidget(Pulser p, boolean mutable) {
        super(p, mutable);
        this.initialisePulserMenuItems();
        this.setMinimumSize(PULSER_SIZE);
        this.setMaximumSize(PULSER_SIZE);
        this.setPreferredSize(PULSER_SIZE);
        this.setSize(PULSER_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        int fireArcs = ((Weapon)this.theSystem).getArcs() >> 21;
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.translate(22, 22);
        for (int i = 0; i < 6; ++i) {
            if ((fireArcs >> i & 1) != 0) {
                g.setColor(Color.white);
            } else {
                g.setColor(SSDDrawingTools.getSystemColor(this.theSystem).brighter());
            }
            g.fill(points[i]);
            g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
            g.draw(points[i]);
        }
        g.setColor(Color.white);
        g.fill(center);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        String strength = "" + ((Pulser)this.theSystem).getRangeMode();
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(strength, -fm.stringWidth(strength) / 2, fm.getAscent() / 2 - 1);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        int x = me.getX();
        int y = me.getY();
        int mods = me.getModifiers();
        Pulser thePulser = (Pulser)this.theSystem;
        if ((mods & 1) != 0 && !me.isConsumed()) {
            if (FRONT_ARC_AREA.contains(x, y)) {
                thePulser.setArcs(thePulser.getArcs() ^ Weapon.FORE_ARC);
            } else if (FRONT_STARBOARD_ARC_AREA.contains(x, y)) {
                thePulser.setArcs(thePulser.getArcs() ^ Weapon.FORE_STARBOARD_ARC);
            } else if (AFT_STARBOARD_ARC_AREA.contains(x, y)) {
                thePulser.setArcs(thePulser.getArcs() ^ Weapon.AFT_STARBOARD_ARC);
            } else if (AFT_ARC_AREA.contains(x, y)) {
                thePulser.setArcs(thePulser.getArcs() ^ Weapon.AFT_ARC);
            } else if (AFT_PORT_ARC_AREA.contains(x, y)) {
                thePulser.setArcs(thePulser.getArcs() ^ Weapon.AFT_PORT_ARC);
            } else if (FRONT_PORT_ARC_AREA.contains(x, y)) {
                thePulser.setArcs(thePulser.getArcs() ^ Weapon.FORE_PORT_ARC);
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        Pulser thePulser = (Pulser)this.theSystem;
        String ac = ae.getActionCommand();
        try {
            thePulser.setValue("mode", ac);
        }
        catch (Exception e) {
            super.actionPerformed(ae);
            this.repaint();
            return;
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialisePulserMenuItems() {
        Pulser thePulser = (Pulser)this.theSystem;
        char rangeMode = thePulser.getRangeMode();
        if (this.mutable) {
            this.popup.addSeparator();
            ButtonGroup bg = new ButtonGroup();
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem("-", rangeMode == '-');
            mi.setActionCommand("-");
            mi.addActionListener(this);
            bg.add(mi);
            this.popup.add(mi);
            mi = new JRadioButtonMenuItem("C", rangeMode == 'C');
            mi.setActionCommand("C");
            mi.addActionListener(this);
            bg.add(mi);
            this.popup.add(mi);
            mi = new JRadioButtonMenuItem("M", rangeMode == 'M');
            mi.setActionCommand("M");
            mi.addActionListener(this);
            bg.add(mi);
            this.popup.add(mi);
            mi = new JRadioButtonMenuItem("L", rangeMode == 'L');
            mi.setActionCommand("L");
            mi.addActionListener(this);
            bg.add(mi);
            this.popup.add(mi);
        }
    }

    private String getToolTip() {
        Pulser thePulser = (Pulser)this.theSystem;
        return "Pulser [" + thePulser.getRangeMode() + "] " + thePulser.getArcsString();
    }

    static {
        float sine30 = (float)Math.sin(0.5235987755982988);
        float sine60 = (float)Math.sin(1.0471975511965976);
        points = new GeneralPath[6];
        for (int i = 0; i < 6; ++i) {
            PulserWidget.points[i] = new GeneralPath();
        }
        points[0].moveTo(-10.0f * sine30, 10.0f);
        points[0].lineTo(10.0f * sine30, 10.0f);
        points[0].lineTo(0.0f, 20.0f);
        points[0].closePath();
        points[1].moveTo(10.0f * sine30, 10.0f);
        points[1].lineTo(20.0f * sine60, 10.0f);
        points[1].lineTo(10.0f, 0.0f);
        points[1].closePath();
        points[2].moveTo(10.0f * sine30, -10.0f);
        points[2].lineTo(20.0f * sine60, -10.0f);
        points[2].lineTo(10.0f, 0.0f);
        points[2].closePath();
        points[3].moveTo(-10.0f * sine30, -10.0f);
        points[3].lineTo(10.0f * sine30, -10.0f);
        points[3].lineTo(0.0f, -20.0f);
        points[3].closePath();
        points[4].moveTo(-10.0f, 0.0f);
        points[4].lineTo(-20.0f * sine60, -10.0f);
        points[4].lineTo(-10.0f * sine30, -10.0f);
        points[4].closePath();
        points[5].moveTo(-10.0f * sine30, 10.0f);
        points[5].lineTo(-20.0f * sine60, 10.0f);
        points[5].lineTo(-10.0f, 0.0f);
        points[5].closePath();
        center = new Hexagon(10.0, 0.0, 0.0);
    }
}

