/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.KineticGun;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class KineticGunWidget
extends SystemWidget {
    private static final Dimension K_GUN_SIZE = new Dimension(31, 31);
    private static final GeneralPath FRONT_ARC_AREA;
    private static final GeneralPath FRONT_STARBOARD_ARC_AREA;
    private static final GeneralPath AFT_STARBOARD_ARC_AREA;
    private static final GeneralPath AFT_ARC_AREA;
    private static final GeneralPath AFT_PORT_ARC_AREA;
    private static final GeneralPath FRONT_PORT_ARC_AREA;
    private static final GeneralPath CENTER_AREA;
    private static final float root3over2;
    private static GeneralPath path;

    public KineticGunWidget(KineticGun bb) {
        this(bb, false);
    }

    public KineticGunWidget() {
        this(new KineticGun(1, Weapon.ALL_ARCS), true);
    }

    public KineticGunWidget(KineticGun bb, boolean mutable) {
        super(bb, mutable);
        this.initialiseKGunMenuItems();
        this.setMinimumSize(K_GUN_SIZE);
        this.setMaximumSize(K_GUN_SIZE);
        this.setPreferredSize(K_GUN_SIZE);
        this.setSize(K_GUN_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        int fireArcs = ((Weapon)this.theSystem).getArcs() >> 21;
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.translate(15, 15);
        path.reset();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(-7.5f, 15.0f * root3over2);
        path.lineTo(7.5f, 15.0f * root3over2);
        path.closePath();
        for (int i = 0; i < 6; ++i) {
            if ((fireArcs >> i & 1) != 0) {
                g.setColor(Color.white);
            } else {
                g.setColor(SSDDrawingTools.getSystemColor(this.theSystem).brighter());
            }
            g.fill(path);
            g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
            g.draw(path);
            g.rotate(-1.0471975511965976);
        }
        path.reset();
        path.moveTo(-5.0f, 10.0f * root3over2);
        path.lineTo(5.0f, 10.0f * root3over2);
        path.lineTo(10.0f, 0.0f);
        path.lineTo(5.0f, -10.0f * root3over2);
        path.lineTo(-5.0f, -10.0f * root3over2);
        path.lineTo(-10.0f, 0.0f);
        path.closePath();
        g.setColor(Color.white);
        g.fill(path);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(path);
        String strength = Integer.toString(((KineticGun)this.theSystem).getRating());
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(strength, -fm.stringWidth(strength) / 2, fm.getAscent() / 2 - 1);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        int x = me.getX();
        int y = me.getY();
        int mods = me.getModifiers();
        KineticGun theKGun = (KineticGun)this.theSystem;
        if ((mods & 1) != 0 && !me.isConsumed()) {
            if (FRONT_ARC_AREA.contains(x, y)) {
                theKGun.setArcs(theKGun.getArcs() ^ Weapon.FORE_ARC);
            } else if (FRONT_STARBOARD_ARC_AREA.contains(x, y)) {
                theKGun.setArcs(theKGun.getArcs() ^ Weapon.FORE_STARBOARD_ARC);
            } else if (AFT_STARBOARD_ARC_AREA.contains(x, y)) {
                theKGun.setArcs(theKGun.getArcs() ^ Weapon.AFT_STARBOARD_ARC);
            } else if (AFT_ARC_AREA.contains(x, y)) {
                theKGun.setArcs(theKGun.getArcs() ^ Weapon.AFT_ARC);
            } else if (AFT_PORT_ARC_AREA.contains(x, y)) {
                theKGun.setArcs(theKGun.getArcs() ^ Weapon.AFT_PORT_ARC);
            } else if (FRONT_PORT_ARC_AREA.contains(x, y)) {
                theKGun.setArcs(theKGun.getArcs() ^ Weapon.FORE_PORT_ARC);
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        KineticGun theKGun = (KineticGun)this.theSystem;
        String ac = ae.getActionCommand();
        if (ac.equals("more")) {
            int newRating = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), theKGun.getRating());
            if (newRating >= 0) {
                theKGun.setValue("rating", Integer.toString(newRating));
            }
        } else {
            theKGun.setValue("rating", ac);
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialiseKGunMenuItems() {
        if (this.mutable) {
            JRadioButtonMenuItem mi;
            ButtonGroup bg = new ButtonGroup();
            this.popup.addSeparator();
            for (int i = 1; i <= 5; ++i) {
                mi = new JRadioButtonMenuItem(Integer.toString(i), i == 1);
                mi.setActionCommand(Integer.toString(i));
                mi.addActionListener(this);
                bg.add(mi);
                this.popup.add(mi);
            }
            mi = new JRadioButtonMenuItem("More Sizes...", false);
            mi.setActionCommand("more");
            mi.addActionListener(this);
            bg.add(mi);
            this.popup.add(mi);
        }
    }

    private String getToolTip() {
        KineticGun theGun = (KineticGun)this.theSystem;
        return "Class " + theGun.getRating() + " " + theGun.getArcsString();
    }

    static {
        root3over2 = (float)(Math.sqrt(3.0) / 2.0);
        path = new GeneralPath();
        CENTER_AREA = new GeneralPath();
        CENTER_AREA.reset();
        CENTER_AREA.moveTo(10.0f, 25.0f * root3over2);
        CENTER_AREA.lineTo(20.0f, 25.0f * root3over2);
        CENTER_AREA.lineTo(25.0f, 15.0f);
        CENTER_AREA.lineTo(20.0f, 5.0f * root3over2);
        CENTER_AREA.lineTo(10.0f, 5.0f * root3over2);
        CENTER_AREA.lineTo(5.0f, 15.0f);
        CENTER_AREA.closePath();
        AFT_ARC_AREA = new GeneralPath();
        AFT_ARC_AREA.reset();
        AFT_ARC_AREA.moveTo(15.0f, 15.0f);
        AFT_ARC_AREA.lineTo(10.0f, 35.0f * root3over2);
        AFT_ARC_AREA.lineTo(25.0f, 35.0f * root3over2);
        AFT_ARC_AREA.closePath();
        AFT_STARBOARD_ARC_AREA = new GeneralPath();
        AFT_STARBOARD_ARC_AREA.reset();
        AFT_STARBOARD_ARC_AREA.moveTo(15.0f, 15.0f);
        AFT_STARBOARD_ARC_AREA.lineTo(10.0f, 35.0f * root3over2);
        AFT_STARBOARD_ARC_AREA.lineTo(25.0f, 35.0f * root3over2);
        AFT_STARBOARD_ARC_AREA.closePath();
        AFT_STARBOARD_ARC_AREA.transform(AffineTransform.getRotateInstance(-1.0471975511965976, 15.0, 15.0));
        FRONT_STARBOARD_ARC_AREA = new GeneralPath();
        FRONT_STARBOARD_ARC_AREA.reset();
        FRONT_STARBOARD_ARC_AREA.moveTo(15.0f, 15.0f);
        FRONT_STARBOARD_ARC_AREA.lineTo(10.0f, 35.0f * root3over2);
        FRONT_STARBOARD_ARC_AREA.lineTo(25.0f, 35.0f * root3over2);
        FRONT_STARBOARD_ARC_AREA.closePath();
        FRONT_STARBOARD_ARC_AREA.transform(AffineTransform.getRotateInstance(-2.0943951023931953, 15.0, 15.0));
        FRONT_ARC_AREA = new GeneralPath();
        FRONT_ARC_AREA.reset();
        FRONT_ARC_AREA.moveTo(15.0f, 15.0f);
        FRONT_ARC_AREA.lineTo(10.0f, 35.0f * root3over2);
        FRONT_ARC_AREA.lineTo(25.0f, 35.0f * root3over2);
        FRONT_ARC_AREA.closePath();
        FRONT_ARC_AREA.transform(AffineTransform.getRotateInstance(-Math.PI, 15.0, 15.0));
        FRONT_PORT_ARC_AREA = new GeneralPath();
        FRONT_PORT_ARC_AREA.reset();
        FRONT_PORT_ARC_AREA.moveTo(15.0f, 15.0f);
        FRONT_PORT_ARC_AREA.lineTo(10.0f, 35.0f * root3over2);
        FRONT_PORT_ARC_AREA.lineTo(25.0f, 35.0f * root3over2);
        FRONT_PORT_ARC_AREA.closePath();
        FRONT_PORT_ARC_AREA.transform(AffineTransform.getRotateInstance(-4.1887902047863905, 15.0, 15.0));
        AFT_PORT_ARC_AREA = new GeneralPath();
        AFT_PORT_ARC_AREA.reset();
        AFT_PORT_ARC_AREA.moveTo(15.0f, 15.0f);
        AFT_PORT_ARC_AREA.lineTo(10.0f, 35.0f * root3over2);
        AFT_PORT_ARC_AREA.lineTo(25.0f, 35.0f * root3over2);
        AFT_PORT_ARC_AREA.closePath();
        AFT_PORT_ARC_AREA.transform(AffineTransform.getRotateInstance(-5.235987755982989, 15.0, 15.0));
    }
}

