/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.Hull;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class HullWidget
extends JComponent
implements MouseListener,
ActionListener {
    private Hull theHull;
    private boolean mutable;
    private Dimension bounds;
    private JPopupMenu popup;
    private static final Rectangle2D hullBoxRect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    private static final Rectangle2D stealthBoxRect = new Rectangle2D.Double(2.0, 2.0, 6.0, 6.0);
    private static final GeneralPath crewStar;
    private static final GeneralPath hexagon;
    private static final double[] angles;
    private static final double r = 3.5;
    private static final int REGULAR = 0;
    private static final int DESTROYED = 1;
    private static final int CREW = 2;
    private static final int STEALTH = 3;

    public HullWidget(Hull h, boolean m) {
        this.theHull = h;
        this.mutable = m;
        this.bounds = new Dimension(0, 0);
        this.setDimensions();
        this.setToolTipText(this.getToolTip());
        if (this.mutable) {
            this.initialiseHullMenu();
            this.addListeners();
        }
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        AffineTransform lastT = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        this.setDimensions();
        g.translate(2, 2);
        this.drawHull(g);
        g.setTransform(lastT);
    }

    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        this.theHull.setHullStrength(ac);
        if (ac.equals("Custom")) {
            int hullMass = this.theHull.getHullSize();
            int hullBoxes = this.theHull.getTotalHull();
            int newRating = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), hullBoxes);
            if (newRating >= 0) {
                this.theHull.setTotalHull(newRating);
                this.theHull.setHull(hullMass);
            }
        } else {
            this.theHull.setHull(this.theHull.getHullSize());
        }
        this.setDimensions();
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popup.show(me.getComponent(), me.getX(), me.getY());
        }
    }

    public void mouseReleased(MouseEvent me) {
        this.mousePressed(me);
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    private void drawHull(Graphics2D g) {
        AffineTransform lastT = g.getTransform();
        String h = this.theHull.toString();
        boolean newRow = false;
        int j = 0;
        block8: for (int i = 0; i < h.length(); ++i) {
            switch (h.charAt(i)) {
                case '-': {
                    newRow = true;
                    this.drawHullBox(g, 1);
                    ++j;
                    g.translate(12, 0);
                    continue block8;
                }
                case '*': {
                    newRow = true;
                    this.drawHullBox(g, 2);
                    ++j;
                    g.translate(12, 0);
                    continue block8;
                }
                case ' ': {
                    if (!newRow) continue block8;
                    g.translate(12, 0);
                    ++j;
                    continue block8;
                }
                case 'o': {
                    newRow = true;
                    this.drawHullBox(g, 0);
                    ++j;
                    g.translate(12, 0);
                    continue block8;
                }
                case 'Q': {
                    newRow = true;
                    this.drawHullBox(g, 3);
                    ++j;
                    g.translate(12, 0);
                    continue block8;
                }
                case '\n': {
                    newRow = false;
                    g.translate(-12 * j, 12);
                    j = 0;
                }
            }
        }
        g.setTransform(lastT);
    }

    private void drawHullBox(Graphics2D g, int code) {
        AffineTransform lastTransform = g.getTransform();
        g.setColor(Color.white);
        g.fill(hullBoxRect);
        g.setColor(Color.black);
        if (code == 1) {
            g.fill(hullBoxRect);
            g.draw(hullBoxRect);
        } else if (code == 3) {
            g.fill(hexagon);
            g.draw(hexagon);
        } else {
            g.draw(hullBoxRect);
            if (code == 2) {
                g.translate(5, 5);
                g.draw(crewStar);
                g.fill(crewStar);
            }
        }
        g.setTransform(lastTransform);
    }

    private void setDimensions() {
        int max_col = 0;
        String h = this.theHull.toString();
        boolean newRow = false;
        int col = 0;
        block5: for (int i = 0; i < h.length(); ++i) {
            switch (h.charAt(i)) {
                case '*': 
                case '-': 
                case 'Q': 
                case 'o': {
                    newRow = true;
                    ++col;
                    continue block5;
                }
                case ' ': {
                    if (newRow) {
                        ++col;
                        continue block5;
                    }
                }
                case '\n': {
                    newRow = false;
                    if (col > max_col) {
                        max_col = col;
                    }
                    col = 0;
                }
            }
        }
        int rows = this.theHull.getNumberOfRows();
        this.bounds.height = rows * 10 + (rows + 1) * 2;
        this.bounds.width = max_col * 10 + (max_col + 1) * 2;
        this.setMinimumSize(this.bounds);
        this.setPreferredSize(this.bounds);
        this.setMaximumSize(this.bounds);
        this.setSize(this.bounds);
    }

    private void initialiseHullMenu() {
        if (this.popup != null) {
            return;
        }
        ButtonGroup bg = new ButtonGroup();
        this.popup = new JPopupMenu();
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem("Fragile", this.theHull.getHullStrength().equals("Fragile"));
        mi.setActionCommand("Fragile");
        mi.addActionListener(this);
        bg.add(mi);
        this.popup.add(mi);
        mi = new JRadioButtonMenuItem("Weak", this.theHull.getHullStrength().equals("Weak"));
        mi.setActionCommand("Weak");
        mi.addActionListener(this);
        bg.add(mi);
        this.popup.add(mi);
        mi = new JRadioButtonMenuItem("Average", this.theHull.getHullStrength().equals("Average"));
        mi.setActionCommand("Average");
        mi.addActionListener(this);
        bg.add(mi);
        this.popup.add(mi);
        mi = new JRadioButtonMenuItem("Strong", this.theHull.getHullStrength().equals("Strong"));
        mi.setActionCommand("Strong");
        mi.addActionListener(this);
        bg.add(mi);
        this.popup.add(mi);
        mi = new JRadioButtonMenuItem("Super", this.theHull.getHullStrength().equals("Super"));
        mi.setActionCommand("Super");
        mi.addActionListener(this);
        bg.add(mi);
        this.popup.add(mi);
        mi = new JRadioButtonMenuItem("Custom...", this.theHull.getHullStrength().equals("Custom"));
        mi.setActionCommand("Custom");
        mi.addActionListener(this);
        bg.add(mi);
        this.popup.add(mi);
    }

    private void addListeners() {
        this.addMouseListener(this);
    }

    private String getToolTip() {
        return "Hull: " + this.theHull.getRemainingHull() + "/" + this.theHull.getTotalHull();
    }

    static {
        angles = new double[]{3.455751918948773, 4.71238898038469, 5.969026041820607, 0.9424777960769379, 2.199114857512855};
        crewStar = new GeneralPath();
        crewStar.reset();
        crewStar.setWindingRule(1);
        crewStar.moveTo((float)(3.5 * Math.cos(angles[0])), (float)(3.5 * Math.sin(angles[0])));
        crewStar.lineTo((float)(3.5 * Math.cos(angles[2])), (float)(3.5 * Math.sin(angles[2])));
        crewStar.lineTo((float)(3.5 * Math.cos(angles[4])), (float)(3.5 * Math.sin(angles[4])));
        crewStar.lineTo((float)(3.5 * Math.cos(angles[1])), (float)(3.5 * Math.sin(angles[1])));
        crewStar.lineTo((float)(3.5 * Math.cos(angles[3])), (float)(3.5 * Math.sin(angles[3])));
        crewStar.closePath();
        hexagon = new GeneralPath();
        hexagon.reset();
        hexagon.moveTo(3.0f, 0.0f);
        hexagon.lineTo(8.0f, 0.0f);
        hexagon.lineTo(11.0f, 5.0f);
        hexagon.lineTo(8.0f, 10.0f);
        hexagon.lineTo(3.0f, 10.0f);
        hexagon.lineTo(0.0f, 5.0f);
        hexagon.closePath();
    }
}

