/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.FighterBay;
import ftjava.std.FighterGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class FighterBayWidget
extends SystemWidget {
    private static final Dimension FIGHTER_BAY_SIZE = new Dimension(30, 40);
    private static final GeneralPath path = new GeneralPath();

    public FighterBayWidget() {
        this(new FighterBay(), true);
    }

    public FighterBayWidget(FighterBay cls) {
        this(cls, false);
    }

    public FighterBayWidget(FighterBay cls, boolean m) {
        super(cls, m);
        this.setPreferredSize(FIGHTER_BAY_SIZE);
        this.setMinimumSize(FIGHTER_BAY_SIZE);
        this.setMaximumSize(FIGHTER_BAY_SIZE);
        this.setSize(FIGHTER_BAY_SIZE);
        this.setToolTipText("Fighter Bay");
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.setColor(Color.white);
        g.fill(path);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(path);
        FighterGroup fg = ((FighterBay)this.theSystem).getLandedFighterGroup();
        if (fg != null) {
            String label = fg.getType().toString().substring(0, 1) + Integer.toString(fg.getCount());
            FontMetrics fm = g.getFontMetrics(g.getFont());
            g.drawString(label, 15 - fm.stringWidth(label) / 2, 25 + fm.getAscent() / 2 - 1);
        }
        SSDDrawingTools.indicateStatus(g, this);
    }

    static {
        path.reset();
        path.moveTo(15.0f, 0.0f);
        path.lineTo(0.0f, 39.0f);
        path.lineTo(30.0f, 39.0f);
        path.closePath();
    }
}

