/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.AntiMatterTorpedoLauncher;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class AntiMatterTorpedoLauncherWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension AMTL_BASE_SIZE = new Dimension(41, 71);
    private static final GeneralPath body = new GeneralPath();
    private static final GeneralPath topFin;
    private static final GeneralPath bottomFin;

    public AntiMatterTorpedoLauncherWidget() {
        this(new AntiMatterTorpedoLauncher(), true);
    }

    public AntiMatterTorpedoLauncherWidget(AntiMatterTorpedoLauncher amtl) {
        this(amtl, false);
    }

    public AntiMatterTorpedoLauncherWidget(AntiMatterTorpedoLauncher amtl, boolean mutable) {
        super(amtl, mutable);
        this.initialiseAMTLMenuItems();
        this.setMinimumSize(AMTL_BASE_SIZE);
        this.setMaximumSize(AMTL_BASE_SIZE);
        this.setPreferredSize(AMTL_BASE_SIZE);
        this.setSize(AMTL_BASE_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        AffineTransform originalTransform = g.getTransform();
        g.translate(AntiMatterTorpedoLauncherWidget.GLYPH_OFFSET.x, AntiMatterTorpedoLauncherWidget.GLYPH_OFFSET.y);
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(topFin);
        g.draw(bottomFin);
        g.fill(topFin);
        g.fill(bottomFin);
        g.setColor(Color.white);
        g.fill(body);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(body);
        g.setTransform(originalTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialiseAMTLMenuItems() {
        if (this.mutable) {
            this.popup.addSeparator();
        }
    }

    private String getToolTip() {
        return "AntiMatter Torpedo Launcher";
    }

    static {
        body.reset();
        body.moveTo(17.0f, 9.0f);
        body.lineTo(20.0f, 13.0f);
        body.lineTo(20.0f, 41.0f);
        body.lineTo(14.0f, 41.0f);
        body.lineTo(14.0f, 13.0f);
        body.closePath();
        topFin = new GeneralPath();
        topFin.reset();
        topFin.moveTo(17.0f, 15.0f);
        topFin.lineTo(24.0f, 24.0f);
        topFin.lineTo(10.0f, 24.0f);
        topFin.closePath();
        bottomFin = new GeneralPath();
        bottomFin.reset();
        bottomFin.moveTo(17.0f, 29.0f);
        bottomFin.lineTo(28.0f, 40.0f);
        bottomFin.lineTo(6.0f, 40.0f);
        bottomFin.closePath();
    }
}

