/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.AreaDefenseTargetList;
import ftjava.gui.PointDefenseTargetList;
import ftjava.gui.Preferences;
import ftjava.gui.RangeSort;
import ftjava.gui.SlaveButton;
import ftjava.gui.TargetAdapter;
import ftjava.gui.TargetList;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.AreaDefenseFireControl;
import ftjava.std.BeamBattery;
import ftjava.std.FireControl;
import ftjava.std.GameEngine;
import ftjava.std.KineticGun;
import ftjava.std.Player;
import ftjava.std.PointDefense;
import ftjava.std.Pulser;
import ftjava.std.Scattergun;
import ftjava.std.Ship;
import ftjava.std.ShipUtilities;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class TargetDialog {
    private Ship ship;
    private GameEngine engine;
    private ArrayList slaveList;
    private ArrayList targets;
    private JDialog dialog = new JDialog();
    private ArrayList allButtons;
    private ArrayList pdsBoxes;
    private ArrayList pulserPdsBoxes;
    public static Icon popButton;
    public static Icon pushButton;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public TargetDialog(GameEngine engine, Ship inship, boolean reset) {
        TargetAdapter a;
        Ship s;
        int j;
        int i;
        Insets targetDialogInsets;
        this.engine = engine;
        this.ship = inship;
        ArrayList allShips = engine.getShips();
        String title = inship.getName();
        if (inship.getRolled()) {
            title = title + "  [Rolled]";
        }
        BufferedImage img = ImageUtilities.getImage("Images/popbutton.gif", this.dialog);
        popButton = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/pushbutton.gif", this.dialog);
        pushButton = new ImageIcon(img);
        this.dialog.setTitle(title);
        this.dialog.setModal(false);
        this.dialog.setResizable(true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.dialog.setLocation(0, d.height / 2);
        this.slaveList = new ArrayList();
        this.allButtons = new ArrayList();
        this.pdsBoxes = new ArrayList();
        this.pulserPdsBoxes = new ArrayList();
        ArrayList weapons = this.ship.getWeaponSystems();
        ArrayList firecontrols = this.ship.getActiveFireControls();
        ArrayList areaDefensefirecontrols = this.ship.getActiveAreaDefenseFireControls();
        ArrayList objectList = engine.getActiveObjects();
        ArrayList hBodyList = engine.getHeavenlyBodies();
        this.targets = new ArrayList();
        Box fcBox = new Box(1);
        JPanel table = new JPanel();
        JScrollPane sPane = new JScrollPane(table);
        table.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int left = 17;
        int center = 10;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = center;
        c.insets = targetDialogInsets = new Insets(2, 4, 2, 4);
        c.gridwidth = 0;
        c.fill = 2;
        table.add((Component)new JSeparator(0), c);
        c.gridwidth = 1;
        c.fill = 0;
        ++c.gridy;
        table.add((Component)new JLabel(" Weapons"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = center;
        table.add((Component)new JLabel("Point Defense"), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.anchor = center;
        Border bd = BorderFactory.createEmptyBorder(0, 15, 0, 20);
        JLabel nn = new JLabel("None");
        nn.setBorder(bd);
        table.add(nn);
        ArrayList sortedTargetList = this.rangeSortShipTargets(engine, this.ship);
        ArrayList sortedADFCList = this.rangeSortShipAreaDefense(engine, this.ship);
        for (i = 0; i < firecontrols.size(); ++i) {
            FireControl firecontrol = (FireControl)firecontrols.get(i);
            TargetList cb = new TargetList(engine, firecontrol);
            this.targets.add(cb);
            cb.addItem(new TargetAdapter(this.ship, null));
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TargetDialog.this.updateButtons();
                }
            });
            ++c.gridx;
            for (j = 0; j < sortedTargetList.size(); ++j) {
                s = (Ship)sortedTargetList.get(j);
                a = new TargetAdapter(this.ship, s);
                cb.addItem(a);
            }
            cb.setSelectedIndex(0);
            String fcString = "FireCon" + (i + 1);
            Box hbox = new Box(0);
            hbox.add(Box.createHorizontalStrut(15));
            hbox.add(new JLabel(fcString));
            hbox.add(Box.createHorizontalStrut(8));
            hbox.add(cb);
            hbox.add(Box.createHorizontalGlue());
            fcBox.add(hbox);
            table.add((Component)new JLabel(fcString), c);
        }
        ++c.gridx;
        table.add((Component)new JLabel("  Weapon Report  "), c);
        for (j = 0; j < weapons.size(); ++j) {
            KineticGun kg;
            BeamBattery bb;
            Weapon w = (Weapon)weapons.get(j);
            boolean class1PDS = false;
            if (w instanceof BeamBattery && (bb = (BeamBattery)w).getRating() == 1) {
                class1PDS = true;
            }
            if (w instanceof KineticGun && (kg = (KineticGun)w).getRating() == 1) {
                class1PDS = true;
            }
            if (w instanceof Pulser) {
                class1PDS = true;
            }
            if (!w.isDirectFire() && !w.isPointDefense()) continue;
            JLabel errorLabel = new JLabel("  ");
            c.weightx = 1.0;
            ++c.gridy;
            c.gridx = 0;
            c.anchor = left;
            table.add((Component)new JLabel(weapons.get(j).toString()), c);
            if (w.isDirectFire()) {
                ButtonGroup bg = new ButtonGroup();
                if (class1PDS) {
                    ++c.gridx;
                    c.anchor = center;
                    PointDefenseTargetList cb = new PointDefenseTargetList(engine, w);
                    cb.setEnabled(w.isOperational());
                    this.targets.add(cb);
                    cb.addItem(new TargetAdapter(this.ship, null));
                    if (w instanceof Pulser) {
                        this.pulserPdsBoxes.add(cb);
                    }
                    for (int k = 0; k < objectList.size(); ++k) {
                        SpaceObject so = (SpaceObject)objectList.get(k);
                        double rangeCheck = engine.getOptions().getPointDefenseRange();
                        if (w instanceof Scattergun) {
                            rangeCheck = engine.getOptions().getScattergunRange();
                        }
                        boolean isTarget = false;
                        if (w instanceof BeamBattery || w instanceof KineticGun) {
                            isTarget = ShipUtilities.isClass1PDSTarget(this.ship, so, rangeCheck);
                        } else if (w instanceof Pulser) {
                            isTarget = ShipUtilities.isPulserPDSTarget(this.ship, so, w.getArcs(), rangeCheck);
                        } else if (w instanceof Scattergun) {
                            isTarget = ShipUtilities.isScattergunTarget(this.ship, so, allShips, rangeCheck);
                        }
                        if (!isTarget) continue;
                        TargetAdapter a2 = new TargetAdapter(this.ship, so);
                        cb.addItem(a2);
                        if (so != w.getTarget()) continue;
                        cb.setSelectedItem(a2);
                    }
                    c.fill = 2;
                    table.add((Component)cb, c);
                    c.fill = 0;
                } else {
                    ++c.gridx;
                }
                SlaveButton radiobutton = new SlaveButton(null, w, null);
                radiobutton.setErrorLabel(errorLabel);
                radiobutton.setBlankMessage();
                this.slaveList.add(radiobutton);
                this.allButtons.add(radiobutton);
                bg.add(radiobutton);
                bg.setSelected(radiobutton.getModel(), true);
                c.weightx = 1.0;
                ++c.gridx;
                c.anchor = center;
                table.add((Component)radiobutton, c);
                for (i = 0; i < firecontrols.size(); ++i) {
                    FireControl fc = (FireControl)firecontrols.get(i);
                    ++c.gridx;
                    radiobutton = new SlaveButton(fc, w, (TargetList)this.targets.get(i));
                    radiobutton.setErrorLabel(errorLabel);
                    bg.add(radiobutton);
                    this.slaveList.add(radiobutton);
                    this.allButtons.add(radiobutton);
                    table.add((Component)radiobutton, c);
                    if (reset || fc != w.getMasterFireControl()) continue;
                    bg.setSelected(radiobutton.getModel(), true);
                }
                c.weightx = 1.0;
                ++c.gridx;
                c.anchor = left;
                table.add((Component)errorLabel, c);
                continue;
            }
            ++c.gridx;
            c.anchor = center;
            if (!w.isOperational()) continue;
            PointDefenseTargetList cb = new PointDefenseTargetList(engine, w);
            this.targets.add(cb);
            this.pdsBoxes.add(cb);
            cb.addItem(new TargetAdapter(this.ship, null));
            for (int k = 0; k < objectList.size(); ++k) {
                TargetAdapter a3;
                SpaceObject so = (SpaceObject)objectList.get(k);
                double rangeCheck = engine.getOptions().getPointDefenseRange();
                if (w instanceof Scattergun) {
                    rangeCheck = engine.getOptions().getScattergunRange();
                }
                if (w instanceof PointDefense) {
                    if (!ShipUtilities.isPDSTarget(this.ship, so, rangeCheck)) continue;
                    a3 = new TargetAdapter(this.ship, so);
                    cb.addItem(a3);
                    if (so != w.getTarget()) continue;
                    cb.setSelectedItem(a3);
                    continue;
                }
                if (!ShipUtilities.isScattergunTarget(this.ship, so, allShips, rangeCheck)) continue;
                a3 = new TargetAdapter(this.ship, so);
                cb.addItem(a3);
                if (so != w.getTarget()) continue;
                cb.setSelectedItem(a3);
            }
            c.fill = 2;
            table.add((Component)cb, c);
            c.fill = 0;
        }
        if (areaDefensefirecontrols.size() > 0) {
            c.weightx = 1.0;
            ++c.gridy;
            c.gridx = 0;
            c.anchor = left;
            table.add((Component)new JLabel("   Area Defense Fire Control"), c);
            for (i = 0; i < areaDefensefirecontrols.size(); ++i) {
                AreaDefenseFireControl adfc = (AreaDefenseFireControl)areaDefensefirecontrols.get(i);
                AreaDefenseTargetList cb = new AreaDefenseTargetList(engine, adfc);
                this.targets.add(cb);
                cb.addItem(new TargetAdapter(this.ship, null));
                cb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TargetDialog.this.updateADFCTargets();
                        TargetDialog.this.updateBoxes();
                    }
                });
                for (j = 0; j < sortedADFCList.size(); ++j) {
                    s = (Ship)sortedADFCList.get(j);
                    a = new TargetAdapter(this.ship, s);
                    cb.addItem(a);
                    if (s.getId() != adfc.getDefendedTargetId()) continue;
                    cb.setSelectedItem(a);
                }
                ++c.gridx;
                c.fill = 2;
                table.add((Component)cb, c);
            }
        }
        JPanel buttonPanel = new JPanel();
        String prop = "Target Confirm at Top";
        if (Preferences.getPreferences().getProperty(prop).equals("true")) {
            buttonPanel.setLayout(new FlowLayout(0));
        } else {
            buttonPanel.setLayout(new FlowLayout(1));
        }
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TargetDialog.this.OKPressed();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TargetDialog.this.CancelPressed();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        this.dialog.getRootPane().setDefaultButton(ok);
        if (Preferences.getPreferences().getProperty(prop).equals("true")) {
            this.dialog.getContentPane().add((Component)buttonPanel, "North");
            this.dialog.getContentPane().add((Component)fcBox, "Center");
            this.dialog.getContentPane().add((Component)sPane, "South");
        } else {
            this.dialog.getContentPane().add((Component)buttonPanel, "South");
            this.dialog.getContentPane().add((Component)fcBox, "North");
            this.dialog.getContentPane().add((Component)sPane, "Center");
        }
        this.dialog.pack();
        this.dialog.setVisible(false);
    }

    public ArrayList rangeSortShipTargets(GameEngine ge, Ship ship) {
        RangeSort rs;
        ArrayList<Object> result = new ArrayList<Object>();
        TreeSet<RangeSort> ts = new TreeSet<RangeSort>();
        Player p = ship.getPlayer();
        ArrayList shipList = ge.getShips();
        for (int j = 0; j < shipList.size(); ++j) {
            Ship s = (Ship)shipList.get(j);
            if (s.getPlayer() == p || s.isDestroyed() || s.hasJumped() || this.blockedLineOfFire(ge, s, ship) || s.getTeam().equals(ship.getTeam())) continue;
            rs = new RangeSort(s, ship.rangeTo(s));
            ts.add(rs);
        }
        Iterator it = ts.iterator();
        while (it.hasNext()) {
            rs = (RangeSort)it.next();
            result.add(rs.getObject());
        }
        return result;
    }

    private boolean blockedLineOfFire(GameEngine ge, Ship s1, Ship s2) {
        boolean blocked = false;
        ArrayList hBodies = ge.getHeavenlyBodies();
        for (int i = 0; i < hBodies.size(); ++i) {
            SpaceObject so = (SpaceObject)hBodies.get(i);
            blocked |= so.intersect(s1, s2);
        }
        return blocked;
    }

    public ArrayList rangeSortShipAreaDefense(GameEngine ge, Ship ship) {
        RangeSort rs;
        ArrayList<Object> result = new ArrayList<Object>();
        TreeSet<RangeSort> ts = new TreeSet<RangeSort>();
        ArrayList shipList = ge.getShips();
        for (int j = 0; j < shipList.size(); ++j) {
            Ship s = (Ship)shipList.get(j);
            if (ship.rangeTo(s) > this.engine.getOptions().getAreaDefenseActivationRange() || s.isDestroyed() || s.hasJumped() || !s.getTeam().equals(ship.getTeam()) || s.equals(ship)) continue;
            rs = new RangeSort(s, ship.rangeTo(s));
            ts.add(rs);
        }
        Iterator it = ts.iterator();
        while (it.hasNext()) {
            rs = (RangeSort)it.next();
            result.add(rs.getObject());
        }
        return result;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void CancelPressed() {
        this.dialog.setVisible(false);
    }

    public void updateButtons() {
        for (int i = 0; i < this.allButtons.size(); ++i) {
            SlaveButton a = (SlaveButton)this.allButtons.get(i);
            if (!a.isSelected()) continue;
            ActionListener[] al = (ActionListener[])a.getListeners(class$java$awt$event$ActionListener == null ? TargetDialog.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener);
            al[0].actionPerformed(new ActionEvent(this, 1, ""));
        }
    }

    public void updateADFCTargets() {
        for (int i = 0; i < this.targets.size(); ++i) {
            Object o = this.targets.get(i);
            if (!(o instanceof AreaDefenseTargetList)) continue;
            AreaDefenseTargetList l = (AreaDefenseTargetList)o;
            l.setDefendedTarget();
        }
    }

    public void updateBoxes() {
        int i;
        ArrayList weapons = this.ship.getWeaponSystems();
        boolean isPDS = false;
        boolean isScattergun = false;
        ArrayList allShips = this.engine.getShips();
        double range = this.engine.getOptions().getPointDefenseRange();
        for (int j = 0; j < weapons.size(); ++j) {
            Weapon w = (Weapon)weapons.get(j);
            if (w instanceof PointDefense) {
                isPDS = true;
                range = this.engine.getOptions().getPointDefenseRange();
            }
            if (w instanceof Scattergun) {
                isScattergun = true;
                range = this.engine.getOptions().getScattergunRange();
            }
            if (!(w instanceof Pulser)) continue;
            range = this.engine.getOptions().getPointDefenseRange();
        }
        ArrayList objectList = this.engine.getActiveObjects();
        ArrayList<SpaceObject> validTargets = new ArrayList<SpaceObject>();
        for (i = 0; i < objectList.size(); ++i) {
            SpaceObject so = (SpaceObject)objectList.get(i);
            if (isPDS) {
                if (!ShipUtilities.isPDSTarget(this.ship, so, range)) continue;
                validTargets.add(so);
                continue;
            }
            if (!isScattergun || !ShipUtilities.isScattergunTarget(this.ship, so, allShips, range)) continue;
            validTargets.add(so);
        }
        for (i = 0; i < this.pdsBoxes.size(); ++i) {
            PointDefenseTargetList cb = (PointDefenseTargetList)this.pdsBoxes.get(i);
            cb.removeAllItems();
            cb.addItem(new TargetAdapter(this.ship, null));
            for (int j = 0; j < validTargets.size(); ++j) {
                cb.addItem(new TargetAdapter(this.ship, (SpaceObject)validTargets.get(j)));
            }
        }
        if (this.pulserPdsBoxes.size() > 0) {
            int index = 0;
            for (int j = 0; j < weapons.size(); ++j) {
                Weapon w = (Weapon)weapons.get(j);
                if (!(w instanceof Pulser)) continue;
                PointDefenseTargetList cb = (PointDefenseTargetList)this.pulserPdsBoxes.get(index++);
                cb.removeAllItems();
                cb.addItem(new TargetAdapter(this.ship, null));
                for (int k = 0; k < objectList.size(); ++k) {
                    SpaceObject so = (SpaceObject)objectList.get(k);
                    boolean isTarget = ShipUtilities.isPulserPDSTarget(this.ship, so, w.getArcs(), this.engine.getOptions().getPointDefenseRange());
                    if (!isTarget) continue;
                    cb.addItem(new TargetAdapter(this.ship, so));
                }
            }
        }
    }

    public void OKPressed() {
        int i;
        this.dialog.setVisible(false);
        ArrayList firecontrols = this.ship.getActiveFireControls();
        for (i = 0; i < firecontrols.size(); ++i) {
            ((FireControl)firecontrols.get(i)).unslaveAllWeapons();
        }
        this.ship.resetTargetsForPDS();
        for (i = 0; i < this.slaveList.size(); ++i) {
            SlaveButton slave = (SlaveButton)this.slaveList.get(i);
            if (!slave.getModel().isSelected()) continue;
            slave.slave();
        }
        for (i = 0; i < this.targets.size(); ++i) {
            JComboBox l;
            Object o = this.targets.get(i);
            if (o instanceof TargetList) {
                l = (TargetList)o;
                ((TargetList)l).setTarget();
            }
            if (o instanceof PointDefenseTargetList) {
                l = (PointDefenseTargetList)o;
                ((PointDefenseTargetList)l).setTarget();
            }
            if (!(o instanceof AreaDefenseTargetList)) continue;
            l = (AreaDefenseTargetList)o;
            ((AreaDefenseTargetList)l).setDefendedTarget();
        }
    }
}

