/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.TargetAdapter;
import ftjava.gui.TargetDialog;
import ftjava.gui.TargetList;
import ftjava.std.FireControl;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

class SlaveButton
extends JRadioButton {
    private static final long serialVersionUID = 1L;
    private TargetList target;
    private FireControl firecontrol;
    private Weapon weapon;
    private JLabel theErrorLabel = null;
    private String message = null;

    public SlaveButton(FireControl fc, Weapon w, TargetList tl) {
        super(TargetDialog.popButton);
        this.firecontrol = fc;
        this.weapon = w;
        this.target = tl;
        this.setEnabled(this.weapon.isOperational());
        this.setSelectedIcon(TargetDialog.pushButton);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SlaveButton.this.message == null) {
                    TargetAdapter ta = (TargetAdapter)SlaveButton.this.target.getSelectedItem();
                    if (ta.s == null) {
                        SlaveButton.this.publishError("  No target!      ");
                        return;
                    }
                    SpaceObject so = ta.s;
                    Ship s = ta.shooter;
                    int fireArc = ta.shooter.arcTo(ta.s);
                    if (!SlaveButton.this.weapon.fireAtTargetArc(fireArc)) {
                        SlaveButton.this.publishError("  Out of arc!     ");
                        return;
                    }
                    if (s.rangeTo(so) > SlaveButton.this.weapon.getMaximumRange()) {
                        SlaveButton.this.publishError("  Out of range!   ");
                        return;
                    }
                    SlaveButton.this.publishError("                ");
                } else {
                    SlaveButton.this.publishError(SlaveButton.this.message);
                }
            }
        });
    }

    public void slave() {
        if (this.firecontrol != null) {
            this.firecontrol.slaveWeapon(this.weapon);
        } else {
            this.weapon.setMasterFireControl(null);
        }
    }

    public void setErrorLabel(JLabel e) {
        this.theErrorLabel = e;
    }

    public void setBlankMessage() {
        this.message = "                ";
    }

    public void publishError(String text) {
        if (this.theErrorLabel != null) {
            this.theErrorLabel.setText(text);
        }
    }
}

