/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ClientProgram;
import ftjava.gui.DamageControlDialog;
import ftjava.gui.GUIAdapter;
import ftjava.gui.LaunchDialog;
import ftjava.gui.Preferences;
import ftjava.gui.ShipGUIAdapter;
import ftjava.gui.StatusDisplay;
import ftjava.gui.TargetDialog;
import ftjava.gui.TextSSD;
import ftjava.gui.TextShipLog;
import ftjava.gui.ssd.SSDWidget;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.Armor;
import ftjava.std.FTLDrive;
import ftjava.std.GameEngine;
import ftjava.std.Hull;
import ftjava.std.MainDrive;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.VapourShroud;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ShipStatusDisplay
extends StatusDisplay {
    private static final long serialVersionUID = 1L;
    private ClientProgram theClient;
    public Ship ship;
    public GameEngine engine;
    private TextSSD textSSD;
    private JFrame guiSSD = null;
    private TextShipLog textLog;
    private JButton TargetButton;
    private JButton DamageControlButton;
    private JButton LaunchButton;
    private JLabel StatusLabel;
    private JLabel HullLabel;
    private JLabel ArmorLabel;
    private JLabel VelocityLabel;
    private JLabel FTLDriveLabel;
    private JLabel ThrustLabel;
    private JLabel HeadingLabel;
    private JLabel PositionLabel;
    private final JCheckBox ShroudBox = new JCheckBox();
    private TargetDialog targetDisplay = null;
    private LaunchDialog launchDisplay = null;
    private DamageControlDialog damageDisplay = null;
    private JTextField PlotEntry;
    private DecimalFormat format;
    private ShipGUIAdapter adapter;
    private boolean resetTargeting = true;
    private boolean resetDamageControl = true;
    private boolean resetLaunchControl = true;
    private final ShipStatusDisplay thisPanel = this;

    public ShipStatusDisplay(ClientProgram parent, GameEngine inEngine, ShipGUIAdapter inAdapter) {
        String className = "";
        boolean ActivePlayerView = false;
        boolean AlliedPlayerView = false;
        boolean EnableEnemyPlot = Preferences.getPreferences().getProperty("Enable Enemy Plotting").equals("true");
        boolean GameMaster2 = false;
        boolean combatPhase = false;
        this.theClient = parent;
        this.engine = inEngine;
        this.adapter = inAdapter;
        this.ship = this.adapter.getShip();
        this.textSSD = null;
        this.format = new DecimalFormat(".0");
        this.targetDisplay = null;
        this.launchDisplay = null;
        JButton bd = new JButton();
        BufferedImage img = ImageUtilities.getImage("Images/alarmon.gif", bd);
        ImageIcon alarm_on = new ImageIcon(img);
        img = ImageUtilities.getImage("Images/alarmoff.gif", bd);
        ImageIcon alarm_off = new ImageIcon(img);
        Player p = this.engine.getActivePlayer();
        if (p == null) {
            GameMaster2 = true;
        }
        if (this.ship.getPlayer() == p) {
            ActivePlayerView = true;
        }
        if (p != null && p.getTeam().equals(this.ship.getPlayer().getTeam())) {
            AlliedPlayerView = true;
        }
        combatPhase = this.engine.isCombatPhase();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 6, 0, 6);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.anchor = 17;
        c.ipadx = 2;
        c.ipady = 2;
        this.add((Component)new JLabel("Name:       "), c);
        ++c.gridx;
        c.gridwidth = 3;
        String labelTitle = this.ship.getClassAbbrev() + " ";
        labelTitle = labelTitle.indexOf("Bogey") != -1 ? labelTitle + this.ship.getName() : this.ship.getName();
        JLabel shipName = new JLabel(labelTitle);
        Font fShipName = new Font("SansSerif", 3, 11);
        shipName.setFont(fShipName);
        this.add((Component)shipName, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.add((Component)new JLabel("Class:      "), c);
        ++c.gridx;
        c.gridwidth = 3;
        className = className + this.ship.getRace() + " " + this.ship.getClassName() + " " + this.ship.getShipClass();
        this.add((Component)new JLabel(className), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Status:     "), c);
        ++c.gridx;
        this.StatusLabel = new JLabel(this.ship.getStatus());
        this.add((Component)this.StatusLabel, c);
        ++c.gridx;
        this.add((Component)new JLabel("Team:       "), c);
        ++c.gridx;
        this.add((Component)new JLabel(this.ship.getTeam()), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("     "), c);
        this.add((Component)new JLabel("Player:     "), c);
        ++c.gridx;
        String playerName = "";
        if (this.ship.getPlayer() != null) {
            playerName = this.ship.getPlayer().getName();
        }
        this.add((Component)new JLabel(playerName), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("     "), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Armor:      "), c);
        ++c.gridx;
        this.ArmorLabel = new JLabel();
        this.add((Component)this.ArmorLabel, c);
        ++c.gridx;
        this.add((Component)new JLabel("Hull:       "), c);
        ++c.gridx;
        this.HullLabel = new JLabel();
        this.add((Component)this.HullLabel, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("     "), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Position:         "), c);
        ++c.gridx;
        this.PositionLabel = new JLabel();
        this.add((Component)this.PositionLabel, c);
        c.gridx = 0;
        ++c.gridy;
        if (this.engine.getOptions().isCinematic()) {
            this.add((Component)new JLabel("Heading:          "), c);
        } else {
            this.add((Component)new JLabel("Heading & Course: "), c);
        }
        ++c.gridx;
        this.HeadingLabel = new JLabel();
        this.add((Component)this.HeadingLabel, c);
        ++c.gridx;
        this.add((Component)new JLabel("Velocity:         "), c);
        ++c.gridx;
        this.VelocityLabel = new JLabel();
        this.add((Component)this.VelocityLabel, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Thrust:           "), c);
        ++c.gridx;
        this.ThrustLabel = new JLabel();
        this.add((Component)this.ThrustLabel, c);
        ++c.gridx;
        this.add((Component)new JLabel("FTL Drive Status: "), c);
        ++c.gridx;
        this.FTLDriveLabel = new JLabel();
        this.add((Component)this.FTLDriveLabel, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("     "), c);
        if (GameMaster2 || ActivePlayerView || EnableEnemyPlot) {
            c.gridx = 0;
            ++c.gridy;
            if (this.engine.getOptions().isCinematic()) {
                this.add((Component)new JLabel("Plot: "), c);
            } else {
                this.add((Component)new JLabel("Vector Plot: "), c);
            }
            ++c.gridx;
            c.gridwidth = 4;
            c.fill = 2;
            this.PlotEntry = new JTextField(15);
            this.add((Component)this.PlotEntry, c);
            this.PlotEntry.addActionListener(this.adapter.getPlotListener(this.PlotEntry));
            this.PlotEntry.getDocument().addDocumentListener(this.adapter.getPlotDocListener(this.PlotEntry));
            this.PlotEntry.setColumns(15);
            c.fill = 0;
            c.gridwidth = 1;
            this.PlotEntry.setText(this.ship.getOrders());
            if (!this.ship.areOrdersValid()) {
                String prop = "Illegal Orders Color";
                String illegalTriple = Preferences.getPreferences().getProperty(prop);
                Color illegalColor = Preferences.parseColor(illegalTriple);
                this.PlotEntry.setBackground(illegalColor);
            } else {
                this.PlotEntry.setBackground(Color.white);
            }
            if (combatPhase || this.ship.isDestroyed() || this.ship.hasJumped() || this.ship.hasStruck()) {
                this.PlotEntry.setEnabled(false);
                this.PlotEntry.setBackground(Color.gray);
            }
        }
        this.updateData();
        if (this.ship.hasVapourShroud()) {
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new JLabel("Activate Shroud: "), c);
            ++c.gridx;
            this.ShroudBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VapourShroud vp = ShipStatusDisplay.this.ship.getVapourShroud();
                    vp.setActive(ShipStatusDisplay.this.ShroudBox.isSelected());
                    ShipStatusDisplay.this.thisPanel.getParent().requestFocus();
                }
            });
            if (this.ship.hasActiveVapourShroud()) {
                this.ShroudBox.setSelected(true);
            }
            if (combatPhase || this.ship.isDestroyed() || this.ship.hasJumped() || this.ship.hasStruck()) {
                this.ShroudBox.setEnabled(false);
            }
            this.add((Component)this.ShroudBox, c);
        }
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("   "), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        JButton b = new JButton("Status");
        this.add((Component)b, c);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShipStatusDisplay.this.ssd();
                ShipStatusDisplay.this.thisPanel.getParent().requestFocus();
            }
        });
        if (GameMaster2 || ActivePlayerView) {
            ++c.gridx;
            if (combatPhase && !this.ship.isDestroyed() && !this.ship.hasJumped() && !this.ship.hasStruck()) {
                this.TargetButton = this.ship.hasMissileSalvoThreat() || this.ship.hasFighterThreat() ? new JButton(" Weapons Targeting", alarm_on) : new JButton(" Weapons Targeting", alarm_off);
                if (this.ship.hasActiveVapourShroud() || this.ship.hasFiredNovaCannon()) {
                    this.TargetButton.setEnabled(false);
                }
                this.add((Component)this.TargetButton, c);
                this.TargetButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ShipStatusDisplay.this.target(ShipStatusDisplay.this.resetTargeting);
                        ShipStatusDisplay.this.resetTargeting = false;
                        ShipStatusDisplay.this.thisPanel.getParent().requestFocus();
                    }
                });
            }
            if (!(combatPhase || this.ship.isDestroyed() || this.ship.hasJumped())) {
                this.DamageControlButton = new JButton("Damage Control");
                if (this.ship.getRepairList().size() == 0) {
                    this.DamageControlButton.setEnabled(false);
                }
                this.add((Component)this.DamageControlButton, c);
                this.DamageControlButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ShipStatusDisplay.this.ssd();
                        ShipStatusDisplay.this.damageControl(ShipStatusDisplay.this.resetDamageControl);
                        ShipStatusDisplay.this.resetDamageControl = false;
                        ShipStatusDisplay.this.thisPanel.getParent().requestFocus();
                    }
                });
                if (this.ship.hasLaunchedWeapons() && !this.ship.hasStruck()) {
                    ++c.gridx;
                    this.LaunchButton = new JButton("Launched Weapons");
                    this.LaunchButton.setEnabled(true);
                    this.add((Component)this.LaunchButton, c);
                    this.LaunchButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ShipStatusDisplay.this.launchControl(ShipStatusDisplay.this.resetLaunchControl);
                            ShipStatusDisplay.this.resetLaunchControl = false;
                            ShipStatusDisplay.this.thisPanel.getParent().requestFocus();
                        }
                    });
                }
            }
        }
        if (GameMaster2 || ActivePlayerView || AlliedPlayerView) {
            c.gridx = 0;
            ++c.gridy;
            JButton bl = new JButton("Ship Log");
            this.add((Component)bl, c);
            bl.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShipStatusDisplay.this.shipLog();
                    ShipStatusDisplay.this.thisPanel.getParent().requestFocus();
                }
            });
        }
    }

    public String toString() {
        return this.ship.toString();
    }

    public GUIAdapter getAdapter() {
        return this.adapter;
    }

    public JTextField getPlotEntry() {
        return this.PlotEntry;
    }

    public void ssd() {
        boolean refresh = false;
        this.ssd(refresh);
    }

    public void ssd(boolean refresh) {
        if (this.guiSSD == null) {
            String frameTitle = this.ship.getClassAbbrev() + " ";
            frameTitle = frameTitle.indexOf("Bogey") == -1 ? frameTitle + this.ship.getName() : this.ship.getName();
            this.guiSSD = new JFrame(frameTitle);
            this.guiSSD.getContentPane().add((Component)new SSDWidget(this.ship, false), "Center");
            this.guiSSD.getContentPane().add((Component)new SSDTitlePanel(this.ship), "South");
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension d = tk.getScreenSize();
            this.guiSSD.setLocation(0, d.height / 2);
            this.guiSSD.pack();
            this.guiSSD.setVisible(true);
        }
        if (!refresh || refresh && this.guiSSD.isVisible()) {
            this.guiSSD.pack();
            this.guiSSD.setVisible(true);
            this.guiSSD.repaint();
        }
    }

    public void shipLog() {
        if (this.textLog == null) {
            this.textLog = new TextShipLog(this.ship);
        }
        this.textLog.pack();
        this.textLog.setVisible(true);
    }

    public void target(boolean reset) {
        boolean hasFTLDrive;
        boolean bl = hasFTLDrive = this.ship.getFTLDrive() != null;
        if (hasFTLDrive && this.ship.getFTLDrive().isActive()) {
            int result = JOptionPane.showConfirmDialog(this, new String[]{"FTL Drive is Active!", "Using weapons will abort the jump sequence!", "Are you sure you want to continue?"}, "FTL Active Warning", 0, 2);
            if (result == 0) {
                this.ship.getFTLDrive().deactivate();
            } else {
                return;
            }
        }
        if (this.targetDisplay == null) {
            this.targetDisplay = new TargetDialog(this.engine, this.ship, reset);
        }
        this.targetDisplay.getDialog().setVisible(true);
    }

    public void damageControl(boolean reset) {
        if (this.damageDisplay == null) {
            this.damageDisplay = new DamageControlDialog(this.engine, this.ship, reset);
        }
        this.damageDisplay.getDialog().setVisible(true);
    }

    public void launchControl(boolean reset) {
        if (this.launchDisplay == null) {
            this.launchDisplay = new LaunchDialog(this.theClient, this.engine, this.ship, this, reset);
        }
        this.launchDisplay.getDialog().setVisible(true);
    }

    public void updateData() {
        this.StatusLabel.setText(this.ship.evaluateShipStatus());
        Hull h = this.ship.getHull();
        this.HullLabel.setText(h.getRemainingHull() + " / " + h.getTotalHull());
        Armor a = this.ship.getArmor();
        this.ArmorLabel.setText(a.getRemainingArmor() + " / " + a.getTotalArmor());
        String posText = "";
        posText = posText + "( " + this.format.format(this.ship.getXPosition());
        posText = posText + ", " + this.format.format(this.ship.getYPosition()) + ") ";
        if (this.ship.getRolled()) {
            posText = posText + "[Rolled]";
        }
        this.PositionLabel.setText(posText);
        if (this.engine.getOptions().isCinematic()) {
            this.HeadingLabel.setText(Integer.toString(this.ship.getHeading()));
            this.VelocityLabel.setText(Integer.toString(this.ship.getSpeed()));
        } else {
            this.HeadingLabel.setText("( " + Integer.toString(this.ship.getHeading()) + " )  " + this.format.format(this.ship.getCourse()));
            this.VelocityLabel.setText(this.format.format(this.ship.getVectorSpeed()));
        }
        MainDrive m = this.ship.getMainDrive();
        if (m != null) {
            this.ThrustLabel.setText(Integer.toString(m.getCurrentThrust()));
        } else {
            this.ThrustLabel.setText(Integer.toString(0));
        }
        FTLDrive f = this.ship.getFTLDrive();
        if (f != null) {
            if (f.isActive() && f.isOperational()) {
                this.FTLDriveLabel.setText("Activated");
            }
            if (f.isRecharged() && f.isOperational()) {
                this.FTLDriveLabel.setText("Available");
            }
            if (!f.isRecharged() && f.isOperational()) {
                int turns = f.getRecharge();
                this.FTLDriveLabel.setText("Recharging (" + turns + " turns)");
            }
            if (f.isDamaged()) {
                this.FTLDriveLabel.setText("Damaged");
            }
            if (f.isDestroyed()) {
                this.FTLDriveLabel.setText("Destroyed");
            }
        } else {
            this.FTLDriveLabel.setText("None");
        }
        if (this.PlotEntry != null) {
            if (this.ship.isMovementRestrictedDueToLaunch()) {
                this.PlotEntry.setText("0");
                this.PlotEntry.setEnabled(false);
            } else if (this.engine.isCombatPhase() || this.ship.isDestroyed() || this.ship.hasJumped() || this.ship.hasStruck()) {
                this.PlotEntry.setEnabled(false);
                this.PlotEntry.setBackground(Color.gray);
            } else {
                this.PlotEntry.setEnabled(true);
            }
            this.ship.setOrders(this.PlotEntry.getText());
            if (!this.ship.areOrdersValid()) {
                String prop = "Illegal Orders Color";
                String illegalTriple = Preferences.getPreferences().getProperty(prop);
                Color illegalColor = Preferences.parseColor(illegalTriple);
                this.PlotEntry.setBackground(illegalColor);
            } else {
                this.PlotEntry.setBackground(Color.white);
            }
            if (!this.PlotEntry.isEnabled()) {
                this.PlotEntry.setBackground(Color.gray);
            }
        }
        if (this.guiSSD != null) {
            this.ssd(true);
        }
        if (this.textSSD != null) {
            this.textSSD.update();
        }
        if (this.textLog != null) {
            this.textLog.update();
        }
    }

    class SSDTitlePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        SSDTitlePanel(Ship theShip) {
            if (theShip != null) {
                this.setLayout(new GridLayout(4, 2));
                String pad = "  ";
                this.setBackground(Color.white);
                this.add(new JLabel("  Class: "));
                this.add(new JLabel(theShip.getClassAbbrev() + " " + theShip.getClassName() + pad));
                this.add(new JLabel("  Race: "));
                this.add(new JLabel(theShip.getRace() + pad));
                this.add(new JLabel("  Mass: "));
                this.add(new JLabel(Integer.toString(theShip.getMass()) + pad));
                this.add(new JLabel("  Point Value: "));
                this.add(new JLabel(Integer.toString(theShip.getPointValue()) + pad));
            }
        }
    }
}

