/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.SystemPallette;
import ftjava.gui.ssd.SSDWidget;
import ftjava.gui.util.IntegerTextField;
import ftjava.std.Screen;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.StealthGenerator;
import ftjava.std.VapourShroud;
import ftjava.std.importer.ImportShip;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ShipDesignEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JMenuBar mainMenuBar;
    private SSDWidget theSSD;
    private JTextField shipNameField;
    private JTextField shipClassField;
    private JTextField raceField;
    private JComboBox classNameField;
    private JComboBox classAbbrevField;
    private IntegerTextField massField;
    private JLabel requiredMassField;
    private JLabel pointField;
    private Ship theShip;
    private boolean isSaved = true;
    private File saveFile = null;
    private int evaluatedMass;
    private int evaluatedPoints;
    private static String[] defaultClassNames = new String[]{"Scout", "Courier", "Corvette", "Frigate", "Destroyer", "Heavy Destroyer", "Light Cruiser", "Patrol Cruiser", "Escort Cruiser", "Heavy Cruiser", "Battlecruiser", "Light Battleship", "Battleship", "Heavy Battleship", "Battledreadnought", "Dreadnought", "Superdreadnought", "Escort Carrier", "Light Carrier", "Heavy Carrier", "Attack Carrier"};
    private static String[] defaultClassAbbrevs = new String[]{"SC", "SC ", "CT", "FF", "DD", "DH", "CL", "CE", "CE ", "CH", "BC", "BC ", "BB", "BDN", "BDN ", "DN", "SDN", "CVE", "CVL", "CVH", "CVA"};

    public ShipDesignEditor(Ship aShip) {
        super(aShip.getName());
        this.theShip = aShip;
        this.updatePointsAndRequiredMass();
        this.shipNameField = new JTextField(this.theShip.getName(), 20);
        this.shipNameField.setMaximumSize(this.shipNameField.getPreferredSize());
        this.shipNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent de) {
            }

            public void insertUpdate(DocumentEvent de) {
                ShipDesignEditor.this.theShip.setName(ShipDesignEditor.this.shipNameField.getText());
                ShipDesignEditor.this.setTitle(ShipDesignEditor.this.shipNameField.getText());
                ShipDesignEditor.this.isSaved = false;
            }

            public void removeUpdate(DocumentEvent de) {
                ShipDesignEditor.this.theShip.setName(ShipDesignEditor.this.shipNameField.getText());
                ShipDesignEditor.this.setTitle(ShipDesignEditor.this.shipNameField.getText());
                ShipDesignEditor.this.isSaved = false;
            }
        });
        this.shipClassField = new JTextField(this.theShip.getClassName(), 20);
        this.shipClassField.setMaximumSize(this.shipClassField.getPreferredSize());
        this.shipClassField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent de) {
            }

            public void insertUpdate(DocumentEvent de) {
                ShipDesignEditor.this.theShip.setClassName(ShipDesignEditor.this.shipClassField.getText());
                ShipDesignEditor.this.isSaved = false;
            }

            public void removeUpdate(DocumentEvent de) {
                ShipDesignEditor.this.theShip.setClassName(ShipDesignEditor.this.shipClassField.getText());
                ShipDesignEditor.this.isSaved = false;
            }
        });
        this.raceField = new JTextField(this.theShip.getRace(), 20);
        this.raceField.setMaximumSize(this.shipClassField.getPreferredSize());
        this.raceField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent de) {
            }

            public void insertUpdate(DocumentEvent de) {
                ShipDesignEditor.this.theShip.setRace(ShipDesignEditor.this.raceField.getText());
                ShipDesignEditor.this.isSaved = false;
            }

            public void removeUpdate(DocumentEvent de) {
                ShipDesignEditor.this.theShip.setRace(ShipDesignEditor.this.raceField.getText());
                ShipDesignEditor.this.isSaved = false;
            }
        });
        this.classNameField = new JComboBox<String>(defaultClassNames);
        this.classNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.this.classAbbrevField.setSelectedIndex(ShipDesignEditor.this.classNameField.getSelectedIndex());
                ShipDesignEditor.this.theShip.setShipClass((String)ShipDesignEditor.this.classNameField.getSelectedItem());
                ShipDesignEditor.this.isSaved = false;
            }
        });
        this.classAbbrevField = new JComboBox<String>(defaultClassAbbrevs);
        this.classAbbrevField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.this.classNameField.setSelectedIndex(ShipDesignEditor.this.classAbbrevField.getSelectedIndex());
                ShipDesignEditor.this.theShip.setClassAbbrev((String)ShipDesignEditor.this.classAbbrevField.getSelectedItem());
                ShipDesignEditor.this.isSaved = false;
            }
        });
        int classNameIndex = -1;
        String className = this.theShip.getShipClass();
        for (int i = 0; i < defaultClassNames.length; ++i) {
            if (!className.equals(defaultClassNames[i])) continue;
            classNameIndex = i;
            break;
        }
        if (classNameIndex >= 0) {
            this.classNameField.setSelectedIndex(classNameIndex);
            this.classAbbrevField.setSelectedIndex(classNameIndex);
        }
        this.massField = new IntegerTextField(5, this.theShip.getMass());
        this.massField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int newMass = Integer.parseInt(ShipDesignEditor.this.massField.getText());
                ShipDesignEditor.this.theShip.getHull().setHull(newMass);
                ShipDesignEditor.this.theSSD.repaint();
                ShipDesignEditor.this.updatePointsAndRequiredMass();
                ShipDesignEditor.this.pointField.setText(Integer.toString(ShipDesignEditor.this.evaluatedPoints));
                ShipDesignEditor.this.theShip.setPointValue(ShipDesignEditor.this.evaluatedPoints);
                ShipDesignEditor.this.requiredMassField.setText(Integer.toString(ShipDesignEditor.this.evaluatedMass));
                ShipDesignEditor.this.isSaved = false;
            }
        });
        this.massField.setMaximumSize(this.massField.getPreferredSize());
        this.requiredMassField = new JLabel(Integer.toString(this.evaluatedMass));
        this.pointField = new JLabel("" + this.theShip.getPointValue(), 4);
        Box v_pane = new Box(1);
        Box h_pane = new Box(0);
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(new JLabel("Name", 2));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(Box.createHorizontalGlue());
        h_pane.add(this.shipNameField);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(h_pane);
        h_pane = new Box(0);
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(new JLabel("Ship Class", 2));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(Box.createHorizontalGlue());
        h_pane.add(this.shipClassField);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(h_pane);
        h_pane = new Box(0);
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(new JLabel("Race", 2));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(Box.createHorizontalGlue());
        h_pane.add(this.raceField);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(h_pane);
        h_pane = new Box(0);
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(new JLabel("Class Name", 2));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(this.classNameField);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(h_pane);
        h_pane = new Box(0);
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(new JLabel("Class Short Name", 2));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(Box.createHorizontalGlue());
        h_pane.add(this.classAbbrevField);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(h_pane);
        h_pane = new Box(0);
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(new JLabel("Mass", 2));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(Box.createHorizontalGlue());
        h_pane.add(this.massField);
        h_pane.add(new JLabel("/"));
        h_pane.add(this.requiredMassField);
        h_pane.add(Box.createHorizontalStrut(10));
        JButton autoMassButton = new JButton("Auto");
        autoMassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.this.autoMass();
                ShipDesignEditor.this.theSSD.repaint();
                String newMass = Integer.toString(ShipDesignEditor.this.evaluatedMass);
                ShipDesignEditor.this.pointField.setText(Integer.toString(ShipDesignEditor.this.evaluatedPoints));
                ShipDesignEditor.this.massField.setText(newMass);
                ShipDesignEditor.this.requiredMassField.setText(newMass);
                ShipDesignEditor.this.theShip.setPointValue(ShipDesignEditor.this.evaluatedPoints);
                ShipDesignEditor.this.isSaved = false;
            }
        });
        h_pane.add(autoMassButton);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(h_pane);
        h_pane = new Box(0);
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(new JLabel("Nominal Points Value", 2));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(Box.createHorizontalGlue());
        h_pane.add(this.pointField);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(h_pane);
        v_pane.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)v_pane, "West");
        v_pane = new Box(1);
        h_pane = new Box(0);
        this.theSSD = new SSDWidget(this.theShip, true);
        this.theSSD.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        h_pane.add(Box.createHorizontalStrut(10));
        h_pane.add(this.theSSD);
        h_pane.add(Box.createHorizontalStrut(10));
        v_pane.add(Box.createVerticalStrut(10));
        v_pane.add(h_pane);
        v_pane.add(Box.createVerticalStrut(10));
        this.getContentPane().add((Component)v_pane, "Center");
        this.addWindowListener(SystemPallette.SYSTEMS);
        this.initialiseMenus();
    }

    private void autoMass() {
        int iterCount;
        this.updatePointsAndRequiredMass();
        int currentMass = this.theShip.getMass();
        for (iterCount = 0; currentMass != this.evaluatedMass && iterCount < 25; ++iterCount) {
            currentMass = this.evaluatedMass;
            this.theShip.getHull().setHull(this.evaluatedMass);
            this.updatePointsAndRequiredMass();
        }
        if (iterCount == 25) {
            JOptionPane.showMessageDialog(this, new String[]{"Automatic Calculation of mass failed.", "The total percentage of the ship's mass required by systems may exceed 100%."}, "Warning", 2);
        }
        this.isSaved = false;
    }

    private void updatePointsAndRequiredMass() {
        ShipSystem s;
        int i;
        this.evaluatedMass = 0;
        this.evaluatedPoints = 0;
        int mass = this.theShip.getMass();
        this.evaluatedMass += this.theShip.getHull().computeMass();
        this.evaluatedPoints += this.theShip.getHull().computePointCost();
        this.evaluatedMass += this.theShip.getArmor().computeMass();
        this.evaluatedPoints += this.theShip.getArmor().computePointCost();
        if (this.theShip.getMainDrive() != null) {
            this.evaluatedMass += this.theShip.getMainDrive().computeMass(mass);
            this.evaluatedPoints += this.theShip.getMainDrive().computePointCost(mass);
        }
        if (this.theShip.getFTLDrive() != null) {
            this.evaluatedMass += this.theShip.getFTLDrive().computeMass(mass);
            this.evaluatedPoints += this.theShip.getFTLDrive().computePointCost(mass);
        }
        ArrayList sysList = this.theShip.getElectronicsSystems();
        for (i = 0; i < sysList.size(); ++i) {
            s = (ShipSystem)sysList.get(i);
            this.evaluatedMass += s.computeMass();
            this.evaluatedPoints += s.computePointCost();
        }
        sysList = this.theShip.getDefenseSystems();
        for (i = 0; i < sysList.size(); ++i) {
            s = (ShipSystem)sysList.get(i);
            if (s instanceof Screen) {
                this.evaluatedMass += ((Screen)s).computeMass(mass);
                this.evaluatedPoints += ((Screen)s).computePointCost(mass);
                continue;
            }
            if (s instanceof StealthGenerator) {
                this.evaluatedMass += ((StealthGenerator)s).computeMass(mass);
                this.evaluatedPoints += ((StealthGenerator)s).computePointCost(mass);
                continue;
            }
            if (s instanceof VapourShroud) {
                this.evaluatedMass += ((VapourShroud)s).computeMass(mass);
                this.evaluatedPoints += ((VapourShroud)s).computePointCost(mass);
                continue;
            }
            this.evaluatedMass += s.computeMass();
            this.evaluatedPoints += s.computePointCost();
        }
        sysList = this.theShip.getShipHolds();
        for (i = 0; i < sysList.size(); ++i) {
            s = (ShipSystem)sysList.get(i);
            this.evaluatedMass += s.computeMass();
            this.evaluatedPoints += s.computePointCost();
        }
        sysList = this.theShip.getWeaponSystems();
        for (i = 0; i < sysList.size(); ++i) {
            s = (ShipSystem)sysList.get(i);
            this.evaluatedMass += s.computeMass();
            this.evaluatedPoints += s.computePointCost();
        }
    }

    public SSDWidget getSSD() {
        return this.theSSD;
    }

    static void createNew() {
        ShipDesignEditor theShipFrame = new ShipDesignEditor(new Ship());
        if (!SystemPallette.SYSTEMS.isVisible()) {
            SystemPallette.SYSTEMS.setVisible(true);
        }
        theShipFrame.pack();
        theShipFrame.setVisible(true);
    }

    static void openShipFromFile() {
        if (!SystemPallette.SYSTEMS.isVisible()) {
            SystemPallette.SYSTEMS.setVisible(true);
        }
        FileDialog fChooser = new FileDialog((Frame)SystemPallette.SYSTEMS, "Open a Ship XML File", 0);
        fChooser.setVisible(true);
        if (fChooser.getFile() != null) {
            try {
                File theFile = new File(fChooser.getDirectory(), fChooser.getFile());
                Ship aShip = ImportShip.readShip(theFile);
                ShipDesignEditor theShipFrame = new ShipDesignEditor(aShip);
                theShipFrame.setFile(theFile);
                theShipFrame.pack();
                theShipFrame.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error reading " + fChooser.getFile(), "File Read Error!", 0);
            }
        }
    }

    void closeShip() {
        if (!this.isSaved) {
            int ans = JOptionPane.showConfirmDialog(this, "This ship has not been saved. Would you like to save it?", "File Not Saved", 1, 3);
            switch (ans) {
                case -1: 
                case 2: {
                    return;
                }
                case 0: {
                    this.saveShip();
                }
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    void saveShip() {
        if (this.saveFile == null) {
            FileDialog fChooser = new FileDialog((Frame)this, "Save File as XML", 1);
            fChooser.setFile(this.shipNameField.getText() + ".xml");
            fChooser.setVisible(true);
            if (fChooser.getFile() != null) {
                try {
                    this.saveFile = new File(fChooser.getDirectory(), fChooser.getFile());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error opening " + fChooser.getFile() + " for writing", "File Open Error!", 0);
                }
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.saveFile);
            PrintWriter out = new PrintWriter(fos);
            out.println("<?xml version=\"1.0\" standalone=\"yes\" ?>");
            out.println(this.theShip.toXML());
            out.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error writing " + this.saveFile.getAbsolutePath(), "File Write Error!", 0);
        }
        this.isSaved = true;
    }

    void saveShipAs() {
        FileDialog fChooser = new FileDialog((Frame)this, "Save File as XML", 1);
        fChooser.setFile(this.shipNameField.getText() + ".xml");
        fChooser.setVisible(true);
        if (fChooser.getFile() != null) {
            try {
                this.saveFile = new File(fChooser.getDirectory(), fChooser.getFile());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error opening " + fChooser.getFile() + " for writing", "File Open Error!", 0);
            }
        }
        this.saveShip();
    }

    private void setFile(File theFile) {
        this.saveFile = theFile;
    }

    private void initialiseMenus() {
        this.mainMenuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem mi = new JMenuItem("New");
        mi.setAccelerator(KeyStroke.getKeyStroke(78, 4));
        fileMenu.add(mi).setEnabled(true);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.createNew();
            }
        });
        mi = new JMenuItem("Open...");
        mi.setAccelerator(KeyStroke.getKeyStroke(79, 4));
        fileMenu.add(mi).setEnabled(true);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.openShipFromFile();
            }
        });
        mi = new JMenuItem("Close");
        mi.setAccelerator(KeyStroke.getKeyStroke(87, 4));
        fileMenu.add(mi).setEnabled(true);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.this.closeShip();
            }
        });
        mi = new JMenuItem("Save");
        mi.setAccelerator(KeyStroke.getKeyStroke(83, 4));
        fileMenu.add(mi).setEnabled(true);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.this.saveShip();
            }
        });
        mi = new JMenuItem("Save As...");
        fileMenu.add(mi).setEnabled(true);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShipDesignEditor.this.saveShipAs();
            }
        });
        this.mainMenuBar.add(fileMenu);
        this.setJMenuBar(this.mainMenuBar);
    }
}

