/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ScenarioGameEditor;
import ftjava.gui.ScenarioPlayerEditor;
import ftjava.gui.ScenarioShipEditor;
import ftjava.gui.StarMap;
import ftjava.gui.util.FileChooser;
import ftjava.std.GameEngine;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.importer.ImportGameEngine;
import ftjava.std.importer.ImportShip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ScenarioEditor {
    private GameEngine scenario = new GameEngine();
    private File scenarioFile = null;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected DefaultMutableTreeNode root;
    protected DefaultTreeModel model;
    protected JTree tree;
    protected JFrame frame;
    protected StarMap map;
    protected ScenarioShipEditor shipEditor;
    protected boolean Modified;

    public ScenarioEditor(File f) {
        if (f != null) {
            ImportGameEngine ige = new ImportGameEngine();
            try {
                this.scenario = ige.readGameEngine(new BufferedInputStream(new ProgressMonitorInputStream(null, "Reading " + f.getName(), new FileInputStream(f))));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error opening\n" + f + "\n" + e, "Error", 0);
                return;
            }
        }
        this.shipEditor = new ScenarioShipEditor(this);
        this.frame = new JFrame("Scenario Editor");
        this.frame.addWindowListener(new closeListener());
        this.frame.setDefaultCloseOperation(0);
        this.root = new DefaultMutableTreeNode(this.scenario);
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.tree.addMouseListener(new clickListener());
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.initTree();
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        JButton newTeamButton = new JButton("New Team");
        newTeamButton.setAlignmentX(0.5f);
        newTeamButton.addActionListener(new addTeamAction());
        JButton newPlayerButton = new JButton("New Player");
        newPlayerButton.setAlignmentX(0.5f);
        newPlayerButton.addActionListener(new addPlayerAction());
        JButton newShipButton = new JButton("New Ship");
        newShipButton.setAlignmentX(0.5f);
        newShipButton.addActionListener(new addShipAction());
        JButton editButton = new JButton("Edit");
        editButton.setAlignmentX(0.5f);
        editButton.addActionListener(new editAction());
        JButton removeButton = new JButton("Remove");
        removeButton.setAlignmentX(0.5f);
        removeButton.addActionListener(new removeAction());
        JButton saveButton = new JButton("Save");
        saveButton.setAlignmentX(0.5f);
        saveButton.addActionListener(new saveAction());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 10.0;
        gbc.weighty = 10.0;
        gbc.fill = 2;
        panel.add((Component)newTeamButton, gbc);
        ++gbc.gridy;
        panel.add((Component)newPlayerButton, gbc);
        ++gbc.gridy;
        panel.add((Component)newShipButton, gbc);
        ++gbc.gridy;
        panel.add((Component)editButton, gbc);
        ++gbc.gridy;
        panel.add((Component)removeButton, gbc);
        ++gbc.gridy;
        panel.add((Component)saveButton, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weightx = 1000.0;
        gbc.weighty = 1000.0;
        panel.add((Component)new JLabel(" "), gbc);
        this.frame.getContentPane().add((Component)panel, "East");
        this.frame.setSize(420, 320);
        this.frame.setVisible(true);
        this.map = new StarMap(this.scenario, null);
        this.map.addWindowListener(new closeListener());
        this.map.setDefaultCloseOperation(0);
        this.map.setVisible(true);
        this.setModified(false);
    }

    protected void setTitle() {
        String title = this.isModified() ? "* " + this.scenario.toString() : this.scenario.toString();
        this.frame.setTitle(title);
    }

    protected void modified() {
        this.Modified = true;
        this.setTitle();
    }

    protected void setModified(boolean m) {
        this.Modified = m;
        this.setTitle();
    }

    protected boolean isModified() {
        return this.Modified;
    }

    public void initTree() {
        Iterator teamIt = this.scenario.getTeams().keySet().iterator();
        while (teamIt.hasNext()) {
            String team = (String)teamIt.next();
            DefaultMutableTreeNode teamNode = new DefaultMutableTreeNode(team);
            this.model.insertNodeInto(teamNode, this.root, 0);
            this.tree.scrollPathToVisible(new TreePath(teamNode.getPath()));
            ArrayList<Player> players = new ArrayList<Player>();
            Iterator playerIt = this.scenario.getPlayers().iterator();
            while (playerIt.hasNext()) {
                Player p = (Player)playerIt.next();
                if (!p.getTeam().equals(team) || players.contains(p)) continue;
                players.add(p);
            }
            for (int i = 0; i < players.size(); ++i) {
                Player p = (Player)players.get(i);
                DefaultMutableTreeNode playerNode = new DefaultMutableTreeNode(p);
                this.model.insertNodeInto(playerNode, teamNode, 0);
                this.tree.scrollPathToVisible(new TreePath(playerNode.getPath()));
                Iterator shipIt = p.getShips().iterator();
                while (shipIt.hasNext()) {
                    DefaultMutableTreeNode shipNode = new DefaultMutableTreeNode((Ship)shipIt.next());
                    this.model.insertNodeInto(shipNode, playerNode, 0);
                    this.tree.scrollPathToVisible(new TreePath(shipNode.getPath()));
                }
            }
        }
    }

    public void redraw() {
        this.map.repaint();
    }

    public void addNewPlayer() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null || path.getPathCount() < 2) {
            this.toolkit.beep();
            return;
        }
        DefaultMutableTreeNode teamNode = (DefaultMutableTreeNode)path.getPathComponent(1);
        String team = (String)teamNode.getUserObject();
        Player player = new Player();
        player.setName("New Player " + this.scenario.getPlayers().size());
        player.setTeam(team);
        this.scenario.addPlayer(player);
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(player);
        this.model.insertNodeInto(child, teamNode, 0);
        this.tree.scrollPathToVisible(new TreePath(child.getPath()));
        ScenarioPlayerEditor playerEditor = new ScenarioPlayerEditor(player, this);
        this.modified();
    }

    public void cleanUp() {
    }

    public void save() {
        File file = FileChooser.getSaveFile(this.frame, "Save scenario");
        if (file == null) {
            return;
        }
        try {
            this.scenario.saveToScenarioFile(file);
            this.setModified(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Error opening\n" + file + "\n" + e, "Error", 0);
        }
    }

    public void shipChanged(Ship s) {
        this.map.setActiveSelection(s);
        this.objectChanged(s);
        this.map.recalculate();
    }

    public void objectChanged(Object o) {
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        this.modified();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.getUserObject() != o) continue;
            this.model.nodeChanged(node);
            return;
        }
    }

    public void remove() {
        boolean removed = false;
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.toolkit.beep();
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        if (o instanceof GameEngine) {
            this.toolkit.beep();
            return;
        }
        if (o instanceof Player) {
            Player p = (Player)o;
            if (this.confirm("Remove player " + p.getName() + " and all ships?")) {
                this.scenario.removePlayer((Player)o, true);
                this.model.removeNodeFromParent(node);
                removed = true;
            }
        }
        if (o instanceof String) {
            String team = (String)o;
            if (this.confirm("Remove team " + team + ", all players and all ships?")) {
                removed = true;
                ArrayList<Player> l = new ArrayList<Player>();
                Iterator i = this.scenario.getPlayers().iterator();
                while (i.hasNext()) {
                    Player p = (Player)i.next();
                    if (!p.getTeam().equals(team)) continue;
                    l.add(p);
                }
                i = l.iterator();
                while (i.hasNext()) {
                    this.scenario.removePlayer((Player)i.next(), true);
                }
                this.model.removeNodeFromParent(node);
            }
        }
        if (o instanceof Ship) {
            removed = true;
            Ship s = (Ship)o;
            s.getPlayer().removeShip(s);
            this.scenario.removeShip(s);
            this.model.removeNodeFromParent(node);
        }
        if (removed) {
            this.map.loadAdapters();
            this.map.repaint();
            this.modified();
        }
    }

    protected boolean confirm(String message) {
        int choice = JOptionPane.showConfirmDialog(null, message, "Confirm", 0);
        return choice == 0;
    }

    public void edit() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.toolkit.beep();
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        if (o instanceof GameEngine) {
            ScenarioGameEditor scenarioEditor = new ScenarioGameEditor((GameEngine)o, this);
            this.model.nodeChanged(node);
            this.modified();
        }
        if (o instanceof Ship) {
            this.shipEditor.setShip((Ship)o);
            this.shipEditor.show();
        }
        if (o instanceof Player) {
            ScenarioPlayerEditor playerEditor = new ScenarioPlayerEditor((Player)o, this);
            this.model.nodeChanged(node);
            this.modified();
        }
        if (o instanceof String) {
            String oldteam = (String)o;
            String team = JOptionPane.showInputDialog("New Team Name: ");
            if (team != null && !team.equals("")) {
                Iterator p = this.scenario.getPlayers().iterator();
                while (p.hasNext()) {
                    Player player = (Player)p.next();
                    if (player.getTeam() != oldteam) continue;
                    player.setTeam(team);
                }
                node.setUserObject(team);
                this.model.nodeChanged(node);
                this.modified();
            }
        }
    }

    public void addNewShip() {
        Ship ship;
        TreePath path = this.tree.getSelectionPath();
        if (path == null || path.getPathCount() < 3) {
            this.toolkit.beep();
            return;
        }
        DefaultMutableTreeNode playerNode = (DefaultMutableTreeNode)path.getPathComponent(2);
        System.out.println("Found player: " + playerNode.getUserObject());
        File file = FileChooser.getLoadFile(this.frame, "Load Ship");
        if (file == null) {
            return;
        }
        try {
            ship = ImportShip.readShip(file);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Error opening\n" + file + "\n" + e, "Error", 0);
            return;
        }
        if (ship.getName() == null || ship.getName().equals("")) {
            ship.setName("Unnamed");
        }
        ship.setName(this.generateUniqueShipName(ship.getName()));
        Player player = (Player)playerNode.getUserObject();
        ship.setPlayer(player);
        ship.setGameEngine(this.scenario);
        player.Ships.add(ship);
        this.scenario.addShip(ship);
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(ship);
        this.model.insertNodeInto(child, playerNode, 0);
        this.tree.scrollPathToVisible(new TreePath(child.getPath()));
        this.map.loadAdapters();
        this.map.repaint();
        this.modified();
    }

    public String generateUniqueShipName(String name) {
        boolean unique = false;
        int counter = 1;
        String OldName = name;
        while (!unique) {
            unique = true;
            Iterator i = this.scenario.getShips().iterator();
            while (i.hasNext()) {
                Ship s = (Ship)i.next();
                if (!OldName.equals(s.getName())) continue;
                unique = false;
                break;
            }
            if (unique) continue;
            OldName = name + " " + counter;
            ++counter;
        }
        return OldName;
    }

    public void addNewTeam() {
        String team = JOptionPane.showInputDialog("New Team Name: ");
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(team);
        this.model.insertNodeInto(child, this.root, this.root.getChildCount());
        this.tree.scrollPathToVisible(new TreePath(child.getPath()));
        this.modified();
    }

    class closeListener
    extends WindowAdapter {
        closeListener() {
        }

        public void windowClosing(WindowEvent e) {
            boolean close = true;
            if (ScenarioEditor.this.isModified()) {
                int choice = JOptionPane.showConfirmDialog(null, "Scenario is modified, close anyway?", "Close modified scenario", 0);
                boolean bl = close = choice == 0;
            }
            if (close) {
                ScenarioEditor.this.map.cleanUp();
                ScenarioEditor.this.cleanUp();
                ScenarioEditor.this.map.dispose();
                ScenarioEditor.this.frame.dispose();
            }
        }
    }

    class clickListener
    extends MouseAdapter {
        clickListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = ScenarioEditor.this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath path = ScenarioEditor.this.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            if (o instanceof Ship && e.getClickCount() == 2 && selRow != -1) {
                ScenarioEditor.this.edit();
            }
            if (o instanceof Ship && e.getClickCount() == 1) {
                ScenarioEditor.this.map.setActiveSelection((Ship)o);
            }
        }
    }

    class saveAction
    implements ActionListener {
        saveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ScenarioEditor.this.save();
        }
    }

    class removeAction
    implements ActionListener {
        removeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ScenarioEditor.this.remove();
        }
    }

    class editAction
    implements ActionListener {
        editAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ScenarioEditor.this.edit();
        }
    }

    class addShipAction
    implements ActionListener {
        addShipAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ScenarioEditor.this.addNewShip();
        }
    }

    class addPlayerAction
    implements ActionListener {
        addPlayerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ScenarioEditor.this.addNewPlayer();
        }
    }

    class addTeamAction
    implements ActionListener {
        addTeamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ScenarioEditor.this.addNewTeam();
        }
    }
}

