/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.PreferencesPanel;
import ftjava.util.UserPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class Preferences
extends UserPreferences {
    private static PreferencesPanel mailPref;
    private static PreferencesPanel starMapPref;
    private static PreferencesPanel ordersPref;
    private static PreferencesPanel statusPref;
    private static PreferencesPanel specialPref;
    private static Hashtable hashTable;

    public static Color parseColor(String pref) {
        StringTokenizer st = new StringTokenizer(pref, ",");
        int red = Integer.parseInt(st.nextToken());
        int green = Integer.parseInt(st.nextToken());
        int blue = Integer.parseInt(st.nextToken());
        return new Color(red, green, blue);
    }

    public static Font parseFont(String family, String type, String size) {
        int flags = 0;
        int intSize = Integer.parseInt(size);
        if (type.equals("Plain")) {
            flags = 0;
        } else if (type.equals("Bold")) {
            flags = 1;
        } else if (type.equals("Italic")) {
            flags = 2;
        } else if (type.equals("Bold-Italic")) {
            flags = 3;
        }
        return new Font(family, flags, intSize);
    }

    public static String convertColor(Color c) {
        return new String(c.getRed() + "," + c.getGreen() + "," + c.getBlue());
    }

    public static void printPreferences(Hashtable hash) {
        System.out.println("Table size = " + hash.size());
        Enumeration testKeys = hash.keys();
        while (testKeys.hasMoreElements()) {
            String test;
            String results = test = (String)testKeys.nextElement();
            Object o = hash.get(test);
            JTextField tf = null;
            JPasswordField pf = null;
            JButton cb = null;
            JCheckBox hb = null;
            JComboBox db = null;
            String content = null;
            if (o instanceof JTextField) {
                tf = (JTextField)o;
                content = tf.getText();
            } else if (o instanceof JPasswordField) {
                pf = (JPasswordField)o;
                char[] password = pf.getPassword();
                content = new String(password);
            } else if (o instanceof JCheckBox) {
                hb = (JCheckBox)o;
                content = hb.isSelected() ? "true" : "false";
            } else if (o instanceof JComboBox) {
                db = (JComboBox)o;
                content = (String)db.getSelectedItem();
            } else if (o instanceof JButton) {
                cb = (JButton)o;
                Color v = cb.getBackground();
                content = Preferences.convertColor(v);
            }
            while (results.length() < 35) {
                results = results + " ";
            }
            results = results + content;
            System.out.println(results);
        }
        System.out.println();
    }

    public static void setPreferences(Hashtable hash) {
        Properties prefs = Preferences.getPreferences();
        Enumeration keys = hash.keys();
        while (keys.hasMoreElements()) {
            String test = (String)keys.nextElement();
            Object o = hash.get(test);
            JTextField tf = null;
            JPasswordField pf = null;
            JButton cb = null;
            JCheckBox hb = null;
            JComboBox db = null;
            String content = null;
            if (o instanceof JTextField) {
                tf = (JTextField)o;
                content = tf.getText();
            } else if (o instanceof JPasswordField) {
                pf = (JPasswordField)o;
                char[] password = pf.getPassword();
                content = new String(password);
            } else if (o instanceof JCheckBox) {
                hb = (JCheckBox)o;
                content = hb.isSelected() ? "true" : "false";
            } else if (o instanceof JComboBox) {
                db = (JComboBox)o;
                content = (String)db.getSelectedItem();
            } else if (o instanceof JButton) {
                cb = (JButton)o;
                Color v = cb.getBackground();
                content = Preferences.convertColor(v);
            }
            prefs.setProperty(test, content);
        }
    }

    public static void savePreferences() {
        File f = Preferences.getPreferencesFile();
        try {
            preferences.store(new FileOutputStream(f), "FTJava Preferences file version 4.0");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error opening\n" + f + "\n" + e, "Error", 0);
            e.printStackTrace();
        }
    }

    public static void doPreferences() {
        final JDialog dialog = new JDialog();
        dialog.setModal(true);
        dialog.setTitle("FTJava Client Preferences");
        dialog.setSize(400, 640);
        dialog.setLocation(100, 50);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        Container cp = dialog.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel south = new JPanel();
        JButton okBut = new JButton(" OK ");
        JButton closeBut = new JButton(" Close ");
        okBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Preferences.setPreferences(hashTable);
                Preferences.savePreferences();
                dialog.dispose();
            }
        });
        closeBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        b.add(okBut);
        b.add(Box.createHorizontalStrut(20));
        b.add(closeBut);
        b.add(Box.createHorizontalGlue());
        south.add(b);
        hashTable = new Hashtable();
        JTabbedPane center = new JTabbedPane();
        JScrollPane view = new JScrollPane(center);
        mailPref = new PreferencesPanel(mailKeys, preferences, hashTable);
        starMapPref = new PreferencesPanel(starMapKeys, preferences, hashTable);
        ordersPref = new PreferencesPanel(ordersKeys, preferences, hashTable);
        statusPref = new PreferencesPanel(statusKeys, preferences, hashTable);
        specialPref = new PreferencesPanel(specialKeys, preferences, hashTable);
        center.add("Mail", mailPref);
        center.add("StarMap", starMapPref);
        center.add("Orders", ordersPref);
        center.add("Ship Status", statusPref);
        center.add("Misc.", specialPref);
        cp.add((Component)south, "South");
        cp.add((Component)view, "Center");
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("com.apple.hwaccel", "false");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        Preferences.doPreferences();
    }
}

