/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.AboutFTJava;
import ftjava.gui.Client;
import ftjava.gui.ClientProgram;
import ftjava.gui.Diagnostics;
import ftjava.gui.HTMLWindow;
import ftjava.gui.MainProgram;
import ftjava.gui.Preferences;
import ftjava.gui.ScenarioEditor;
import ftjava.gui.ShipDesignEditor;
import ftjava.gui.util.FileChooser;
import ftjava.gui.util.ImageUtilities;
import ftjava.mailman.FetchClientEmail;
import ftjava.mailman.MailToServer;
import ftjava.std.GameEngine;
import ftjava.std.importer.ImportGameEngine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FTJava
implements MainProgram,
ActionListener {
    private JFrame theFrame = new JFrame("FTJava Client V1.3");
    private JMenu GameMenu;
    private FileDialog chooser;
    private ClientProgram client;
    private JButton loadGameFromFileButton;
    private JButton fetchEMailButton;
    private JButton sendEMailButton;
    private JButton refreshGameButton;
    private JButton refreshOrdersButton;
    private JPopupMenu inGamesMenu;
    private JPopupMenu outOrdersMenu;
    private JMenuItem inOption1;
    private JMenuItem inOption2;
    private JMenuItem outOption1;
    private JMenuItem outOption2;
    private JTextArea messageTextArea;
    private JList incomingGamesList;
    private JList outgoingOrdersList;
    private DefaultListModel inGamesModel;
    private DefaultListModel outOrdersModel;
    private static boolean isMacOSX = false;
    public static final String version = "FTJava Client V1.3";
    private static final String INCOMING = "Incoming Games Directory";
    private static final String OUTGOING = "Outgoing Games Directory";

    public FTJava() {
        this.initializeLists();
        JMenuBar MenuBar2 = new JMenuBar();
        this.theFrame.setJMenuBar(MenuBar2);
        this.buildMenuBar(MenuBar2);
        this.createIncomingMenu();
        this.createOutgoingMenu();
        this.addListeners();
        this.theFrame.setDefaultCloseOperation(3);
        this.theFrame.setSize(640, 480);
        Container cp = this.theFrame.getContentPane();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.anchor = 18;
        cp.add((Component)this.clientImage(), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 100.0;
        c.weighty = 1.0;
        c.fill = 2;
        cp.add((Component)this.getButtonList(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        c.fill = 1;
        JSplitPane jsp = new JSplitPane(0);
        jsp.setTopComponent(this.getWindows());
        jsp.setBottomComponent(this.getMessageArea());
        jsp.setDividerLocation(100);
        cp.add((Component)jsp, c);
        this.theFrame.pack();
        this.theFrame.setVisible(true);
    }

    private JLabel clientImage() {
        BufferedImage image = ImageUtilities.getImage("Images/Logo.png", this.theFrame);
        return new JLabel(new ImageIcon(image));
    }

    private JPanel getButtonList() {
        JPanel jpv = new JPanel();
        jpv.setLayout(new GridLayout(5, 1));
        this.loadGameFromFileButton = new JButton("Load Game from File...");
        this.fetchEMailButton = new JButton("Fetch E-mail");
        this.sendEMailButton = new JButton("Send E-mail");
        this.refreshGameButton = new JButton("Refresh Game list");
        this.refreshOrdersButton = new JButton("Refresh Orders list");
        jpv.add(this.loadGameFromFileButton);
        this.loadGameFromFileButton.addActionListener(new LoadGame());
        jpv.add(this.fetchEMailButton);
        this.fetchEMailButton.addActionListener(new FetchEmail());
        jpv.add(this.sendEMailButton);
        this.sendEMailButton.addActionListener(new SendEmail());
        jpv.add(this.refreshGameButton);
        this.refreshGameButton.addActionListener(new RefreshGameMenu());
        jpv.add(this.refreshOrdersButton);
        this.refreshOrdersButton.addActionListener(new RefreshOrdersMenu());
        return jpv;
    }

    private JSplitPane getWindows() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel in = new JPanel();
        in.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 18;
        in.add((Component)new JLabel("Incoming Games", 0), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        c.fill = 1;
        c.anchor = 18;
        in.add((Component)this.getIncoming(), c);
        JPanel out = new JPanel();
        out.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 18;
        out.add((Component)new JLabel("Outgoing Orders", 0), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        c.fill = 1;
        c.anchor = 18;
        out.add((Component)this.getOutgoing(), c);
        JSplitPane jsp = new JSplitPane(1);
        jsp.setLeftComponent(in);
        jsp.setRightComponent(out);
        jsp.setDividerLocation(200);
        return jsp;
    }

    private JComponent getIncoming() {
        return new JScrollPane(this.incomingGamesList);
    }

    private JComponent getOutgoing() {
        this.addOrders();
        return new JScrollPane(this.outgoingOrdersList);
    }

    private void initializeLists() {
        this.inGamesModel = new DefaultListModel();
        this.outOrdersModel = new DefaultListModel();
        this.incomingGamesList = new JList();
        this.incomingGamesList.setModel(this.inGamesModel);
        this.incomingGamesList.setSelectionMode(0);
        this.outgoingOrdersList = new JList();
        this.outgoingOrdersList.setModel(this.outOrdersModel);
        this.outgoingOrdersList.setSelectionMode(0);
    }

    private void createIncomingMenu() {
        this.inGamesMenu = new JPopupMenu();
        this.inOption1 = new JMenuItem("Load game");
        this.inOption2 = new JMenuItem("Remove game");
        this.inGamesMenu.add(this.inOption1);
        this.inGamesMenu.add(this.inOption2);
        this.inOption1.addActionListener(this);
        this.inOption2.addActionListener(this);
        this.incomingGamesList.add(this.inGamesMenu);
    }

    private void createOutgoingMenu() {
        this.outOrdersMenu = new JPopupMenu();
        this.outOption1 = new JMenuItem("Send orders");
        this.outOption2 = new JMenuItem("Remove orders");
        this.outOrdersMenu.add(this.outOption1);
        this.outOrdersMenu.add(this.outOption2);
        this.outOption1.addActionListener(this);
        this.outOption2.addActionListener(this);
        this.outgoingOrdersList.add(this.outOrdersMenu);
    }

    private void addListeners() {
        this.incomingGamesList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    String contents = (String)FTJava.this.incomingGamesList.getSelectedValue();
                    String incomingDir = Preferences.getPreferences().getProperty(FTJava.INCOMING);
                    String suffix = ".xml";
                    String fileSep = System.getProperty("file.separator");
                    contents = incomingDir + fileSep + contents + suffix;
                    FTJava.this.loadGame(contents);
                } else if (SwingUtilities.isRightMouseButton(me) && !FTJava.this.incomingGamesList.isSelectionEmpty() && FTJava.this.incomingGamesList.locationToIndex(me.getPoint()) == FTJava.this.incomingGamesList.getSelectedIndex()) {
                    FTJava.this.inGamesMenu.show(FTJava.this.incomingGamesList, me.getX(), me.getY());
                }
            }
        });
        this.outgoingOrdersList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    String contents = (String)FTJava.this.outgoingOrdersList.getSelectedValue();
                    String outgoingDir = Preferences.getPreferences().getProperty(FTJava.OUTGOING);
                    String suffix = ".xml";
                    String fileSep = System.getProperty("file.separator");
                    contents = outgoingDir + fileSep + contents + suffix;
                    FTJava.this.sendOrders(contents);
                    FTJava.this.addOrders();
                } else if (SwingUtilities.isRightMouseButton(me) && !FTJava.this.outgoingOrdersList.isSelectionEmpty() && FTJava.this.outgoingOrdersList.locationToIndex(me.getPoint()) == FTJava.this.outgoingOrdersList.getSelectedIndex()) {
                    FTJava.this.outOrdersMenu.show(FTJava.this.outgoingOrdersList, me.getX(), me.getY());
                }
            }
        });
    }

    public void actionPerformed(ActionEvent ae) {
        String contents = null;
        String incomingDir = Preferences.getPreferences().getProperty(INCOMING);
        String outgoingDir = Preferences.getPreferences().getProperty(OUTGOING);
        String suffix = ".xml";
        String fileSep = System.getProperty("file.separator");
        if (ae.getSource() == this.inOption1) {
            contents = (String)this.incomingGamesList.getSelectedValue();
            contents = incomingDir + fileSep + contents + suffix;
            this.loadGame(contents);
        }
        if (ae.getSource() == this.inOption2) {
            contents = (String)this.incomingGamesList.getSelectedValue();
            contents = incomingDir + fileSep + contents + suffix;
            this.removeGame(contents);
            this.addGames();
        }
        if (ae.getSource() == this.outOption1) {
            contents = (String)this.outgoingOrdersList.getSelectedValue();
            contents = outgoingDir + fileSep + contents + suffix;
            this.sendOrders(contents);
            this.addOrders();
        }
        if (ae.getSource() == this.outOption2) {
            contents = (String)this.outgoingOrdersList.getSelectedValue();
            contents = outgoingDir + fileSep + contents + suffix;
            this.removeOrders(contents);
            this.addOrders();
        }
    }

    private JPanel getMessageArea() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 18;
        jp.add((Component)new JLabel("Messages", 0), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        c.fill = 1;
        c.anchor = 18;
        this.messageTextArea = new JTextArea(2, 1);
        this.messageTextArea.setFont(new Font("SanSerif", 0, 12));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setForeground(Color.black);
        jp.add((Component)new JScrollPane(this.messageTextArea), c);
        return jp;
    }

    public void writeMessage(String newMessage) {
        this.messageTextArea.append(newMessage);
        this.messageTextArea.append("\n");
    }

    public void notifyFileProcessed(File f) {
        File directory = new File(Preferences.getPreferences().getProperty(INCOMING), "ProcessedFiles");
        directory.mkdirs();
        File deletedFile = new File(directory, f.getName());
        f.renameTo(deletedFile);
        this.addGames();
        this.addOrders();
    }

    public void addGames() {
        File directory = new File(Preferences.getPreferences().getProperty(INCOMING));
        directory.mkdirs();
        this.GameMenu.removeAll();
        Object[] games = directory.listFiles();
        Arrays.sort(games);
        int count = 0;
        JMenuItem item = new JMenuItem("Refresh game menu");
        item.addActionListener(new RefreshGameMenu());
        item.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        this.GameMenu.add(item);
        this.inGamesModel.clear();
        for (int i = 0; i < games.length; ++i) {
            boolean isFile = ((File)games[i]).isFile();
            boolean isXML = ((File)games[i]).getName().toLowerCase().endsWith(".xml");
            boolean isCompressed = ((File)games[i]).getName().toLowerCase().endsWith(".gz");
            if (!isFile || !isXML && !isCompressed) continue;
            ++count;
            item = new JMenuItem(((File)games[i]).getName());
            item.addActionListener(new GameAction((File)games[i]));
            this.GameMenu.add(item);
            String theName = ((File)games[i]).getName();
            this.inGamesModel.addElement(theName.substring(0, theName.indexOf(46)));
        }
        if (count == 0) {
            item = new JMenuItem("<No games present>");
            item.setEnabled(false);
            this.GameMenu.add(item);
        }
    }

    public void addOrders() {
        File directory = new File(Preferences.getPreferences().getProperty(OUTGOING));
        directory.mkdirs();
        Object[] orders = directory.listFiles();
        Arrays.sort(orders);
        this.outOrdersModel.clear();
        for (int i = 0; i < orders.length; ++i) {
            if (!((File)orders[i]).isFile() || !((File)orders[i]).getName().endsWith(".xml")) continue;
            String theName = ((File)orders[i]).getName();
            this.outOrdersModel.addElement(theName.substring(0, theName.indexOf(46)));
        }
    }

    public void loadGame(String fileName) {
        File f = new File(fileName);
        if (!f.canRead()) {
            f = new File(fileName + ".gz");
        }
        this.loadGame(f);
    }

    public void loadGame(File file) {
        ImportGameEngine ie = new ImportGameEngine();
        try {
            GameEngine engine = ie.readGameEngine(file);
            int gameId = engine.getId();
            int turn = engine.getGameTurn();
            boolean combatPhase = engine.isCombatPhase();
            if (combatPhase) {
                this.client = new Client(this, file, engine, gameId, turn, "Combat");
            } else {
                engine.initializeMovementOrders();
                this.client = new Client(this, file, engine, gameId, turn + 1, "Movement");
            }
            this.client.pack();
            this.client.setVisible(true);
            this.writeMessage("Loaded Game" + gameId + ".");
        }
        catch (Exception e) {
            this.writeMessage("Error opening " + file);
            JOptionPane.showMessageDialog(this.theFrame, "Error opening\n" + file + "\n" + e, "Error", 0);
            e.printStackTrace();
        }
    }

    public void loadGame() {
        File file = null;
        if (this.chooser == null) {
            this.chooser = new FileDialog(this.theFrame);
            this.chooser.setMode(0);
            this.chooser.setTitle("Open Game");
        }
        this.chooser.setVisible(true);
        String resultPath = this.chooser.getDirectory();
        String resultFile = this.chooser.getFile();
        if (resultPath != null && resultPath.length() != 0 && resultFile != null && resultFile.length() != 0) {
            file = new File(resultPath + resultFile);
        }
        if (file != null) {
            this.loadGame(file);
        }
    }

    private void removeGame(String fileName) {
        File theFile = new File(fileName);
        File directory = new File(Preferences.getPreferences().getProperty(INCOMING), "ProcessedFiles");
        directory.mkdirs();
        File deletedFile = new File(directory, theFile.getName());
        if (deletedFile.exists()) {
            deletedFile.delete();
        }
        theFile.renameTo(deletedFile);
        String theName = theFile.getName();
        theName = theName.substring(0, theName.indexOf(46));
        this.writeMessage("Removed " + theName + " to Processed Games.");
    }

    private void sendOrders(String fileName) {
        File theFile = new File(fileName);
        String message = MailToServer.sendGameToServer(theFile);
        this.writeMessage(message);
    }

    private void removeOrders(String fileName) {
        File theFile = new File(fileName);
        theFile.delete();
        String theName = theFile.getName();
        theName = theName.substring(0, theName.indexOf(46));
        this.writeMessage("Removed " + theName + ".");
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    private void buildMenuBar(JMenuBar MenuBar2) {
        JMenu FileMenu = new JMenu("File");
        MenuBar2.add(FileMenu);
        JMenuItem Item = new JMenuItem("Load Game from File...");
        FileMenu.add(Item);
        Item.addActionListener(new LoadGame());
        Item = new JMenuItem("Fetch Email");
        FileMenu.add(Item);
        Item.addActionListener(new FetchEmail());
        Item.setAccelerator(KeyStroke.getKeyStroke(70, 0));
        Item = new JMenuItem("Send Email");
        FileMenu.add(Item);
        Item.addActionListener(new SendEmail());
        Item.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        Item = new JMenuItem("Preferences...");
        FileMenu.add(Item);
        Item.addActionListener(new PreferencesListener());
        Item = new JMenuItem("Exit");
        FileMenu.add(Item);
        Item.addActionListener(new ExitListener());
        this.GameMenu = new JMenu("Games");
        MenuBar2.add(this.GameMenu);
        this.addGames();
        JMenu scenarioMenu = new JMenu("Editor");
        MenuBar2.add(scenarioMenu);
        Item = new JMenuItem("Open Scenario...");
        scenarioMenu.add(Item);
        Item.addActionListener(new EditScenario(true));
        Item = new JMenuItem("New Scenario");
        scenarioMenu.add(Item);
        Item.addActionListener(new EditScenario(false));
        Item = new JMenuItem("Open Ship...");
        scenarioMenu.add(Item);
        Item.addActionListener(new EditShip(true));
        Item = new JMenuItem("New Ship");
        scenarioMenu.add(Item);
        Item.addActionListener(new EditShip(false));
        MenuBar2.add(Box.createHorizontalGlue());
        JMenu AboutMenu = new JMenu("Help");
        MenuBar2.add(AboutMenu);
        Item = new JMenuItem("About FTJava");
        Item.addActionListener(new AboutFTJava());
        AboutMenu.add(Item);
        Item = new JMenuItem("Diagnostics");
        Item.addActionListener(new Diagnostics());
        AboutMenu.add(Item);
        Item = new JMenuItem("From the Authors");
        Item.addActionListener(HTMLWindow.getListener("Statement", "A statement from the authors...", 500, 400));
        AboutMenu.add(Item);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("com.apple.hwaccel", "false");
            String lcOSName = System.getProperty("os.name").toLowerCase();
            isMacOSX = lcOSName.startsWith("mac os x");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        FTJava f = new FTJava();
        for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            if (!file.canRead()) continue;
            f.loadGame(file);
        }
    }

    class EditShip
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected boolean loadFile = false;

        public EditShip(boolean load) {
            this.loadFile = load;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.loadFile) {
                ShipDesignEditor.openShipFromFile();
            } else {
                ShipDesignEditor.createNew();
            }
        }
    }

    class EditScenario
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected boolean loadFile = false;

        public EditScenario(boolean load) {
            this.loadFile = load;
        }

        public void actionPerformed(ActionEvent e) {
            File f = null;
            if (this.loadFile) {
                f = FileChooser.getLoadFile(FTJava.this.theFrame, "Open Scenario");
            }
            new ScenarioEditor(f);
        }
    }

    class LoadGame
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        LoadGame() {
        }

        public void actionPerformed(ActionEvent e) {
            FTJava.this.loadGame();
        }
    }

    class RefreshOrdersMenu
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        RefreshOrdersMenu() {
        }

        public void actionPerformed(ActionEvent e) {
            FTJava.this.addOrders();
        }
    }

    class RefreshGameMenu
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        RefreshGameMenu() {
        }

        public void actionPerformed(ActionEvent e) {
            FTJava.this.addGames();
        }
    }

    class GameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private File file;

        public GameAction(File f) {
            this.file = f;
        }

        public void actionPerformed(ActionEvent e) {
            FTJava.this.loadGame(this.file);
        }
    }

    class ExitListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ExitListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class PreferencesListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        PreferencesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Preferences.doPreferences();
        }
    }

    class SendEmail
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        SendEmail() {
        }

        public void actionPerformed(ActionEvent ae) {
            String infoMessage = MailToServer.sendGamesToServer();
            FTJava.this.writeMessage(infoMessage);
            FTJava.this.addOrders();
        }
    }

    class FetchEmail
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        FetchEmail() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                String infoMessage = FetchClientEmail.fetchMail();
                FTJava.this.writeMessage(infoMessage);
            }
            catch (Exception e) {
                FTJava.this.writeMessage("Mail fetch error");
                JOptionPane.showMessageDialog(FTJava.this.theFrame, "Mail fetch error");
                e.printStackTrace();
            }
            FTJava.this.addGames();
        }
    }
}

