/*
 * Decompiled with CFR 0.152.
 */
package ftjava.ai;

import ftjava.ai.AIUtilities;
import ftjava.ai.Bot;
import ftjava.ai.CinematicUtilities;
import ftjava.std.FireControl;
import ftjava.std.GameEngine;
import ftjava.std.MainDrive;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import java.util.ArrayList;

public class BotEpsilon
implements Bot {
    private Player theBot;
    private GameEngine theGame;

    public BotEpsilon() {
    }

    public BotEpsilon(Player p) {
        this.setPlayer(p);
    }

    public void setPlayer(Player p) {
        this.theBot = p;
    }

    public Player getPlayer() {
        return this.theBot;
    }

    public void setGameEngine(GameEngine game) {
        this.theGame = game;
    }

    public GameEngine getGameEngine() {
        return this.theGame;
    }

    public void evaluateMovementOrders() {
        for (int i = 0; i < this.theBot.Ships.size(); ++i) {
            Ship s = (Ship)this.theBot.Ships.get(i);
            if (s.isDestroyed() || s.hasJumped()) continue;
            this.evaluateShipMovementOrders(s);
        }
    }

    private void evaluateShipMovementOrders(Ship myShip) {
        if (myShip == null) {
            return;
        }
        myShip.setOrders("0");
        Ship targetShip = AIUtilities.chooseATarget(myShip, this.theGame.getShips(), this.theGame.getHeavenlyBodies());
        if (targetShip == null) {
            myShip.setOrders("0");
            return;
        }
        double bestRange = 13.0;
        int bestArc = Weapon.FORE_ARC;
        int bestSpeed = targetShip.getSpeed() + 1;
        double arcReward = 80.0;
        double xProjection = targetShip.getPlottedXPosition(true);
        double yProjection = targetShip.getPlottedYPosition(true);
        MainDrive theMainDrive = myShip.getMainDrive();
        if (theMainDrive == null) {
            return;
        }
        int thrust = theMainDrive.getCurrentThrust();
        boolean advanced = theMainDrive.isAdvanced();
        ArrayList cinematicOrders = CinematicUtilities.getAvailableOrders(thrust, advanced);
        String bestOrders = "0";
        double bestEvaluation = Double.MAX_VALUE;
        SpaceObject temp = new SpaceObject();
        for (int i = 0; i < cinematicOrders.size(); ++i) {
            String orders = (String)cinematicOrders.get(i);
            myShip.setOrders(orders);
            double xPlot = myShip.getPlottedXPosition();
            double yPlot = myShip.getPlottedYPosition();
            int hPlot = myShip.getPlottedHeading();
            int sPlot = myShip.getPlottedSpeed();
            temp.setXPosition(xPlot);
            temp.setYPosition(yPlot);
            temp.setHeading(hPlot);
            double projectedRange = temp.rangeTo(xProjection, yProjection);
            int projectedArc = temp.arcTo(xProjection - xPlot, yProjection - yPlot);
            double evaluation = Math.pow(projectedRange - bestRange, 2.0);
            if (projectedRange < 36.0) {
                evaluation += Math.pow(sPlot - bestSpeed, 2.0);
            }
            if (projectedArc == bestArc) {
                evaluation -= arcReward;
            }
            if (!(evaluation < bestEvaluation)) continue;
            bestEvaluation = evaluation;
            bestOrders = orders;
        }
        myShip.setOrders(bestOrders);
    }

    public void evaluateCombatOrders() {
        for (int i = 0; i < this.theBot.Ships.size(); ++i) {
            Ship s = (Ship)this.theBot.Ships.get(i);
            if (s.isDestroyed() || s.hasJumped()) continue;
            this.evaluateShipCombatOrders(s);
        }
    }

    private void evaluateShipCombatOrders(Ship myShip) {
        if (myShip == null) {
            return;
        }
        ArrayList fireCons = myShip.getActiveFireControls();
        Ship targetShip = AIUtilities.chooseATarget(myShip, this.theGame.getShips(), this.theGame.getHeavenlyBodies());
        if (targetShip == null || fireCons.size() == 0) {
            for (int i = 0; i < fireCons.size(); ++i) {
                FireControl fc = (FireControl)fireCons.get(i);
                fc.unslaveAllWeapons();
                fc.setTargetId(0);
            }
            return;
        }
        FireControl fc = (FireControl)fireCons.get(0);
        fc.setTargetId(targetShip.getId());
        ArrayList weapons = myShip.getWeaponSystems();
        for (int i = 0; i < weapons.size(); ++i) {
            Weapon w = (Weapon)weapons.get(i);
            if (!w.isDirectFire()) continue;
            fc.slaveWeapon(w);
        }
    }
}

