/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.ModelTableFormat;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class AbstractTableFormat
implements ModelTableFormat {
    private static final Logger logger = Logger.getLogger(AbstractTableFormat.class.getName());
    private int columnCount;
    private String[] columnNames;
    private boolean[] columnEditable;
    protected Vector tables;

    protected AbstractTableFormat(int newColumnCount) {
        this.columnCount = newColumnCount;
        this.columnNames = new String[this.columnCount];
        this.columnEditable = new boolean[this.columnCount];
        for (int i = 0; i < this.columnEditable.length; ++i) {
            this.columnEditable[i] = false;
        }
    }

    public void customizeTable(ModelTable modelTable) {
    }

    public void customizeTableAfterInitialize(ModelTable modelTable) {
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public synchronized void addTable(JTable table) {
        if (this.tables == null) {
            this.tables = new Vector();
        }
        this.tables.add(table);
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    protected void setColumnName(int index, String name) {
        this.columnNames[index] = name;
    }

    protected synchronized void refreshColumnNames() {
        if (this.tables != null) {
            for (JTable table : this.tables) {
                TableColumnModel columnModel = table.getColumnModel();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    TableColumn column = columnModel.getColumn(i);
                    column.setHeaderValue(this.columnNames[column.getModelIndex()]);
                }
            }
        }
    }

    public boolean isColumnEditable(int column) {
        return this.columnEditable[column];
    }

    public void setColumnEditable(int column, boolean editable) {
        this.columnEditable[column] = editable;
    }

    public void setCellValue(Object value, ModelItem item, int columnIndex) {
        logger.warning("The column number " + columnIndex + "is not editable.");
    }
}

