/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.translation.Language;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TextComponentClipboardMenu
extends MouseAdapter
implements ClipboardOwner,
ActionListener {
    private static final Logger logger = Logger.getLogger(TextComponentClipboardMenu.class.getName());
    private Language language;
    private JTextComponent textComponent;
    private Clipboard clipboard;
    private JPopupMenu popupMenu;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenuItem cancelItem;

    public TextComponentClipboardMenu(JTextComponent textComponent, Language language) {
        this.textComponent = textComponent;
        this.language = language;
        textComponent.addMouseListener(this);
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.textComponent.isEnabled()) {
            this.showPopup(e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.textComponent.isEnabled()) {
            this.showPopup(e.getX(), e.getY());
        }
    }

    public void lostOwnership(Clipboard lClipboard, Transferable contents) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cutItem) {
            this.cutSelectedText();
        }
        if (e.getSource() == this.copyItem) {
            this.copySelectedText();
        }
        if (e.getSource() == this.pasteItem) {
            this.pasteText();
        }
    }

    private void showPopup(int x, int y) {
        this.createPopupMenu();
        this.cutItem.setText(this.language.getString("Common.cut"));
        this.copyItem.setText(this.language.getString("Common.copy"));
        this.pasteItem.setText(this.language.getString("Common.paste"));
        this.cancelItem.setText(this.language.getString("Common.cancel"));
        if (this.textComponent.getSelectedText() != null) {
            if (this.textComponent.isEditable()) {
                this.cutItem.setEnabled(true);
            } else {
                this.cutItem.setEnabled(false);
            }
            this.copyItem.setEnabled(true);
        } else {
            this.cutItem.setEnabled(false);
            this.copyItem.setEnabled(false);
        }
        Transferable clipboardContent = this.getClipboard().getContents(this);
        if (clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            if (this.textComponent.isEditable()) {
                this.pasteItem.setEnabled(true);
            } else {
                this.pasteItem.setEnabled(false);
            }
        } else {
            this.pasteItem.setEnabled(false);
        }
        this.popupMenu.show(this.textComponent, x, y);
    }

    private void pasteText() {
        Transferable clipboardContent = this.clipboard.getContents(this);
        try {
            String text = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
            Caret caret = this.textComponent.getCaret();
            int p0 = Math.min(caret.getDot(), caret.getMark());
            int p1 = Math.max(caret.getDot(), caret.getMark());
            Document document = this.textComponent.getDocument();
            if (document instanceof PlainDocument) {
                ((PlainDocument)document).replace(p0, p1 - p0, text, null);
            } else {
                if (p0 != p1) {
                    document.remove(p0, p1 - p0);
                }
                document.insertString(p0, text, null);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Problem while pasting text.", ioe);
        }
        catch (UnsupportedFlavorException ufe) {
            logger.log(Level.SEVERE, "Problem while pasting text.", ufe);
        }
        catch (BadLocationException ble) {
            logger.log(Level.SEVERE, "Problem while pasting text.", ble);
        }
    }

    private void createPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.cutItem = new JMenuItem();
            this.copyItem = new JMenuItem();
            this.pasteItem = new JMenuItem();
            this.cancelItem = new JMenuItem();
            this.cutItem.addActionListener(this);
            this.copyItem.addActionListener(this);
            this.pasteItem.addActionListener(this);
            this.popupMenu.add(this.cutItem);
            this.popupMenu.add(this.copyItem);
            this.popupMenu.add(this.pasteItem);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.cancelItem);
        }
    }

    private Clipboard getClipboard() {
        if (this.clipboard == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.clipboard = toolkit.getSystemClipboard();
        }
        return this.clipboard;
    }

    private void copySelectedText() {
        StringSelection selection = new StringSelection(this.textComponent.getSelectedText());
        this.clipboard.setContents(selection, this);
    }

    private void cutSelectedText() {
        StringSelection selection = new StringSelection(this.textComponent.getSelectedText());
        this.clipboard.setContents(selection, this);
        int start = this.textComponent.getSelectionStart();
        int end = this.textComponent.getSelectionEnd();
        try {
            this.textComponent.getDocument().remove(start, end - start);
        }
        catch (BadLocationException ble) {
            logger.log(Level.SEVERE, "Problem while cutting text.", ble);
        }
    }
}

