/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.Core;
import frost.util.Mixed;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscToolkit {
    private MiscToolkit() {
    }

    public static void configureButton(JButton button, String toolTipKey, Language language) {
        button.setToolTipText(language.getString(toolTipKey));
        MiscToolkit.configureButton(button);
    }

    public static void configureButton(JButton button) {
        if (button.getIcon() instanceof ImageIcon) {
            button.setRolloverIcon(MiscToolkit.createRolloverIcon((ImageIcon)button.getIcon()));
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setPreferredSize(new Dimension(30, 25));
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setOpaque(false);
    }

    public static ImageIcon createRolloverIcon(ImageIcon icon) {
        int RED_INCREASE = 50;
        int GREEN_INCREASE = 40;
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        image.createGraphics().drawImage(icon.getImage(), 0, 0, new JPanel());
        WritableRaster rasterSource = image.getRaster();
        WritableRaster rasterDest = image.getRaster();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int[] srcPixels = new int[4];
                rasterSource.getPixel(x, y, srcPixels);
                if (srcPixels[3] == 0) continue;
                srcPixels[0] = srcPixels[0] + 50;
                srcPixels[0] = Math.min(srcPixels[0], 255);
                srcPixels[1] = srcPixels[1] + 40;
                srcPixels[1] = Math.min(srcPixels[1], 255);
                rasterDest.setPixel(x, y, srcPixels);
            }
        }
        return new ImageIcon(image);
    }

    public static ImageIcon getScaledImage(String imgPath, int width, int height) {
        ImageIcon icon = MiscToolkit.loadImageIcon(imgPath);
        icon = new ImageIcon(icon.getImage().getScaledInstance(width, height, 4));
        return icon;
    }

    public static void setContainerEnabled(Container container, boolean enabled) {
        int componentCount = container.getComponentCount();
        for (int x = 0; x < componentCount; ++x) {
            Component component = container.getComponent(x);
            if (component instanceof Container) {
                MiscToolkit.setContainerEnabledInner((Container)component, enabled);
                continue;
            }
            component.setEnabled(enabled);
        }
    }

    public static void setContainerEnabled(Container container, boolean enabled, Collection<Component> exceptions) {
        int componentCount = container.getComponentCount();
        for (int x = 0; x < componentCount; ++x) {
            Component component = container.getComponent(x);
            if (exceptions.contains(component)) continue;
            if (component instanceof Container) {
                MiscToolkit.setContainerEnabledInner((Container)component, enabled, exceptions);
                continue;
            }
            component.setEnabled(enabled);
        }
    }

    private static void setContainerEnabledInner(Container container, boolean enabled) {
        int componentCount = container.getComponentCount();
        for (int x = 0; x < componentCount; ++x) {
            Component component = container.getComponent(x);
            if (component instanceof Container) {
                MiscToolkit.setContainerEnabledInner((Container)component, enabled);
                continue;
            }
            component.setEnabled(enabled);
        }
        container.setEnabled(enabled);
    }

    private static void setContainerEnabledInner(Container container, boolean enabled, Collection<Component> exceptions) {
        int componentCount = container.getComponentCount();
        for (int x = 0; x < componentCount; ++x) {
            Component component = container.getComponent(x);
            if (exceptions.contains(component)) continue;
            if (component instanceof Container) {
                MiscToolkit.setContainerEnabledInner((Container)component, enabled, exceptions);
                continue;
            }
            component.setEnabled(enabled);
        }
        container.setEnabled(enabled);
    }

    public static void showMessage(String message, int type, String title) {
        JFrame frame = new JFrame();
        frame.setTitle("Frost");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(dimension.width / 2, dimension.height / 2);
        frame.setUndecorated(true);
        frame.setVisible(true);
        frame.toFront();
        JOptionPane.showMessageDialog(frame, message, title, type);
        frame.dispose();
    }

    public static String showInputDialog(Object message) {
        JFrame frame = new JFrame();
        frame.setTitle("Frost");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(dimension.width / 2, dimension.height / 2);
        frame.setUndecorated(true);
        frame.setVisible(true);
        frame.toFront();
        String returnValue = JOptionPane.showInputDialog(frame, message);
        frame.dispose();
        return returnValue;
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static ImageIcon loadImageIcon(String resourcePath) {
        return new ImageIcon(Mixed.class.getResource(resourcePath));
    }

    public static int showSuppressableConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, String frostSettingName, String checkboxText) {
        boolean showConfirmDialog = Core.frostSettings.getBoolValue(frostSettingName);
        if (!showConfirmDialog) {
            return 0;
        }
        JOptionPane op = new JOptionPane(message, messageType, optionType);
        JDialog dlg = op.createDialog(parentComponent, title);
        JCheckBox cb = new JCheckBox(checkboxText);
        cb.setSelected(true);
        dlg.getContentPane().add((Component)cb, "South");
        dlg.pack();
        dlg.setDefaultCloseOperation(2);
        dlg.setModal(true);
        dlg.setVisible(true);
        if (!cb.isSelected()) {
            Core.frostSettings.setValue(frostSettingName, false);
        }
        dlg.dispose();
        Object selectedValue = op.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return -1;
    }
}

