/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.MiscToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MemoryMonitor
extends JPanel {
    public Surface surf;
    JFrame dialog = null;
    boolean isShown = false;

    private JFrame getDialog() {
        if (this.dialog == null) {
            this.dialog = new JFrame();
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getContentPane().add(this);
            this.dialog.setSize(225, 130);
            this.dialog.setTitle("Frost Memory Monitor");
            ImageIcon frameIcon = MiscToolkit.loadImageIcon("/data/toolbar/utilities-system-monitor.png");
            this.dialog.setIconImage(frameIcon.getImage());
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.isShown = false;
                    MemoryMonitor.this.dialog.setVisible(false);
                }
            });
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension splashscreenSize = this.dialog.getSize();
            if (splashscreenSize.height > screenSize.height) {
                splashscreenSize.height = screenSize.height;
            }
            if (splashscreenSize.width > screenSize.width) {
                splashscreenSize.width = screenSize.width;
            }
            this.dialog.setLocation((screenSize.width - splashscreenSize.width) / 2, (screenSize.height - splashscreenSize.height) / 2);
        }
        return this.dialog;
    }

    public void showDialog() {
        if (this.isShown) {
            return;
        }
        this.surf.start();
        this.isShown = true;
        this.getDialog().setVisible(true);
    }

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.surf = new Surface();
        this.add(this.surf);
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private final Font font = new Font("Times New Roman", 0, 11);
        private final Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private final Rectangle graphOutlineRect = new Rectangle();
        private final Rectangle2D mfRect = new Rectangle2D.Float();
        private final Rectangle2D muRect = new Rectangle2D.Float();
        private final Line2D graphLine = new Line2D.Float();
        private final Color graphColor = new Color(46, 139, 87);
        private final Color mfColor = new Color(0, 100, 0);
        private String usedStr;
        private int gc_counter = 0;

        public Surface() {
            this.setBackground(Color.black);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 100);
        }

        public void paint(Graphics g) {
            int j;
            int i;
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float freeMemory = this.r.freeMemory();
            float totalMemory = this.r.totalMemory();
            float maxMemory = this.r.maxMemory();
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)totalMemory / 1024) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            this.big.drawString(String.valueOf((int)maxMemory / 1024) + "K max", 110.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)(totalMemory - freeMemory) / 1024) + "K used";
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            this.big.drawString(Thread.activeCount() + " threads", 110, this.h - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)(freeMemory / totalMemory * 10.0f);
            for (i = 0; i < MemUsage; ++i) {
                this.mfRect.setRect(5.0, ssH + (float)i * blockHeight, 20.0, blockHeight - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(5.0, ssH + (float)i * blockHeight, 20.0, blockHeight - 1.0f);
                this.big.fill(this.muRect);
                ++i;
            }
            this.big.setColor(this.graphColor);
            int graphX = 30;
            int graphY = (int)ssH;
            int graphW = this.w - 30 - 5;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(30.0, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            for (int j2 = graphY; j2 <= graphH + graphY; j2 += graphRow) {
                this.graphLine.setLine(30.0, j2, 30 + graphW, j2);
                this.big.draw(this.graphLine);
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            for (j = 30 + this.columnInc; j < graphW + 30; j += graphColumn) {
                this.graphLine.setLine(j, graphY, j, graphY + graphH);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[graphW];
                this.ptNum = 0;
            } else if (this.pts.length != graphW) {
                int[] tmp = null;
                if (this.ptNum < graphW) {
                    tmp = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, tmp, 0, tmp.length);
                } else {
                    tmp = new int[graphW];
                    System.arraycopy(this.pts, this.pts.length - tmp.length, tmp, 0, tmp.length);
                    this.ptNum = tmp.length - 2;
                }
                this.pts = new int[graphW];
                System.arraycopy(tmp, 0, this.pts, 0, tmp.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)graphY + (float)graphH * (freeMemory / totalMemory));
                j = 30 + graphW - this.ptNum;
                int k = 0;
                while (k < this.ptNum) {
                    if (k != 0) {
                        if (this.pts[k] != this.pts[k - 1]) {
                            this.big.drawLine(j - 1, this.pts[k - 1], j, this.pts[k]);
                        } else {
                            this.big.fillRect(j, this.pts[k], 1, 1);
                        }
                    }
                    ++k;
                    ++j;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    for (j = 1; j < this.ptNum; ++j) {
                        this.pts[j - 1] = this.pts[j];
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            if (this.gc_counter > 4) {
                if (this.thread != null && freeMemory < 2048000.0f) {
                    this.big.setColor(Color.red);
                    this.big.fillRect(84, this.h - this.descent - 6, 4, 4);
                    System.gc();
                }
                this.gc_counter = 0;
            } else {
                ++this.gc_counter;
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                Dimension d = this.getSize();
                if (d.width != this.w || d.height != this.h) {
                    this.w = d.width;
                    this.h = d.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fm = this.big.getFontMetrics(this.font);
                    this.ascent = fm.getAscent();
                    this.descent = fm.getDescent();
                }
                this.paint(this.getGraphics());
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.thread = null;
        }
    }
}

