/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.Core;
import frost.boards.AbstractNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JDragTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private static final Logger logger = Logger.getLogger(JDragTree.class.getName());
    private TreePath _pathSource;
    private BufferedImage _imgGhost;
    private Point _ptOffset = new Point();
    public static final DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TreePath");
    private DataFlavor[] _flavors = new DataFlavor[]{TREEPATH_FLAVOR};
    private DragSource dragSource = null;
    private DragGestureRecognizer dgRecognizer = null;
    private DropTarget dropTarget = null;

    public JDragTree(TreeNode root) {
        super(root);
        this.initialize();
    }

    public JDragTree(TreeModel model) {
        super(model);
        this.initialize();
    }

    private void initialize() {
        this.dragSource = DragSource.getDefaultDragSource();
        this.dgRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dgRecognizer.setSourceActions(this.dgRecognizer.getSourceActions() & 0xFFFFFFFB & 0xFFFFFFF7);
        this.dropTarget = new DropTarget(this, new CDropTargetListener());
    }

    private boolean isRootPath(TreePath path) {
        return this.isRootVisible() && this.getRowForPath(path) == 0;
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        this.repaint();
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        AbstractNode n;
        if (Core.frostSettings.getBoolValue("preventBoardTreeReordering")) {
            return;
        }
        InputEvent ievent = e.getTriggerEvent();
        if (ievent instanceof MouseEvent && (((MouseEvent)ievent).getModifiers() & 4) != 0) {
            return;
        }
        Point ptDragOrigin = e.getDragOrigin();
        TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
        if (path == null) {
            return;
        }
        if (this.isRootPath(path)) {
            return;
        }
        Object dragObj = path.getLastPathComponent();
        if (dragObj instanceof AbstractNode && !(n = (AbstractNode)dragObj).isBoard() && !n.isFolder()) {
            return;
        }
        Rectangle raPath = this.getPathBounds(path);
        this._ptOffset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        JLabel lbl = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
        lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
        this._imgGhost = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
        Graphics2D g2 = this._imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        lbl.paint(g2);
        Icon icon = lbl.getIcon();
        int nStartOfText = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
        g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
        g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        g2.fillRect(nStartOfText, 0, this.getWidth(), this._imgGhost.getHeight());
        g2.dispose();
        this.setSelectionPath(path);
        CTransferableTreePath transferable = new CTransferableTreePath(path);
        this._pathSource = path;
        e.startDrag(null, this._imgGhost, new Point(5, 5), transferable, this);
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    private class CTransferableTreePath
    implements Transferable {
        private TreePath _path;

        public CTransferableTreePath(TreePath path) {
            this._path = path;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return JDragTree.this._flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(JDragTree.this._flavors).contains(flavor);
        }

        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.isMimeTypeEqual(TREEPATH_FLAVOR.getMimeType())) {
                return this._path;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class CDropTargetListener
    implements DropTargetListener {
        private TreePath _pathLast = null;
        private Rectangle2D _raCueLine = new Rectangle2D.Float();
        private Rectangle2D _raGhost = new Rectangle2D.Float();
        private Color _colorCueLine;
        private Point _ptLast = new Point();
        private Timer _timerHover;
        private int _nLeftRight = 0;

        public CDropTargetListener() {
            this._colorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
            this._timerHover = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CDropTargetListener.this._nLeftRight = 0;
                    if (JDragTree.this.isRootPath(CDropTargetListener.this._pathLast)) {
                        return;
                    }
                    if (JDragTree.this.isExpanded(CDropTargetListener.this._pathLast)) {
                        JDragTree.this.collapsePath(CDropTargetListener.this._pathLast);
                    } else {
                        JDragTree.this.expandPath(CDropTargetListener.this._pathLast);
                    }
                }
            });
            this._timerHover.setRepeats(false);
        }

        public void dragEnter(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void dragExit(DropTargetEvent e) {
            if (!DragSource.isDragImageSupported()) {
                JDragTree.this.repaint(this._raGhost.getBounds());
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            if (e == null || this._raGhost == null || this._ptLast == null || JDragTree.this._ptOffset == null || JDragTree.this._imgGhost == null || this._raCueLine == null) {
                return;
            }
            Point pt = e.getLocation();
            if (pt == null) {
                return;
            }
            if (pt.equals(this._ptLast)) {
                return;
            }
            int nDeltaLeftRight = pt.x - this._ptLast.x;
            if (this._nLeftRight > 0 && nDeltaLeftRight < 0 || this._nLeftRight < 0 && nDeltaLeftRight > 0) {
                this._nLeftRight = 0;
            }
            this._nLeftRight += nDeltaLeftRight;
            this._ptLast = pt;
            Graphics2D g2 = (Graphics2D)JDragTree.this.getGraphics();
            if (g2 == null) {
                return;
            }
            if (!DragSource.isDragImageSupported()) {
                JDragTree.this.paintImmediately(this._raGhost.getBounds());
                this._raGhost.setRect(pt.x - ((JDragTree)JDragTree.this)._ptOffset.x, pt.y - ((JDragTree)JDragTree.this)._ptOffset.y, JDragTree.this._imgGhost.getWidth(), JDragTree.this._imgGhost.getHeight());
                g2.drawImage(JDragTree.this._imgGhost, AffineTransform.getTranslateInstance(this._raGhost.getX(), this._raGhost.getY()), null);
            } else {
                JDragTree.this.paintImmediately(this._raCueLine.getBounds());
            }
            TreePath path = JDragTree.this.getClosestPathForLocation(pt.x, pt.y);
            if (path != this._pathLast) {
                this._nLeftRight = 0;
                this._pathLast = path;
                this._timerHover.restart();
            }
            Rectangle raPath = JDragTree.this.getPathBounds(path);
            this._raCueLine.setRect(0.0, raPath.y + (int)raPath.getHeight(), JDragTree.this.getWidth(), 2.0);
            g2.setColor(this._colorCueLine);
            g2.fill(this._raCueLine);
            this._raGhost = this._raGhost.createUnion(this._raCueLine);
            if (path.equals(JDragTree.this._pathSource)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void drop(DropTargetDropEvent e) {
            this._timerHover.stop();
            if (!this.isDropAcceptable(e)) {
                e.rejectDrop();
                return;
            }
            e.acceptDrop(e.getDropAction());
            Transferable transferable = e.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = e.getLocation();
                    TreePath pathTarget = JDragTree.this.getClosestPathForLocation(pt.x, pt.y);
                    TreePath pathSource = (TreePath)transferable.getTransferData(flavor);
                    if (pathTarget == null || pathSource == null) {
                        e.dropComplete(false);
                        return;
                    }
                    DefaultMutableTreeNode sourceNode = (DefaultMutableTreeNode)pathSource.getLastPathComponent();
                    DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)sourceNode.getParent();
                    DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
                    DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)targetNode.getParent();
                    if (!sourceNode.isLeaf() && targetNode.getParent() == sourceNode) {
                        e.dropComplete(false);
                        return;
                    }
                    DefaultTreeModel model = (DefaultTreeModel)JDragTree.this.getModel();
                    TreePath pathNewChild = null;
                    if (targetNode.isLeaf() || JDragTree.this.isCollapsed(pathTarget)) {
                        int idx = newParent.getIndex(targetNode);
                        if (idx < 0) {
                            logger.warning("child not found in parent!!!");
                            e.dropComplete(false);
                            return;
                        }
                        Object[] removedChilds = new Object[]{sourceNode};
                        int[] childIndices = new int[]{oldParent.getIndex(sourceNode)};
                        sourceNode.removeFromParent();
                        model.nodesWereRemoved(oldParent, childIndices, removedChilds);
                        if (++idx >= newParent.getChildCount()) {
                            newParent.add(sourceNode);
                            int[] insertedIndex = new int[]{newParent.getChildCount() - 1};
                            model.nodesWereInserted(newParent, insertedIndex);
                        } else {
                            newParent.insert(sourceNode, idx);
                            int[] insertedIndex = new int[]{idx};
                            model.nodesWereInserted(newParent, insertedIndex);
                        }
                        pathNewChild = new TreePath(model.getPathToRoot(sourceNode));
                    } else {
                        Object[] removedChilds = new Object[]{sourceNode};
                        int[] childIndices = new int[]{oldParent.getIndex(sourceNode)};
                        sourceNode.removeFromParent();
                        model.nodesWereRemoved(oldParent, childIndices, removedChilds);
                        targetNode.insert(sourceNode, 0);
                        int[] insertedIndex = new int[]{0};
                        model.nodesWereInserted(targetNode, insertedIndex);
                        pathNewChild = new TreePath(model.getPathToRoot(sourceNode));
                    }
                    if (pathNewChild == null) break;
                    JDragTree.this.setSelectionPath(pathNewChild);
                    break;
                }
                catch (UnsupportedFlavorException ufe) {
                    logger.log(Level.SEVERE, "Exception thrown in drop(DropTargetDropEvent e)", ufe);
                    e.dropComplete(false);
                    return;
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "Exception thrown in drop(DropTargetDropEvent e)", ioe);
                    e.dropComplete(false);
                    return;
                }
            }
            e.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            if ((e.getDropAction() & 2) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(TREEPATH_FLAVOR)) {
                return false;
            }
            Point pt = e.getLocation();
            TreePath path = JDragTree.this.getClosestPathForLocation(pt.x, pt.y);
            return path != null && !path.equals(JDragTree.this._pathSource);
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            if ((e.getDropAction() & 2) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(TREEPATH_FLAVOR)) {
                return false;
            }
            Point pt = e.getLocation();
            TreePath path = JDragTree.this.getClosestPathForLocation(pt.x, pt.y);
            return path != null && !path.equals(JDragTree.this._pathSource);
        }
    }
}

