/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class JDialogWithDetails
extends JDialog {
    protected Language language = null;
    private boolean moreExtended = false;
    private Listener listener = new Listener();
    private JPanel userPanel = new JPanel();
    private JPanel buttonsPanel = new JPanel();
    private JPanel contentPanel = new JPanel();
    private JPanel morePanel;
    private JButton okButton = new JButton();
    private JButton moreButton = new JButton();
    private JTextArea moreTextArea = new JTextArea();
    private JScrollPane moreScrollPane = new JScrollPane(this.moreTextArea);

    public JDialogWithDetails(Frame parent) {
        this(parent, "");
    }

    public JDialogWithDetails(Frame parent, String title) {
        super(parent);
        this.language = Language.getInstance();
        this.setTitle(title);
        this.initialize();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getMorePanel() {
        if (this.morePanel == null) {
            this.morePanel = new JPanel(new BorderLayout());
            this.morePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            new TextComponentClipboardMenu(this.moreTextArea, this.language);
            this.moreTextArea.setEditable(false);
            this.moreTextArea.setColumns(10);
            this.moreTextArea.setMargin(new Insets(0, 3, 0, 3));
            this.moreTextArea.setRows(10);
            this.morePanel.add((Component)this.moreScrollPane, "Center");
        }
        return this.morePanel;
    }

    private void initialize() {
        this.setModal(true);
        this.moreButton.setText(this.language.getString("DialogWithDetails.button.more") + " >>");
        this.okButton.setText(this.language.getString("Common.ok"));
        this.buttonsPanel.setLayout(new FlowLayout(2, 10, 10));
        this.buttonsPanel.add(this.moreButton);
        this.buttonsPanel.add(this.okButton);
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.buttonsPanel, "Center");
        this.contentPanel.add((Component)this.userPanel, "North");
        this.getContentPane().add((Component)this.contentPanel, null);
        this.okButton.addActionListener(this.listener);
        this.moreButton.addActionListener(this.listener);
        this.addWindowListener(this.listener);
    }

    private void moreButtonPressed() {
        if (this.moreExtended) {
            this.moreButton.setText(this.language.getString("DialogWithDetails.button.more") + " >>");
            this.contentPanel.remove(this.getMorePanel());
            this.pack();
            this.moreExtended = false;
        } else {
            this.contentPanel.add((Component)this.getMorePanel(), "South");
            this.moreButton.setText(this.language.getString("DialogWithDetails.button.less") + " <<");
            this.pack();
            this.moreExtended = true;
        }
    }

    public void setDetailsText(String details) {
        this.moreTextArea.setText(details);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialogWithDetails.this.moreScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    protected JPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public JPanel getUserPanel() {
        return this.userPanel;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(b);
    }

    public static void showWarningDialog(Frame parent, String title, String message, String details) {
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        JDialogWithDetails.showDialog(parent, icon, title, message, details);
    }

    public static void showErrorDialog(Frame parent, String title, String message, String details) {
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        JDialogWithDetails.showDialog(parent, icon, title, message, details);
    }

    public static void showDialog(Frame parent, Icon icon, String title, String message, String details) {
        JDialogWithDetails dialog = new JDialogWithDetails(parent, title);
        JPanel imagePanel = new JPanel();
        JLabel imageLabel = new JLabel();
        imagePanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 10));
        imageLabel.setIcon(icon);
        imagePanel.add(imageLabel);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        messagePanel.setBorder(new EmptyBorder(10, 10, 10, 20));
        messagePanel.add((Component)new JLabel(message), "Center");
        dialog.getUserPanel().setLayout(new BorderLayout());
        dialog.getUserPanel().add((Component)imagePanel, "West");
        dialog.getUserPanel().add((Component)messagePanel, "Center");
        dialog.setDetailsText(details);
        dialog.setVisible(true);
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == JDialogWithDetails.this.moreButton) {
                JDialogWithDetails.this.moreButtonPressed();
            }
            if (e.getSource() == JDialogWithDetails.this.okButton) {
                JDialogWithDetails.this.close();
            }
        }

        public void windowClosing(WindowEvent e) {
            JDialogWithDetails.this.close();
            super.windowClosing(e);
        }
    }
}

