/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.MiscToolkit;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CloseableTabbedPane
extends JTabbedPane {
    private final Icon closeIcon;

    public CloseableTabbedPane(Icon closeIcon) {
        this.closeIcon = closeIcon;
        this.addMouseListener(new ClosingListener());
    }

    public CloseableTabbedPane() {
        this(MiscToolkit.loadImageIcon("/data/closeTab.gif"));
    }

    public void addTab(String title, Component component, Icon icon, boolean closeable) {
        if (closeable) {
            super.addTab(null, new WrapperIcon(title, icon), component);
        } else {
            super.addTab(title, icon, component);
        }
        this.setSelectedComponent(component);
    }

    public void addTab(String title, Component component, Icon icon) {
        this.addTab(title, component, icon, true);
    }

    public void addTab(String title, Component component) {
        this.addTab(title, component, null, true);
    }

    public void setTitleAt(int index, String newTitle) {
        WrapperIcon icon = (WrapperIcon)this.getIconAt(index);
        if (icon != null) {
            icon.setTitle(newTitle);
            this.revalidate();
            this.repaint();
        } else {
            super.setTitleAt(index, newTitle);
        }
    }

    protected void tabWasClosed(Component c) {
    }

    protected class EventIcon
    implements Icon {
        private final Icon icon;
        private int x = 0;
        private int y = 0;
        private int height = 10;
        private int width = 10;

        public EventIcon(Icon icon) {
            this.icon = icon;
            if (icon != null) {
                this.height = icon.getIconHeight();
                this.width = icon.getIconWidth();
            }
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component c, Graphics g, int x2, int y2) {
            this.x = x2;
            this.y = y2;
            if (this.icon != null) {
                this.icon.paintIcon(c, g, x2, y2);
            } else {
                g.drawLine(x2, y2, x2 + this.width, y2 + this.height);
                g.drawLine(x2, y2 + this.height, x2 + this.width, y2);
            }
        }

        public boolean contains(int xEvent, int yEvent) {
            if (xEvent < this.x || xEvent > this.x + this.width) {
                return false;
            }
            return yEvent >= this.y && yEvent <= this.y + this.height;
        }
    }

    protected class WrapperIcon
    implements Icon {
        private final Icon leftIcon;
        private final EventIcon rightIcon;
        private String title;
        private int height = 10;

        public WrapperIcon(String title) {
            this(title, null);
        }

        public WrapperIcon(String title, Icon leftIcon) {
            this.title = title;
            this.leftIcon = leftIcon;
            this.rightIcon = new EventIcon(CloseableTabbedPane.this.closeIcon);
            this.height = this.rightIcon.getIconHeight();
        }

        public void setTitle(String newTitle) {
            this.title = newTitle;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            int textWidth = SwingUtilities.computeStringWidth(CloseableTabbedPane.this.getFontMetrics(CloseableTabbedPane.this.getFont()), this.title);
            if (this.leftIcon != null) {
                return this.leftIcon.getIconWidth() + this.rightIcon.getIconWidth() + textWidth + 16;
            }
            return textWidth + 8 + this.rightIcon.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Rectangle rect = new Rectangle(x, y, this.getIconWidth(), this.getIconHeight());
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            SwingUtilities.layoutCompoundLabel(CloseableTabbedPane.this, g.getFontMetrics(), this.title, this.rightIcon, 0, 0, 0, 11, rect, iconRect, textRect, UIManager.getInt("TabbedPane.textIconGap"));
            if (this.leftIcon != null) {
                this.leftIcon.paintIcon(c, g, x, y + 1);
                g.setFont(CloseableTabbedPane.this.getFont());
                g.drawString(this.title, x + this.leftIcon.getIconWidth() + 8, textRect.y + g.getFontMetrics().getAscent());
                this.rightIcon.paintIcon(c, g, x + this.getIconWidth() - this.rightIcon.getIconWidth(), y + 1);
            } else {
                g.drawString(this.title, x, textRect.y + g.getFontMetrics().getAscent());
                this.rightIcon.paintIcon(c, g, x + this.getIconWidth() - this.rightIcon.getIconWidth(), y + 1);
            }
        }

        public boolean contains(int xEvent, int yEvent) {
            return this.rightIcon.contains(xEvent, yEvent);
        }
    }

    protected class ClosingListener
    extends MouseAdapter {
        protected ClosingListener() {
        }

        public void mouseReleased(MouseEvent e) {
            int i = CloseableTabbedPane.this.getSelectedIndex();
            if (i == -1) {
                return;
            }
            WrapperIcon icon = (WrapperIcon)CloseableTabbedPane.this.getIconAt(i);
            if (icon != null && icon.contains(e.getX(), e.getY())) {
                Component c = CloseableTabbedPane.this.getComponentAt(i);
                CloseableTabbedPane.this.removeTabAt(i);
                CloseableTabbedPane.this.tabWasClosed(c);
            }
        }
    }
}

