/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSearchFun {
    private static final SearchStringParser searchStringParser = new SearchStringParser();
    private static final String NOT_IDENT = ">?*NOT*?<";
    private static List<String> emptyList = new LinkedList<String>();

    public static boolean containsAnyString(String text, List<String> notStrings) {
        if (notStrings != null && !notStrings.isEmpty() && text != null && text.length() > 0) {
            for (int x = 0; x < notStrings.size(); ++x) {
                String notName = notStrings.get(x);
                if (text.indexOf(notName) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsEachString(String text, List<String> strings) {
        for (int x = 0; x < strings.size(); ++x) {
            String string = strings.get(x);
            if (text.indexOf(string) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String>[] splitStrings(String input, boolean makeLowerCase) {
        List<String> strList;
        SearchStringParser searchStringParser = TextSearchFun.searchStringParser;
        synchronized (searchStringParser) {
            strList = TextSearchFun.searchStringParser.parseSearchText(input);
        }
        List[] retVal = new List[2];
        ArrayList<String> searchStrings = new ArrayList<String>();
        ArrayList<String> notSearchStrings = new ArrayList<String>();
        retVal[0] = searchStrings;
        retVal[1] = notSearchStrings;
        boolean collectNotStrings = false;
        for (String s : strList) {
            if (s.equals(NOT_IDENT)) {
                collectNotStrings = true;
                continue;
            }
            if (makeLowerCase) {
                s = s.toLowerCase();
            }
            if (!collectNotStrings) {
                searchStrings.add(s);
                continue;
            }
            notSearchStrings.add(s);
        }
        return retVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchStringParser {
        private String fSearchText;
        private static final String fDOUBLE_QUOTE = "\"";
        private static final String fWHITESPACE_AND_QUOTES = " \t\r\n\"";
        private static final String fQUOTES_ONLY = "\"";
        private boolean notAdded;

        private SearchStringParser() {
        }

        public List<String> parseSearchText(String aSearchText) {
            if (aSearchText == null) {
                return emptyList;
            }
            this.fSearchText = aSearchText;
            this.notAdded = false;
            LinkedList<String> result = new LinkedList<String>();
            boolean returnTokens = true;
            String currentDelims = fWHITESPACE_AND_QUOTES;
            StringTokenizer parser = new StringTokenizer(this.fSearchText, currentDelims, returnTokens);
            String token = null;
            boolean inQuotes = false;
            while (parser.hasMoreTokens()) {
                token = parser.nextToken(currentDelims);
                if (!this.isDoubleQuote(token)) {
                    this.addNonTrivialWordToResult(token, result, inQuotes);
                    continue;
                }
                currentDelims = this.flipDelimiters(currentDelims);
                inQuotes = !inQuotes;
            }
            return result;
        }

        private boolean textHasContent(String aText) {
            return aText != null && aText.trim().length() > 0;
        }

        private void addNonTrivialWordToResult(String aToken, List<String> aResult, boolean inQuotes) {
            if (this.textHasContent(aToken)) {
                aToken = aToken.trim();
                if (!inQuotes && aToken.equals("NOT")) {
                    if (!this.notAdded) {
                        aResult.add(TextSearchFun.NOT_IDENT);
                        this.notAdded = true;
                    }
                } else {
                    aResult.add(aToken.trim());
                }
            }
        }

        private boolean isDoubleQuote(String aToken) {
            return aToken.equals("\"");
        }

        private String flipDelimiters(String aCurrentDelims) {
            String result = null;
            result = aCurrentDelims.equals(fWHITESPACE_AND_QUOTES) ? "\"" : fWHITESPACE_AND_QUOTES;
            return result;
        }
    }
}

