/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.util.FlexibleObserver;
import java.util.Vector;

public class FlexibleObservable {
    private boolean changed = false;
    protected Vector<FlexibleObserver> observers = new Vector();

    public synchronized void addObserver(FlexibleObserver o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!this.observers.contains(o)) {
            this.observers.addElement(o);
        }
    }

    public synchronized void deleteObserver(FlexibleObserver o) {
        this.observers.removeElement(o);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object arg) {
        Object[] arrLocal;
        FlexibleObservable flexibleObservable = this;
        synchronized (flexibleObservable) {
            if (!this.changed) {
                return;
            }
            arrLocal = this.observers.toArray();
            this.clearChanged();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((FlexibleObserver)arrLocal[i]).update(this, arg);
        }
    }

    public synchronized void deleteObservers() {
        this.observers.removeAllElements();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.observers.size();
    }
}

