/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.fcp.FcpHandler;
import frost.util.CopyToClipboardItem;
import frost.util.gui.translation.Language;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class CopyToClipboard {
    private static Clipboard clipboard = null;
    private static DummyClipboardOwner dummyClipboardOwner = new DummyClipboardOwner();

    private static Clipboard getClipboard() {
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    public static void copyText(String text) {
        StringSelection selection = new StringSelection(text);
        CopyToClipboard.getClipboard().setContents(selection, dummyClipboardOwner);
    }

    public static void copyKeysAndFilenames(Object[] items) {
        if (items == null && items.length == 0) {
            return;
        }
        String keyNotAvailableMessage = Language.getInstance().getString("Common.copyToClipBoard.extendedInfo.keyNotAvailableYet");
        StringBuilder textToCopy = new StringBuilder();
        for (Object ditem : items) {
            if (!(ditem instanceof CopyToClipboardItem)) continue;
            CopyToClipboardItem item = (CopyToClipboardItem)ditem;
            CopyToClipboard.appendKeyAndFilename(textToCopy, item.getKey(), item.getFilename(), keyNotAvailableMessage);
            if (items.length <= 1) continue;
            textToCopy.append("\n");
        }
        CopyToClipboard.copyText(textToCopy.toString());
    }

    public static void copyExtendedInfo(Object[] items) {
        if (items == null && items.length == 0) {
            return;
        }
        String keyNotAvailableMessage = Language.getInstance().getString("Common.copyToClipBoard.extendedInfo.keyNotAvailableYet");
        String fileMessage = Language.getInstance().getString("Common.copyToClipBoard.extendedInfo.file") + " ";
        String keyMessage = Language.getInstance().getString("Common.copyToClipBoard.extendedInfo.key") + " ";
        String bytesMessage = Language.getInstance().getString("Common.copyToClipBoard.extendedInfo.bytes") + " ";
        StringBuilder textToCopy = new StringBuilder();
        for (Object ditem : items) {
            if (!(ditem instanceof CopyToClipboardItem)) continue;
            CopyToClipboardItem item = (CopyToClipboardItem)ditem;
            String key = item.getKey();
            if (key == null) {
                key = keyNotAvailableMessage;
            } else if (FcpHandler.isFreenet05()) {
                key = new StringBuffer().append(key).append("/").append(item.getFilename()).toString();
            } else if (key.indexOf("/") < 0) {
                key = new StringBuffer().append(key).append("/").append(item.getFilename()).toString();
            }
            String fs = item.getFileSize() < 0L ? "?" : Long.toString(item.getFileSize());
            textToCopy.append(fileMessage);
            textToCopy.append(item.getFilename()).append("\n");
            textToCopy.append(keyMessage);
            textToCopy.append(key).append("\n");
            textToCopy.append(bytesMessage);
            textToCopy.append(fs).append("\n\n");
        }
        textToCopy.deleteCharAt(textToCopy.length() - 1);
        CopyToClipboard.copyText(textToCopy.toString());
    }

    public static void copyKeys(Object[] items) {
        if (items == null && items.length == 0) {
            return;
        }
        String keyNotAvailableMessage = Language.getInstance().getString("Common.copyToClipBoard.extendedInfo.keyNotAvailableYet");
        StringBuilder textToCopy = new StringBuilder();
        for (Object ditem : items) {
            if (!(ditem instanceof CopyToClipboardItem)) continue;
            CopyToClipboardItem item = (CopyToClipboardItem)ditem;
            String key = item.getKey();
            if (key == null) {
                key = keyNotAvailableMessage;
            }
            textToCopy.append(key);
            if (items.length <= 1) continue;
            textToCopy.append("\n");
        }
        CopyToClipboard.copyText(textToCopy.toString());
    }

    private static void appendKeyAndFilename(StringBuilder textToCopy, String key, String filename, String keyNotAvailableMessage) {
        if (key == null) {
            key = keyNotAvailableMessage;
            textToCopy.append(filename);
        } else if (key.startsWith("CHK@")) {
            textToCopy.append(key);
            if (key.indexOf(47) < 0) {
                textToCopy.append("/");
                textToCopy.append(filename);
            }
        } else {
            textToCopy.append(key);
        }
    }

    private static class DummyClipboardOwner
    implements ClipboardOwner {
        private DummyClipboardOwner() {
        }

        public void lostOwnership(Clipboard tclipboard, Transferable contents) {
        }
    }
}

