/*
 * Decompiled with CFR 0.152.
 */
package frost.transferlayer;

import frost.fcp.FcpHandler;
import frost.fcp.FcpResultPut;
import frost.storage.perst.IndexSlot;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalFileUploader {
    private static final Logger logger = Logger.getLogger(GlobalFileUploader.class.getName());

    public static boolean uploadFile(IndexSlot gis, File uploadFile, String insertKey, String insertKeyExtension, boolean doMime) {
        boolean success = false;
        boolean error = false;
        try {
            int tries = 0;
            int maxTries = 3;
            int index = gis.findFirstUploadSlot();
            while (!success && !error) {
                logger.info("Trying file upload to index " + index);
                FcpResultPut result = FcpHandler.inst().putFile(1, insertKey + index + insertKeyExtension, uploadFile, null, false, true, doMime);
                if (result.isSuccess()) {
                    gis.setUploadSlotUsed(index);
                    gis.modify();
                    logger.info("FILEDN: File successfully uploaded.");
                    success = true;
                    continue;
                }
                if (result.isKeyCollision()) {
                    index = gis.findNextUploadSlot(index);
                    tries = 0;
                    logger.info("FILEDN: File collided, increasing index.");
                    continue;
                }
                if (++tries < 3) {
                    logger.info("FILEDN: Upload error (try #" + tries + "), retrying index " + index);
                    continue;
                }
                logger.info("FILEDN: Upload error (try #" + tries + "), giving up on index " + index);
                error = true;
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception in uploadFile", e);
        }
        logger.info("FILEDN: File upload finished, file uploaded state is: " + success);
        return success;
    }
}

