/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.MainFrame;
import frost.boards.Board;
import frost.gui.SearchMessagesConfig;
import frost.gui.SearchMessagesDialog;
import frost.messages.FrostMessageObject;
import frost.messages.FrostSearchResultMessageObject;
import frost.storage.MessageCallback;
import frost.storage.perst.messagearchive.ArchiveMessageStorage;
import frost.storage.perst.messages.MessageStorage;
import frost.util.TextSearchFun;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMessagesThread
extends Thread
implements MessageCallback {
    private static final Logger logger = Logger.getLogger(SearchMessagesThread.class.getName());
    SearchMessagesDialog searchDialog;
    SearchMessagesConfig searchConfig;
    private final TrustStates trustStates = new TrustStates();
    private boolean stopRequested = false;

    public SearchMessagesThread(SearchMessagesDialog searchDlg, SearchMessagesConfig searchCfg) {
        this.searchDialog = searchDlg;
        this.searchConfig = searchCfg;
    }

    @Override
    public void run() {
        try {
            List<Board> boardsToSearch = this.searchConfig.searchBoards == 1 ? MainFrame.getInstance().getTofTreeModel().getAllBoards() : (this.searchConfig.searchBoards == 3 ? this.searchConfig.chosedBoards : Collections.emptyList());
            DateRange dateRange = new DateRange();
            for (Board board : boardsToSearch) {
                if (!this.isStopRequested()) {
                    this.updateDateRangeForBoard(board, dateRange);
                    this.updateTrustStatesForBoard(board, this.trustStates);
                    this.searchBoard(board, dateRange);
                    if (!this.isStopRequested()) continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Catched exception:", t);
        }
        this.searchDialog.notifySearchThreadFinished();
    }

    @Override
    public boolean messageRetrieved(FrostMessageObject mo) {
        this.searchMessage(mo);
        return this.isStopRequested();
    }

    private void searchBoard(Board board, DateRange dr) {
        if (this.searchConfig.searchInKeypool) {
            try {
                boolean retrieveDisplayedMessages = this.searchConfig.searchDates == 1;
                MessageStorage.inst().retrieveMessagesForSearch(board, dr.startDate, dr.endDate, retrieveDisplayedMessages, this.searchConfig.content != null && this.searchConfig.content.size() != 0, false, false, this);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Catched exception during getMessageTable().retrieveMessagesForSearch:", e);
            }
        }
        if (this.searchConfig.searchInArchive) {
            try {
                ArchiveMessageStorage.inst().retrieveMessagesForSearch(board, dr.startDate, dr.endDate, this);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Catched exception during getMessageArchiveTable().retrieveMessagesForSearch:", e);
            }
        }
    }

    private void searchMessage(FrostMessageObject mo) {
        if (this.searchConfig.searchPrivateMsgsOnly != null && (mo.getRecipientName() == null || mo.getRecipientName().length() == 0)) {
            return;
        }
        if (this.searchConfig.searchFlaggedMsgsOnly != null && mo.isFlagged() != this.searchConfig.searchFlaggedMsgsOnly.booleanValue()) {
            return;
        }
        if (this.searchConfig.searchStarredMsgsOnly != null && mo.isStarred() != this.searchConfig.searchStarredMsgsOnly.booleanValue()) {
            return;
        }
        if (this.searchConfig.searchRepliedMsgsOnly != null && mo.isReplied() != this.searchConfig.searchRepliedMsgsOnly.booleanValue()) {
            return;
        }
        if (!this.matchesTrustStates(mo, this.trustStates)) {
            return;
        }
        if (this.searchConfig.msgMustContainBoards && !mo.hasBoardAttachments()) {
            return;
        }
        if (this.searchConfig.msgMustContainFiles && !mo.hasFileAttachments()) {
            return;
        }
        if (!this.matchText(mo.getFromName(), this.searchConfig.senderMakeLowercase, this.searchConfig.sender, this.searchConfig.notSender)) {
            return;
        }
        if (!this.matchText(mo.getSubject(), this.searchConfig.subjectMakeLowercase, this.searchConfig.subject, this.searchConfig.notSubject)) {
            return;
        }
        if (!(this.searchConfig.content.isEmpty() && this.searchConfig.notContent.isEmpty() || this.matchText(mo.getContent(), this.searchConfig.contentMakeLowercase, this.searchConfig.content, this.searchConfig.notContent))) {
            return;
        }
        this.searchDialog.addFoundMessage(new FrostSearchResultMessageObject(mo));
    }

    private boolean matchText(String origText, boolean makeLowerCase, List<String> strings, List<String> notStrings) {
        if (!notStrings.isEmpty() || !strings.isEmpty()) {
            String text = makeLowerCase ? origText.toLowerCase() : origText;
            if (!notStrings.isEmpty() && TextSearchFun.containsAnyString(text, notStrings)) {
                return false;
            }
            if (!strings.isEmpty() && !TextSearchFun.containsEachString(text, strings)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesTrustStates(FrostMessageObject msg, TrustStates ts) {
        if (msg.isMessageStatusGOOD() && !ts.trust_good) {
            return false;
        }
        if (msg.isMessageStatusOBSERVE() && !ts.trust_observe) {
            return false;
        }
        if (msg.isMessageStatusCHECK() && !ts.trust_check) {
            return false;
        }
        if (msg.isMessageStatusBAD() && !ts.trust_bad) {
            return false;
        }
        if (msg.isMessageStatusOLD() && !ts.trust_none) {
            return false;
        }
        return !msg.isMessageStatusTAMPERED() || ts.trust_tampered;
    }

    private void updateTrustStatesForBoard(Board b, TrustStates ts) {
        if (this.searchConfig.searchTruststates == 2) {
            ts.trust_good = true;
            ts.trust_observe = true;
            ts.trust_check = true;
            ts.trust_bad = true;
            ts.trust_none = true;
            ts.trust_tampered = true;
        } else if (this.searchConfig.searchTruststates == 3) {
            ts.trust_good = this.searchConfig.trust_good;
            ts.trust_observe = this.searchConfig.trust_observe;
            ts.trust_check = this.searchConfig.trust_check;
            ts.trust_bad = this.searchConfig.trust_bad;
            ts.trust_none = this.searchConfig.trust_none;
            ts.trust_tampered = this.searchConfig.trust_tampered;
        } else if (this.searchConfig.searchTruststates == 1) {
            ts.trust_good = true;
            ts.trust_observe = !b.getHideObserve();
            ts.trust_check = !b.getHideCheck();
            ts.trust_bad = !b.getHideBad();
            ts.trust_none = !b.getShowSignedOnly();
            ts.trust_tampered = !b.getShowSignedOnly();
        }
    }

    private void updateDateRangeForBoard(Board b, DateRange dr) {
        LocalDate nowLocalDate = new LocalDate(DateTimeZone.UTC);
        long todayMillis = nowLocalDate.plusDays(1).toDateMidnight(DateTimeZone.UTC).getMillis();
        if (this.searchConfig.searchDates == 1) {
            dr.startDate = nowLocalDate.minusDays(b.getMaxMessageDisplay()).toDateMidnight(DateTimeZone.UTC).getMillis();
            dr.endDate = todayMillis;
        } else if (this.searchConfig.searchDates == 4) {
            dr.startDate = nowLocalDate.minusDays(this.searchConfig.daysBackward).toDateMidnight(DateTimeZone.UTC).getMillis();
            dr.endDate = todayMillis;
        } else if (this.searchConfig.searchDates == 3) {
            dr.startDate = new LocalDate(this.searchConfig.startDate).toDateMidnight(DateTimeZone.UTC).getMillis();
            dr.endDate = new LocalDate(this.searchConfig.endDate).plusDays(1).toDateMidnight(DateTimeZone.UTC).getMillis();
        } else {
            dr.startDate = 0L;
            dr.endDate = todayMillis;
        }
    }

    public synchronized boolean isStopRequested() {
        return this.stopRequested;
    }

    public synchronized void requestStop() {
        this.stopRequested = true;
    }

    private class TrustStates {
        public boolean trust_good = false;
        public boolean trust_observe = false;
        public boolean trust_check = false;
        public boolean trust_bad = false;
        public boolean trust_none = false;
        public boolean trust_tampered = false;

        private TrustStates() {
        }
    }

    private class DateRange {
        long startDate;
        long endDate;

        private DateRange() {
        }
    }
}

