/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.fileTransfer.FileListFile;
import frost.fileTransfer.FileListFileContent;
import frost.fileTransfer.FileListManager;
import frost.fileTransfer.SharedFilesCHKKeyManager;
import frost.transferlayer.GlobalFileDownloader;
import frost.transferlayer.GlobalFileDownloaderResult;
import frost.util.Logging;
import frost.util.Mixed;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileListDownloadThread
extends Thread {
    private static final Logger logger = Logger.getLogger(FileListDownloadThread.class.getName());
    private static final int wait1minute = 60000;
    private final CHKKeyQueue keyQueue = new CHKKeyQueue();
    private static FileListDownloadThread instance = new FileListDownloadThread();

    private FileListDownloadThread() {
    }

    public static FileListDownloadThread getInstance() {
        return instance;
    }

    public boolean cancelThread() {
        return false;
    }

    public void run() {
        this.initializeQueue();
        int maxAllowedExceptions = 5;
        int occuredExceptions = 0;
        String previousKey = null;
        do {
            try {
                GlobalFileDownloaderResult result;
                String chkKey;
                while (true) {
                    if ((chkKey = this.keyQueue.getKeyFromQueue()) == null) {
                        if (Logging.inst().doLogFilebaseMessages()) {
                            System.out.println("FileListDownloadThread: waiting 1 minute, chkKey=null");
                        }
                        Mixed.wait(60000);
                        continue;
                    }
                    if (previousKey != null && previousKey.equals(chkKey)) {
                        if (Logging.inst().doLogFilebaseMessages()) {
                            System.out.println("FileListDownloadThread: waiting 1 minute, same key as before");
                        }
                        Mixed.wait(60000);
                    } else {
                        Mixed.waitRandom(1000);
                        previousKey = chkKey;
                    }
                    if (Logging.inst().doLogFilebaseMessages()) {
                        System.out.println("FileListDownloadThread: starting download of key: " + chkKey);
                    }
                    if ((result = GlobalFileDownloader.downloadFile(chkKey, 540672, -1)) != null && result.getResultFile() != null) break;
                    boolean retryDownload = SharedFilesCHKKeyManager.updateCHKKeyDownloadFailed(chkKey);
                    if (Logging.inst().doLogFilebaseMessages()) {
                        System.out.println("FileListDownloadThread: download failed, key=" + chkKey + "; retry=" + retryDownload);
                    }
                    if (!retryDownload) continue;
                    this.keyQueue.appendKeyToQueue(chkKey);
                }
                if (Logging.inst().doLogFilebaseMessages()) {
                    System.out.println("FileListDownloadThread: download successful, key=" + chkKey);
                }
                File downloadedFile = result.getResultFile();
                FileListFileContent content = null;
                try {
                    content = FileListFile.readFileListFile(downloadedFile);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Invalid XML content: " + e.getMessage());
                }
                boolean isValid = FileListManager.processReceivedFileList(content);
                if (Logging.inst().doLogFilebaseMessages()) {
                    System.out.println("FileListDownloadThread: processed results, isValid=" + isValid);
                }
                long timestamp = content == null ? System.currentTimeMillis() : content.getTimestamp();
                downloadedFile.delete();
                SharedFilesCHKKeyManager.updateCHKKeyDownloadSuccessful(chkKey, timestamp, isValid);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception catched", t);
                ++occuredExceptions;
            }
        } while (occuredExceptions <= 5);
        logger.log(Level.SEVERE, "Stopping FileListDownloadThread because of too much exceptions");
    }

    private void initializeQueue() {
        List<String> keys = SharedFilesCHKKeyManager.getCHKKeyStringsToDownload();
        if (keys == null) {
            return;
        }
        for (String chk : keys) {
            this.keyQueue.initialAppendKeyToQueue(chk);
        }
    }

    public void enqueueNewKey(String key) {
        this.keyQueue.appendKeyToQueue(key);
    }

    public int getCHKKeyQueueSize() {
        return this.keyQueue.getQueueSize();
    }

    private class CHKKeyQueue {
        private final LinkedList<String> queue = new LinkedList();

        private CHKKeyQueue() {
        }

        public synchronized String getKeyFromQueue() {
            try {
                while (this.queue.isEmpty()) {
                    if (Logging.inst().doLogFilebaseMessages()) {
                        System.out.println("CHKKeyQueue: Waiting for work, queue length=" + this.getQueueSize());
                    }
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                if (Logging.inst().doLogFilebaseMessages()) {
                    System.out.println("CHKKeyQueue: NO key returned(1), queue length=" + this.getQueueSize());
                }
                return null;
            }
            if (!this.queue.isEmpty()) {
                String key = this.queue.removeFirst();
                if (Logging.inst().doLogFilebaseMessages()) {
                    System.out.println("CHKKeyQueue: Key returned, new queue length=" + this.getQueueSize());
                }
                return key;
            }
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("CHKKeyQueue: NO key returned(2), queue length=" + this.getQueueSize());
            }
            return null;
        }

        public synchronized void initialAppendKeyToQueue(String key) {
            this.queue.addLast(key);
            this.notifyAll();
        }

        public synchronized void appendKeyToQueue(String key) {
            this.queue.addLast(key);
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("CHKKeyQueue: Key appended, new queue length=" + this.getQueueSize());
            }
            this.notifyAll();
        }

        public synchronized int getQueueSize() {
            return this.queue.size();
        }
    }
}

