/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultPut;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.messages.FileAttachment;
import frost.messages.FrostUnsentMessageObject;
import frost.messages.UnsentMessagesManager;
import frost.util.Mixed;
import frost.util.gui.translation.Language;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class FileAttachmentUploadThread
extends Thread {
    private static final Logger logger = Logger.getLogger(FileAttachmentUploadThread.class.getName());
    private static final int wait1minute = 60000;
    private final MessageQueue msgQueue = new MessageQueue();
    private static FileAttachmentUploadThread instance = new FileAttachmentUploadThread();

    private FileAttachmentUploadThread() {
    }

    public static FileAttachmentUploadThread getInstance() {
        return instance;
    }

    public boolean cancelThread() {
        return false;
    }

    public void run() {
        int maxAllowedExceptions = 5;
        int occuredExceptions = 0;
        do {
            try {
                FileAttachment fa;
                MessageFileAttachment msgFileAttachment;
                while (true) {
                    if (!Core.isFreenetOnline()) {
                        Mixed.wait(60000);
                        continue;
                    }
                    msgFileAttachment = this.msgQueue.getMessageFromQueue();
                    if (msgFileAttachment == null) {
                        Mixed.wait(60000);
                        continue;
                    }
                    Mixed.waitRandom(3000);
                    fa = msgFileAttachment.getFileAttachment();
                    if (fa.getInternalFile() == null || !fa.getInternalFile().isFile() || fa.getInternalFile().length() == 0L) {
                        Language language = Language.getInstance();
                        String title = language.getString("FileAttachmentUploadThread.fileNotFoundError.title");
                        String txt = language.formatMessage("FileAttachmentUploadThread.fileNotFoundError.text", fa.getFilename());
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), txt, title, 0);
                        logger.warning("FileAttachmentUploadThread: unsent file attachment disappeared: " + fa.getInternalFile() + "; " + fa.getFilename());
                        UnsentMessagesManager.deleteMessage(msgFileAttachment.getMessageObject());
                        continue;
                    }
                    if (!msgFileAttachment.isDeleted()) break;
                }
                logger.severe("Starting upload of file: " + fa.getInternalFile().getPath());
                String chkKey = null;
                try {
                    FcpResultPut result = FcpHandler.inst().putFile(2, "CHK@", fa.getInternalFile(), null, true, true, true, new FrostUploadItem());
                    if (result.isSuccess() || result.isKeyCollision()) {
                        chkKey = result.getChkKey();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Exception catched", ex);
                }
                logger.severe("Finished upload of " + fa.getInternalFile().getPath() + ", key: " + chkKey);
                if (msgFileAttachment.isDeleted()) continue;
                if (chkKey != null) {
                    fa.setKey(chkKey);
                    UnsentMessagesManager.updateMessageFileAttachmentKey(msgFileAttachment.getMessageObject(), msgFileAttachment.getFileAttachment());
                    continue;
                }
                this.msgQueue.appendToQueue(msgFileAttachment);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception catched", t);
                ++occuredExceptions;
            }
        } while (occuredExceptions <= 5);
        logger.log(Level.SEVERE, "Stopping because of too much exceptions");
    }

    public void messageWasDeleted(String messageId) {
        this.msgQueue.deleteAllItemsOfMessage(messageId);
    }

    public void checkAndEnqueueNewMessage(FrostUnsentMessageObject msg) {
        LinkedList<FileAttachment> unsend = msg.getUnsentFileAttachments();
        if (unsend != null && unsend.size() > 0) {
            for (FileAttachment fa : unsend) {
                MessageFileAttachment mfa = new MessageFileAttachment(msg, fa);
                this.msgQueue.appendToQueue(mfa);
            }
        }
    }

    public int getQueueSize() {
        return this.msgQueue.getQueueSize();
    }

    private class MessageFileAttachment {
        private final FrostUnsentMessageObject messageObject;
        private final FileAttachment fileAttachment;
        private boolean isDeleted = false;

        public MessageFileAttachment(FrostUnsentMessageObject mo, FileAttachment fa) {
            this.messageObject = mo;
            this.fileAttachment = fa;
        }

        public FileAttachment getFileAttachment() {
            return this.fileAttachment;
        }

        public FrostUnsentMessageObject getMessageObject() {
            return this.messageObject;
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public void setDeleted(boolean isDeleted) {
            this.isDeleted = isDeleted;
        }
    }

    private class MessageQueue {
        private final LinkedList<MessageFileAttachment> queue = new LinkedList();

        private MessageQueue() {
        }

        public synchronized MessageFileAttachment getMessageFromQueue() {
            try {
                while (this.queue.isEmpty()) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                return null;
            }
            if (!this.queue.isEmpty()) {
                MessageFileAttachment msg = this.queue.removeFirst();
                return msg;
            }
            return null;
        }

        public synchronized void appendToQueue(MessageFileAttachment msg) {
            this.queue.addLast(msg);
            this.notifyAll();
        }

        public synchronized void deleteAllItemsOfMessage(String messageId) {
            Iterator i = this.queue.iterator();
            while (i.hasNext()) {
                MessageFileAttachment mfa = (MessageFileAttachment)i.next();
                if (!mfa.getMessageObject().getMessageId().equals(messageId)) continue;
                mfa.setDeleted(true);
                i.remove();
            }
        }

        public synchronized int getQueueSize() {
            return this.queue.size();
        }
    }
}

