/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.boards.Board;
import frost.boards.BoardUpdateInformation;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import java.util.Iterator;
import java.util.Vector;

public class BoardUpdateThreadObject
extends Thread {
    private final Board targetBoard;
    private final Vector<BoardUpdateThreadListener> registeredListeners;
    long startTimeMillis = -1L;
    boolean isFinished = false;

    public BoardUpdateThreadObject(Board board) {
        super(board.getName());
        this.targetBoard = board;
        this.registeredListeners = new Vector();
    }

    public Board getTargetBoard() {
        return this.targetBoard;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public synchronized boolean isFinished() {
        return this.isFinished;
    }

    protected synchronized void threadFinished() {
        this.isFinished = true;
    }

    protected void notifyThreadStarted(BoardUpdateThread thread) {
        this.startTimeMillis = System.currentTimeMillis();
        Iterator<BoardUpdateThreadListener> i = this.registeredListeners.iterator();
        while (i.hasNext()) {
            i.next().boardUpdateThreadStarted(thread);
        }
    }

    protected void notifyThreadFinished(BoardUpdateThread thread) {
        this.threadFinished();
        Iterator<BoardUpdateThreadListener> i = this.registeredListeners.iterator();
        while (i.hasNext()) {
            i.next().boardUpdateThreadFinished(thread);
        }
    }

    protected void notifyBoardUpdateInformationChanged(BoardUpdateThread thread, BoardUpdateInformation bui) {
        Iterator<BoardUpdateThreadListener> i = this.registeredListeners.iterator();
        while (i.hasNext()) {
            i.next().boardUpdateInformationChanged(thread, bui);
        }
    }

    public void addBoardUpdateThreadListener(BoardUpdateThreadListener listener) {
        this.registeredListeners.add(listener);
    }

    public void removeBoardUpdateThreadListener(BoardUpdateThreadListener listener) {
        this.registeredListeners.remove(listener);
    }
}

