/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.messages;

import frost.messages.AttachmentList;
import frost.storage.ExitSavable;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.PerstString;
import frost.storage.perst.messages.MessageContentStorageRoot;
import frost.storage.perst.messages.PerstAttachments;

public class MessageContentStorage
extends AbstractFrostStorage
implements ExitSavable {
    private MessageContentStorageRoot storageRoot = null;
    private static final String STORAGE_FILENAME = "messagesContents.dbs";
    private static MessageContentStorage instance = new MessageContentStorage();

    protected MessageContentStorage() {
    }

    public static MessageContentStorage inst() {
        return instance;
    }

    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    public boolean initStorage() {
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.messagecontents");
        this.open(databaseFilePath, pagePoolSize, true, false, false);
        this.storageRoot = (MessageContentStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new MessageContentStorageRoot(this.getStorage());
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        }
        return true;
    }

    public void exitSave() {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: MessagesContentStorage closed.");
    }

    protected synchronized boolean addContentForOid(int oid, String content) {
        PerstString ps = new PerstString(content);
        return this.storageRoot.getContentByMsgOid().put(oid, ps);
    }

    protected synchronized boolean addPublickeyForOid(int oid, String content) {
        PerstString ps = new PerstString(content);
        return this.storageRoot.getPublickeyByMsgOid().put(oid, ps);
    }

    protected synchronized boolean addSignatureForOid(int oid, String content) {
        PerstString ps = new PerstString(content);
        return this.storageRoot.getSignatureByMsgOid().put(oid, ps);
    }

    protected synchronized boolean addAttachmentsForOid(int oid, AttachmentList boards, AttachmentList files) {
        PerstAttachments pa = new PerstAttachments(this.getStorage(), boards, files);
        return this.storageRoot.getAttachmentsByMsgOid().put(oid, pa);
    }

    protected synchronized String getContentForOid(int oid) {
        PerstString ps = (PerstString)this.storageRoot.getContentByMsgOid().get(oid);
        if (ps != null) {
            return ps.getValue();
        }
        return null;
    }

    protected synchronized String getPublickeyForOid(int oid) {
        PerstString ps = (PerstString)this.storageRoot.getPublickeyByMsgOid().get(oid);
        if (ps != null) {
            return ps.getValue();
        }
        return null;
    }

    protected synchronized String getSignatureForOid(int oid) {
        PerstString ps = (PerstString)this.storageRoot.getSignatureByMsgOid().get(oid);
        if (ps != null) {
            return ps.getValue();
        }
        return null;
    }

    protected synchronized PerstAttachments getAttachmentsForOid(int oid) {
        PerstAttachments pa = (PerstAttachments)this.storageRoot.getAttachmentsByMsgOid().get(oid);
        return pa;
    }

    protected synchronized void deallocateForOid(int oid) {
        PerstAttachments pa;
        PerstString ps = (PerstString)this.storageRoot.getContentByMsgOid().get(oid);
        if (ps != null) {
            this.storageRoot.getContentByMsgOid().removeKey(oid);
            ps.deallocate();
        }
        if ((ps = (PerstString)this.storageRoot.getPublickeyByMsgOid().get(oid)) != null) {
            this.storageRoot.getPublickeyByMsgOid().removeKey(oid);
            ps.deallocate();
        }
        if ((ps = (PerstString)this.storageRoot.getSignatureByMsgOid().get(oid)) != null) {
            this.storageRoot.getSignatureByMsgOid().removeKey(oid);
            ps.deallocate();
        }
        if ((pa = (PerstAttachments)this.storageRoot.getAttachmentsByMsgOid().get(oid)) != null) {
            this.storageRoot.getAttachmentsByMsgOid().removeKey(oid);
            pa.deallocate();
        }
    }
}

