/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.SharedFilesCHKKey;
import frost.storage.perst.SharedFilesCHKKeyStorageRoot;
import frost.util.Mixed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.garret.perst.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFilesCHKKeyStorage
extends AbstractFrostStorage
implements ExitSavable {
    private SharedFilesCHKKeyStorageRoot storageRoot = null;
    private static final String STORAGE_FILENAME = "sfChkKeys.dbs";
    private static SharedFilesCHKKeyStorage instance = new SharedFilesCHKKeyStorage();
    protected static final LastDownloadTryStopTimeComparator lastDownloadTryStopTimeComparator = new LastDownloadTryStopTimeComparator();
    protected static final SeenCountComparator seenCountComparator = new SeenCountComparator();

    protected SharedFilesCHKKeyStorage() {
    }

    public static SharedFilesCHKKeyStorage inst() {
        return instance;
    }

    private boolean addToIndices(SharedFilesCHKKey gis) {
        return this.storageRoot.chkKeys.put(gis.getChkKey(), gis);
    }

    public void storeItem(SharedFilesCHKKey gis) {
        if (this.getStorage() == null) {
            return;
        }
        if (gis.getStorage() == null) {
            gis.makePersistent(this.getStorage());
            this.addToIndices(gis);
        } else {
            gis.modify();
        }
    }

    @Override
    public void exitSave() throws StorageException {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: SharedFilesCHKKeyStorage closed.");
    }

    @Override
    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    @Override
    public boolean initStorage() {
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.sharedfilechkkeys");
        this.open(databaseFilePath, pagePoolSize, true, true, false);
        this.storageRoot = (SharedFilesCHKKeyStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new SharedFilesCHKKeyStorageRoot();
            this.storageRoot.chkKeys = this.getStorage().createIndex(String.class, true);
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SharedFilesCHKKey> getSharedFilesCHKKeysToSend(int maxKeys) {
        int ownKeysToSend = 5 + (int)(Math.random() * 5.0);
        LinkedList<SharedFilesCHKKey> keysToSend = new LinkedList<SharedFilesCHKKey>();
        if (!this.beginCooperativeThreadTransaction()) {
            return keysToSend;
        }
        try {
            for (SharedFilesCHKKey sfk : this.storageRoot.chkKeys) {
                if (sfk.getSeenCount() != 0) continue;
                keysToSend.add(sfk);
                if (keysToSend.size() < ownKeysToSend) continue;
                break;
            }
            maxKeys -= keysToSend.size();
            long now = System.currentTimeMillis();
            long minFirstSeen = now - 604800000L;
            long maxLastSeen = now - 86400000L;
            ArrayList<SharedFilesCHKKey> otherKeysToSend = new ArrayList<SharedFilesCHKKey>();
            for (SharedFilesCHKKey sfk : this.storageRoot.chkKeys) {
                if (!sfk.isDownloaded() || !sfk.isValid() || sfk.getLastSeen() >= maxLastSeen || sfk.getLastSent() >= maxLastSeen || sfk.getFirstSeen() <= minFirstSeen) continue;
                otherKeysToSend.add(sfk);
            }
            Collections.sort(otherKeysToSend, seenCountComparator);
            if (otherKeysToSend.size() > 0) {
                keysToSend.addAll(otherKeysToSend.subList(0, Math.min(maxKeys, otherKeysToSend.size())));
            }
            otherKeysToSend.clear();
        }
        finally {
            this.endThreadTransaction();
        }
        return keysToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedFilesCHKKey retrieveSharedFilesCHKKey(String chkKey) {
        SharedFilesCHKKey key;
        if (!this.beginCooperativeThreadTransaction()) {
            return null;
        }
        try {
            key = (SharedFilesCHKKey)this.storageRoot.chkKeys.get(new Key(chkKey));
        }
        finally {
            this.endThreadTransaction();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> retrieveSharedFilesCHKKeysToDownload(int maxRetries) {
        ArrayList<SharedFilesCHKKey> keysToDownload = new ArrayList<SharedFilesCHKKey>();
        if (!this.beginCooperativeThreadTransaction()) {
            return Collections.emptyList();
        }
        try {
            for (SharedFilesCHKKey sfk : this.storageRoot.chkKeys) {
                if (sfk.isDownloaded() || sfk.getDownloadRetries() >= maxRetries) continue;
                keysToDownload.add(sfk);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        Collections.sort(keysToDownload, lastDownloadTryStopTimeComparator);
        LinkedList<String> chkKeys = new LinkedList<String>();
        for (SharedFilesCHKKey sfk : keysToDownload) {
            chkKeys.add(sfk.getChkKey());
        }
        keysToDownload.clear();
        return chkKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSharedFilesCHKKeyAfterDownloadSuccessful(String chkKey, long timestamp, boolean isValid) {
        if (!this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            SharedFilesCHKKey key = (SharedFilesCHKKey)this.storageRoot.chkKeys.get(new Key(chkKey));
            if (key == null) {
                boolean bl = false;
                return bl;
            }
            key.setDownloaded(true);
            if (key.getFirstSeen() > timestamp) {
                key.setFirstSeen(timestamp);
            }
            key.setValid(isValid);
            key.modify();
        }
        finally {
            this.endThreadTransaction();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSharedFilesCHKKeyAfterDownloadFailed(String chkKey, int maxRetries) {
        if (!this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            SharedFilesCHKKey key = (SharedFilesCHKKey)this.storageRoot.chkKeys.get(new Key(chkKey));
            if (key == null) {
                this.endThreadTransaction();
                boolean bl = false;
                return bl;
            }
            key.incDownloadRetries();
            key.setLastDownloadTryStopTime(System.currentTimeMillis());
            key.modify();
            if (key.getDownloadRetries() < maxRetries) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cleanupTable(int maxDaysOld) {
        long minVal = System.currentTimeMillis() - (long)maxDaysOld * 24L * 60L * 60L * 1000L;
        int deletedCount = 0;
        this.beginExclusiveThreadTransaction();
        try {
            Iterator i = this.storageRoot.chkKeys.iterator();
            while (i.hasNext()) {
                SharedFilesCHKKey sfk = (SharedFilesCHKKey)i.next();
                if (sfk.getLastSeen() <= 0L || sfk.getLastSeen() >= minVal) continue;
                i.remove();
                sfk.deallocate();
                ++deletedCount;
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return deletedCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SeenCountComparator
    implements Comparator<SharedFilesCHKKey> {
        protected SeenCountComparator() {
        }

        @Override
        public int compare(SharedFilesCHKKey arg0, SharedFilesCHKKey arg1) {
            return Mixed.compareInt(arg0.getSeenCount(), arg0.getSeenCount());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LastDownloadTryStopTimeComparator
    implements Comparator<SharedFilesCHKKey> {
        protected LastDownloadTryStopTimeComparator() {
        }

        @Override
        public int compare(SharedFilesCHKKey arg0, SharedFilesCHKKey arg1) {
            return Mixed.compareLong(arg0.getLastDownloadTryStopTime(), arg1.getLastDownloadTryStopTime());
        }
    }
}

