/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.Core;
import frost.MainFrame;
import frost.boards.Board;
import frost.messages.FileAttachment;
import frost.messages.FrostUnsentMessageObject;
import frost.storage.perst.messages.MessageStorage;
import frost.threads.FileAttachmentUploadThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsentMessagesManager {
    private static final LinkedList<FrostUnsentMessageObject> unsentMessages = new LinkedList();
    private static int runningMessageUploads = 0;

    public static void initialize() {
        List<FrostUnsentMessageObject> msgs = MessageStorage.inst().retrieveAllUnsentMessages();
        if (msgs == null || msgs.size() == 0) {
            return;
        }
        unsentMessages.addAll(msgs);
        for (FrostUnsentMessageObject msg : unsentMessages) {
            FileAttachmentUploadThread.getInstance().checkAndEnqueueNewMessage(msg);
        }
        MainFrame.getInstance().updateTofTree(MainFrame.getInstance().getTofTree().getUnsentMessagesFolder());
    }

    public static int getUnsentMessageCount() {
        return unsentMessages.size();
    }

    public static List<FrostUnsentMessageObject> getUnsentMessages() {
        return unsentMessages;
    }

    public static FrostUnsentMessageObject getUnsentMessage(Board targetBoard) {
        return UnsentMessagesManager.getUnsentMessage(targetBoard, null);
    }

    public static FrostUnsentMessageObject getUnsentMessage(Board targetBoard, String fromName) {
        if (Core.frostSettings.getBoolValue("messageUploadDisabled")) {
            return null;
        }
        for (FrostUnsentMessageObject mo : unsentMessages) {
            if (mo.getCurrentUploadThread() != null || mo.getBoard().getPerstFrostBoardObject().getBoardId() != targetBoard.getPerstFrostBoardObject().getBoardId() || fromName != null && !fromName.equals(mo.getFromName()) || mo.getUnsentFileAttachments().size() != 0) continue;
            return mo;
        }
        return null;
    }

    public static List<Board> getBoardsWithSendableMessages() {
        if (Core.frostSettings.getBoolValue("messageUploadDisabled")) {
            return Collections.emptyList();
        }
        Hashtable<Integer, Board> ht = new Hashtable<Integer, Board>();
        for (FrostUnsentMessageObject mo : unsentMessages) {
            if (mo.getCurrentUploadThread() != null || mo.getBoard().isDosForToday() || ht.containsKey(mo.getBoard().getPerstFrostBoardObject().getBoardId())) continue;
            ht.put(mo.getBoard().getPerstFrostBoardObject().getBoardId(), mo.getBoard());
        }
        ArrayList<Board> result = new ArrayList<Board>(ht.values());
        return result;
    }

    public static void addNewUnsentMessage(FrostUnsentMessageObject mo) {
        mo.setTimeAdded(System.currentTimeMillis());
        MessageStorage.inst().insertUnsentMessage(mo);
        unsentMessages.add(mo);
        FileAttachmentUploadThread.getInstance().checkAndEnqueueNewMessage(mo);
        MainFrame.getInstance().getUnsentMessagesPanel().addUnsentMessage(mo);
        MainFrame.getInstance().updateTofTree(MainFrame.getInstance().getTofTree().getUnsentMessagesFolder());
    }

    public static boolean deleteMessage(FrostUnsentMessageObject unsentMsg) {
        if (unsentMsg.getCurrentUploadThread() != null) {
            return false;
        }
        MessageStorage.inst().deleteUnsentMessage(unsentMsg);
        Iterator i = unsentMessages.iterator();
        while (i.hasNext()) {
            FrostUnsentMessageObject mo = (FrostUnsentMessageObject)i.next();
            if (!unsentMsg.getMessageId().equals(mo.getMessageId())) continue;
            i.remove();
            break;
        }
        FileAttachmentUploadThread.getInstance().messageWasDeleted(unsentMsg.getMessageId());
        MainFrame.getInstance().getUnsentMessagesPanel().removeUnsentMessage(unsentMsg);
        MainFrame.getInstance().updateTofTree(MainFrame.getInstance().getTofTree().getUnsentMessagesFolder());
        return true;
    }

    public static boolean dequeueMessage(FrostUnsentMessageObject unsentMsg) {
        Iterator i = unsentMessages.iterator();
        while (i.hasNext()) {
            FrostUnsentMessageObject mo = (FrostUnsentMessageObject)i.next();
            if (!unsentMsg.getMessageId().equals(mo.getMessageId())) continue;
            i.remove();
            break;
        }
        MainFrame.getInstance().getUnsentMessagesPanel().removeUnsentMessage(unsentMsg);
        MainFrame.getInstance().updateTofTree(MainFrame.getInstance().getTofTree().getUnsentMessagesFolder());
        return true;
    }

    public static void updateMessageFileAttachmentKey(FrostUnsentMessageObject mo, FileAttachment fa) {
        MessageStorage.inst().updateUnsentMessageFileAttachmentKey(mo, fa);
    }

    public static synchronized int getRunningMessageUploads() {
        return runningMessageUploads;
    }

    public static synchronized void incRunningMessageUploads() {
        ++runningMessageUploads;
    }

    public static synchronized void decRunningMessageUploads() {
        --runningMessageUploads;
    }
}

