/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.MainFrame;
import frost.boards.Board;
import frost.messages.FrostMessageObject;
import frost.storage.perst.messages.MessageStorage;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentMessagesManager {
    private static final Logger logger = Logger.getLogger(SentMessagesManager.class.getName());

    public static List<FrostMessageObject> retrieveSentMessages() {
        try {
            return MessageStorage.inst().retrieveAllSentMessages();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error retrieving sent messages", t);
            return new LinkedList<FrostMessageObject>();
        }
    }

    public static boolean addSentMessage(FrostMessageObject sentMo) {
        Board b = sentMo.getBoard();
        if (!b.getStoreSentMessages()) {
            return false;
        }
        try {
            MessageStorage.inst().insertSentMessage(sentMo);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error inserting sent message", e);
        }
        return MainFrame.getInstance().getSentMessagesPanel().addSentMessage(sentMo);
    }

    public static int deleteSentMessages(List<FrostMessageObject> msgObjects) {
        int deleted = 0;
        try {
            deleted = MessageStorage.inst().deleteSentMessages(msgObjects);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error deleting sent messages", t);
        }
        return deleted;
    }
}

