/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.MainFrame;
import frost.boards.Board;
import frost.gui.messagetreetable.MessageTreeTableSortStateBean;
import frost.gui.model.TableMember;
import frost.identities.Identity;
import frost.messages.AbstractMessageObject;
import frost.messages.AttachmentList;
import frost.messages.MessageXmlFile;
import frost.storage.perst.messages.MessageStorage;
import frost.storage.perst.messages.PerstFrostMessageObject;
import frost.util.DateFun;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.TimeOfDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrostMessageObject
extends AbstractMessageObject
implements TableMember {
    private transient PerstFrostMessageObject perstFrostMessageObject = null;
    private static final transient ArrayList<String> EMPTY_STRINGLIST = new ArrayList(0);
    private boolean isValid = false;
    private String invalidReason = null;
    private int index = -1;
    private Board board = null;
    private DateTime dateAndTime = null;
    private boolean isDeleted = false;
    private boolean isNew = false;
    private boolean isReplied = false;
    private boolean isJunk = false;
    private boolean isFlagged = false;
    private boolean isStarred = false;
    private boolean hasFileAttachments = false;
    private boolean hasBoardAttachments = false;
    private ArrayList<String> inReplyToList = null;
    private String dateAndTimeString = null;
    private boolean isDummy = false;
    public static boolean sortThreadRootMsgsAscending;

    public FrostMessageObject() {
    }

    public FrostMessageObject(boolean isRootnode) {
        this.setDummy(true);
        this.setDateAndTime(new DateTime(0L, DateTimeZone.UTC));
        this.setSubject("(root)");
        this.setNew(false);
        this.setFromName("");
    }

    public FrostMessageObject(MessageXmlFile mof, Identity sender, Board b, int msgIndex) {
        this.setValid(true);
        this.setFromName(mof.getFromName());
        this.setBoard(b);
        this.setIndex(msgIndex);
        try {
            this.setDateAndTime(mof.getDateAndTime());
        }
        catch (Throwable t) {
            this.setDateAndTime(new DateTime(0L, DateTimeZone.UTC));
        }
        this.setAttachmentList(mof.getAttachmentList());
        this.setContent(mof.getContent());
        this.setInReplyTo(mof.getInReplyTo());
        this.setMessageId(mof.getMessageId());
        this.setPublicKey(mof.getPublicKey());
        this.setRecipientName(mof.getRecipientName());
        this.setSignatureV1(mof.getSignatureV1());
        this.setSignatureV2(mof.getSignatureV2());
        this.setSignatureStatus(mof.getSignatureStatus());
        this.setSubject(mof.getSubject());
        this.setIdLinePos(mof.getIdLinePos());
        this.setIdLineLen(mof.getIdLineLen());
        this.setFromIdentity(sender);
        this.setHasBoardAttachments(mof.getAttachmentsOfType(1).size() > 0);
        this.setHasFileAttachments(mof.getAttachmentsOfType(0).size() > 0);
    }

    public FrostMessageObject(Board b, DateTime dt, int msgIndex, String reason) {
        this.setValid(false);
        this.setInvalidReason(reason);
        this.setBoard(b);
        this.setDateAndTime(dt);
        this.setIndex(msgIndex);
    }

    public FrostMessageObject(String msgId, Board b, ArrayList<String> ll) {
        this.setMessageId(msgId);
        this.setBoard(b);
        this.setDummyInReplyToList(ll);
        this.setDummy(true);
        this.setDateAndTime(new DateTime(0L, DateTimeZone.UTC));
        this.setSubject("");
        this.setNew(false);
        this.setFromName("");
    }

    public void fillFromOtherMessage(FrostMessageObject mof) {
        this.setDummy(false);
        this.setNew(mof.isNew());
        this.setValid(mof.isValid());
        this.setBoard(mof.getBoard());
        this.setIndex(mof.getIndex());
        this.setDateAndTime(mof.getDateAndTime());
        this.setAttachmentList(mof.getAttachmentList());
        this.setContent(mof.getContent());
        this.setFromName(mof.getFromName());
        this.setInReplyTo(mof.getInReplyTo());
        this.setMessageId(mof.getMessageId());
        this.setPublicKey(mof.getPublicKey());
        this.setRecipientName(mof.getRecipientName());
        this.setSignatureV1(mof.getSignatureV1());
        this.setSignatureV2(mof.getSignatureV2());
        this.setSignatureStatus(mof.getSignatureStatus());
        this.setSubject(mof.getSubject());
        this.setIdLinePos(mof.getIdLinePos());
        this.setIdLineLen(mof.getIdLineLen());
        this.setHasBoardAttachments(mof.getAttachmentsOfType(1).size() > 0);
        this.setHasFileAttachments(mof.getAttachmentsOfType(0).size() > 0);
    }

    public boolean[] hasUnreadOrMarkedChilds() {
        boolean[] result = new boolean[2];
        result[1] = false;
        result[0] = false;
        if (this.getChildCount() == 0) {
            return result;
        }
        Enumeration<TreeNode> e = this.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            FrostMessageObject m = (FrostMessageObject)e.nextElement();
            if (m.isNew()) {
                result[0] = true;
                if (result[1]) {
                    return result;
                }
            }
            if (!m.isStarred() && !m.isFlagged()) continue;
            result[1] = true;
            if (!result[0]) continue;
            return result;
        }
        return result;
    }

    public FrostMessageObject getThreadRootMessage() {
        if (((FrostMessageObject)this.getParent()).isRoot()) {
            return this;
        }
        return ((FrostMessageObject)this.getParent()).getThreadRootMessage();
    }

    @Override
    public String getPublicKey() {
        if (super.getPublicKey() == null) {
            MessageStorage.inst().retrievePublicKey(this);
        }
        return super.getPublicKey();
    }

    @Override
    public String getContent() {
        if (this.content == null) {
            MessageStorage.inst().retrieveMessageContent(this);
            if (this.content == null) {
                this.content = "";
            }
        }
        return this.content;
    }

    @Override
    public AttachmentList getAttachmentsOfType(int type) {
        if (!this.containsAttachments()) {
            if (this.attachments == null) {
                this.attachments = new AttachmentList();
            }
            return this.attachments.getAllOfType(type);
        }
        if (this.attachments == null) {
            MessageStorage.inst().retrieveAttachments(this);
            if (this.attachments == null) {
                this.attachments = new AttachmentList();
            }
        }
        return this.attachments.getAllOfType(type);
    }

    @Override
    public int compareTo(TableMember another, int tableColumnIndex) {
        int result;
        String c1 = (String)this.getValueAt(tableColumnIndex);
        String c2 = (String)another.getValueAt(tableColumnIndex);
        if (tableColumnIndex == 4) {
            return c1.compareTo(c2);
        }
        if (tableColumnIndex == 2) {
            if (c1.indexOf("Re: ") == 0) {
                c1 = c1.substring(4);
            }
            if (c2.indexOf("Re: ") == 0) {
                c2 = c2.substring(4);
            }
        }
        if ((result = c1.compareToIgnoreCase(c2)) == 0) {
            String d1 = (String)this.getValueAt(4);
            String d2 = (String)another.getValueAt(4);
            return d1.compareTo(d2);
        }
        return result;
    }

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return Integer.toString(this.getIndex());
            }
            case 1: {
                return this.getFromName();
            }
            case 2: {
                return this.getSubject();
            }
            case 3: {
                return this.getMessageStatusString();
            }
            case 4: {
                return this.getDateAndTimeString();
            }
        }
        return "*ERR*";
    }

    public String getDateAndTimeString() {
        if (this.dateAndTimeString == null) {
            DateTime dateTime = new DateTime((Object)this.getDateAndTime(), DateTimeZone.UTC);
            DateMidnight date = dateTime.toDateMidnight();
            TimeOfDay time = dateTime.toTimeOfDay();
            String dateStr = DateFun.FORMAT_DATE_EXT.print(date);
            String timeStr = DateFun.FORMAT_TIME_EXT.print(time);
            StringBuilder sb = new StringBuilder(29);
            sb.append(dateStr).append(" ").append(timeStr);
            this.dateAndTimeString = sb.toString();
        }
        return this.dateAndTimeString;
    }

    public Board getBoard() {
        return this.board;
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public boolean hasBoardAttachments() {
        return this.hasBoardAttachments;
    }

    public void setHasBoardAttachments(boolean hasBoardAttachments) {
        this.hasBoardAttachments = hasBoardAttachments;
    }

    public boolean hasFileAttachments() {
        return this.hasFileAttachments;
    }

    public void setHasFileAttachments(boolean hasFileAttachments) {
        this.hasFileAttachments = hasFileAttachments;
    }

    @Override
    public boolean containsAttachments() {
        return this.hasFileAttachments() || this.hasBoardAttachments();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getInvalidReason() {
        return this.invalidReason;
    }

    public void setInvalidReason(String invalidReason) {
        this.invalidReason = invalidReason;
    }

    public boolean isReplied() {
        return this.isReplied;
    }

    public void setReplied(boolean isReplied) {
        this.isReplied = isReplied;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean isJunk() {
        return this.isJunk;
    }

    public void setJunk(boolean isJunk) {
        this.isJunk = isJunk;
    }

    public boolean isFlagged() {
        return this.isFlagged;
    }

    public void setFlagged(boolean isFlagged) {
        this.isFlagged = isFlagged;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isStarred() {
        return this.isStarred;
    }

    public void setStarred(boolean isStarred) {
        this.isStarred = isStarred;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setDateAndTime(DateTime dt) {
        this.dateAndTime = dt;
    }

    public DateTime getDateAndTime() {
        return this.dateAndTime;
    }

    public void setDummy(boolean v) {
        this.isDummy = v;
    }

    public boolean isDummy() {
        return this.isDummy;
    }

    private void setDummyInReplyToList(ArrayList<String> l) {
        this.inReplyToList = l;
    }

    public ArrayList<String> getInReplyToList() {
        if (this.inReplyToList == null) {
            if (this.getInReplyTo() == null) {
                this.inReplyToList = EMPTY_STRINGLIST;
            } else {
                this.inReplyToList = new ArrayList();
                String s = this.getInReplyTo();
                StringTokenizer st = new StringTokenizer(s, ",");
                while (st.hasMoreTokens()) {
                    String r = st.nextToken().trim();
                    if (r.length() <= 0) continue;
                    this.inReplyToList.add(r);
                }
            }
        }
        return this.inReplyToList;
    }

    public void resortChildren() {
        if (this.children == null || this.children.size() <= 1) {
            return;
        }
        Comparator<FrostMessageObject> comparator = MessageTreeTableSortStateBean.getComparator(MessageTreeTableSortStateBean.getSortedColumn(), MessageTreeTableSortStateBean.isAscending());
        if (comparator != null) {
            Collections.sort(this.children, comparator);
        }
    }

    @Override
    public void add(MutableTreeNode n) {
        this.add(n, true);
    }

    public void add(MutableTreeNode nn, boolean silent) {
        int[] ixs;
        FrostMessageObject n = (FrostMessageObject)nn;
        if (this.children == null) {
            super.add(n);
            ixs = new int[]{0};
        } else {
            Comparator<FrostMessageObject> comparator;
            int insertPoint = MessageTreeTableSortStateBean.isThreaded() ? (this.isRoot() ? (sortThreadRootMsgsAscending ? Collections.binarySearch(this.children, n, MessageTreeTableSortStateBean.dateComparatorAscending) : Collections.binarySearch(this.children, n, MessageTreeTableSortStateBean.dateComparatorDescending)) : Collections.binarySearch(this.children, n, MessageTreeTableSortStateBean.dateComparatorAscending)) : ((comparator = MessageTreeTableSortStateBean.getComparator(MessageTreeTableSortStateBean.getSortedColumn(), MessageTreeTableSortStateBean.isAscending())) != null ? Collections.binarySearch(this.children, n, comparator) : 0);
            if (insertPoint < 0) {
                ++insertPoint;
                insertPoint *= -1;
            }
            if (insertPoint >= this.children.size()) {
                super.add(n);
                ixs = new int[]{this.children.size() - 1};
            } else {
                super.insert(n, insertPoint);
                ixs = new int[]{insertPoint};
            }
        }
        if (!silent) {
            if (MainFrame.getInstance().getMessageTreeTable().getTree().isExpanded(new TreePath(this.getPath()))) {
                MainFrame.getInstance().getMessageTreeModel().nodesWereInserted(this, ixs);
                if (n.getChildCount() > 0) {
                    MainFrame.getInstance().getMessageTreeTable().expandNode(n);
                }
            } else {
                MainFrame.getInstance().getMessageTreeTable().expandNode(this);
            }
        }
    }

    @Override
    public String toString() {
        return this.getSubject();
    }

    public PerstFrostMessageObject getPerstFrostMessageObject() {
        return this.perstFrostMessageObject;
    }

    public void setPerstFrostMessageObject(PerstFrostMessageObject perstFrostMessageObject) {
        this.perstFrostMessageObject = perstFrostMessageObject;
    }
}

