/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.PersonAttachment;
import frost.util.XMLizable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class Attachment
implements XMLizable,
Comparable {
    public static final int FILE = 0;
    public static final int BOARD = 1;
    public static final int PERSON = 2;
    private static final Logger logger = Logger.getLogger(Attachment.class.getName());

    public abstract int getType();

    public static Attachment getInstance(Element e) {
        assert (e.getAttribute("type").length() > 0) : "attachment type not specified!";
        try {
            if (e.getAttribute("type").equals("file")) {
                return new FileAttachment(e);
            }
            if (e.getAttribute("type").equals("board")) {
                return new BoardAttachment(e);
            }
            return new PersonAttachment(e);
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, "Exception thrown in getInstance(Element e)", ex);
            return null;
        }
    }
}

