/*
 * Decompiled with CFR 0.152.
 */
package frost.identities;

import frost.Core;
import frost.identities.Identity;
import frost.util.XMLTools;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LocalIdentity
extends Identity {
    private String privateKey;
    private String signature;
    private long lastFilesSharedMillis = 0L;

    public LocalIdentity() {
    }

    public Element getXMLElement(Document doc) {
        return super.getXMLElement(doc);
    }

    public Element getExportXMLElement(Document doc) {
        Element el = super.getXMLElement(doc);
        Element el2 = doc.createElement("MyIdentity");
        NodeList list = el.getChildNodes();
        while (list.getLength() > 0) {
            el2.appendChild(list.item(0));
        }
        Element element = doc.createElement("privKey");
        CDATASection cdata = doc.createCDATASection(this.getPrivateKey());
        element.appendChild(cdata);
        el2.appendChild(element);
        if (this.getSignature() != null) {
            element = doc.createElement("signature");
            cdata = doc.createCDATASection(this.getSignature());
            element.appendChild(cdata);
            el2.appendChild(element);
        }
        return el2;
    }

    public void loadXMLElement(Element el) throws SAXException {
        super.loadXMLElement(el);
        this.privateKey = XMLTools.getChildElementsCDATAValue(el, "privKey");
        this.signature = XMLTools.getChildElementsCDATAValue(el, "signature");
    }

    protected LocalIdentity(String name, String key) {
        super(name, key, true);
    }

    protected LocalIdentity(String name, String[] keys) {
        this(name, keys[1]);
        this.privateKey = keys[0];
    }

    public LocalIdentity(String uname, String pubKey, String prvKey, String sign) {
        this(uname, pubKey);
        this.privateKey = prvKey;
        this.signature = sign;
    }

    protected LocalIdentity(Element el) throws Exception {
        super(el);
    }

    public static LocalIdentity createLocalIdentityFromXmlElement(Element el) {
        try {
            return new LocalIdentity(el);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LocalIdentity(String name) {
        this(name, Core.getCrypto().generateKeys());
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String s) {
        this.signature = s;
        this.updateIdentitiesStorage();
    }

    public boolean isGOOD() {
        return true;
    }

    public boolean isCHECK() {
        return false;
    }

    public boolean isOBSERVE() {
        return false;
    }

    public boolean isBAD() {
        return false;
    }

    public long getLastFilesSharedMillis() {
        return this.lastFilesSharedMillis;
    }

    public void setLastFilesSharedMillis(long l) {
        this.lastFilesSharedMillis = l;
        this.modify();
    }
}

