/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.unsentmessages;

import frost.Core;
import frost.MainFrame;
import frost.gui.MessageWindow;
import frost.gui.unsentmessages.UnsentMessagesTableFormat;
import frost.gui.unsentmessages.UnsentMessagesTableItem;
import frost.gui.unsentmessages.UnsentMessagesTableModel;
import frost.messages.FrostMessageObject;
import frost.messages.FrostUnsentMessageObject;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.SortedModelTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class UnsentMessagesTable
extends SortedModelTable {
    private UnsentMessagesTableModel tableModel;
    private UnsentMessagesTableFormat tableFormat;
    private PopupMenu popupMenu = null;
    private Language language = Language.getInstance();

    public UnsentMessagesTable() {
        this(new UnsentMessagesTableModel(new UnsentMessagesTableFormat()));
    }

    private UnsentMessagesTable(UnsentMessagesTableModel m) {
        super(m);
        this.tableModel = m;
        this.tableFormat = (UnsentMessagesTableFormat)m.getTableFormat();
        this.setupTableFont();
        this.getTable().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Listener l = new Listener();
        this.getTable().addMouseListener(l);
        this.getScrollPane().addMouseListener(l);
    }

    public void addUnsentMessage(FrostUnsentMessageObject i) {
        this.tableModel.addFrostUnsentMessageObject(i);
        MainFrame.getInstance().getUnsentMessagesPanel().updateUnsentMessagesCount();
    }

    public void removeUnsentMessage(FrostUnsentMessageObject i) {
        this.tableModel.removeFrostUnsentMessageObject(i);
        MainFrame.getInstance().getUnsentMessagesPanel().updateUnsentMessagesCount();
    }

    public void updateUnsentMessage(FrostUnsentMessageObject i) {
        this.tableModel.updateFrostUnsentMessageObject(i);
    }

    public void saveTableFormat() {
        this.tableFormat.saveTableLayout();
    }

    public void loadTableModel() {
        this.tableModel.loadTableModel();
        MainFrame.getInstance().getUnsentMessagesPanel().updateUnsentMessagesCount();
    }

    public void clearTableModel() {
        this.tableModel.clear();
    }

    private PopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new PopupMenu();
            this.language.addLanguageListener(this.popupMenu);
        }
        return this.popupMenu;
    }

    private void setupTableFont() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("fileListFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("fileListFontStyle"), fontSize = Core.frostSettings.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            Core.frostSettings.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", fontStyle, fontSize);
        }
        this.getTable().setFont(font);
    }

    private void tableDoubleClick(MouseEvent e) {
        ModelItem item;
        int row = this.getTable().rowAtPoint(e.getPoint());
        if (row > -1 && (item = this.getItemAt(row)) != null) {
            FrostUnsentMessageObject sm = ((UnsentMessagesTableItem)item).getFrostUnsentMessageObject();
            MessageWindow messageWindow = new MessageWindow((Window)MainFrame.getInstance(), (FrostMessageObject)sm, MainFrame.getInstance().getUnsentMessagesPanel().getSize(), false);
            messageWindow.setVisible(true);
        }
    }

    private class PopupMenu
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        JMenuItem deleteItem = new JMenuItem();

        public PopupMenu() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.deleteItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.deleteItem.setText(UnsentMessagesTable.this.language.getString("UnsentMessages.table.popup.deleteMessage"));
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.deleteItem) {
                this.deleteSelectedMessages();
            }
        }

        private void deleteSelectedMessages() {
            ModelItem[] selectedItems = UnsentMessagesTable.this.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            int answer = selectedItems.length == 1 ? JOptionPane.showConfirmDialog(MainFrame.getInstance(), UnsentMessagesTable.this.language.getString("UnsentMessages.confirmDeleteOneMessageDialog.text"), UnsentMessagesTable.this.language.getString("UnsentMessages.confirmDeleteOneMessageDialog.title"), 0, 3) : JOptionPane.showConfirmDialog(MainFrame.getInstance(), UnsentMessagesTable.this.language.formatMessage("UnsentMessages.confirmDeleteMessagesDialog.text", Integer.toString(selectedItems.length)), UnsentMessagesTable.this.language.getString("UnsentMessages.confirmDeleteMessagesDialog.title"), 0, 3);
            if (answer != 0) {
                return;
            }
            FrostUnsentMessageObject failedItem = UnsentMessagesTable.this.tableModel.deleteItems(selectedItems);
            if (failedItem != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), UnsentMessagesTable.this.language.getString("UnsentMessages.deleteNotPossibleDialog.text"), UnsentMessagesTable.this.language.getString("UnsentMessages.deleteNotPossibleDialog.title"), 0);
            }
            MainFrame.getInstance().getUnsentMessagesPanel().updateUnsentMessagesCount();
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        public void show(Component invoker, int x, int y) {
            UnsentMessagesTableItem item;
            this.removeAll();
            ModelItem[] selectedItems = UnsentMessagesTable.this.getSelectedItems();
            if (selectedItems.length == 0) {
                return;
            }
            this.deleteItem.setEnabled(true);
            this.add(this.deleteItem);
            if (selectedItems.length == 1 && (item = (UnsentMessagesTableItem)selectedItems[0]).getFrostUnsentMessageObject().getCurrentUploadThread() != null) {
                this.deleteItem.setEnabled(false);
            }
            super.show(invoker, x, y);
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseListener {
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getSource() == UnsentMessagesTable.this.getTable()) {
                    UnsentMessagesTable.this.tableDoubleClick(e);
                }
            } else if (e.isPopupTrigger() && (e.getSource() == UnsentMessagesTable.this.getTable() || e.getSource() == UnsentMessagesTable.this.getScrollPane())) {
                this.showTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == UnsentMessagesTable.this.getTable() || e.getSource() == UnsentMessagesTable.this.getScrollPane())) {
                this.showTablePopupMenu(e);
            }
        }

        private void showTablePopupMenu(MouseEvent e) {
            Point p = e.getPoint();
            int y = UnsentMessagesTable.this.getTable().rowAtPoint(p);
            if (y < 0) {
                return;
            }
            if (!UnsentMessagesTable.this.getTable().getSelectionModel().isSelectedIndex(y)) {
                UnsentMessagesTable.this.getTable().getSelectionModel().setSelectionInterval(y, y);
            }
            UnsentMessagesTable.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

