/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class JunkPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private final JCheckBox hideJunkMessagesCheckBox = new JCheckBox();
    private final JCheckBox markJunkIdentityBadCheckBox = new JCheckBox();
    private final JCheckBox stopBoardUpdatesWhenDosedCheckBox = new JCheckBox();
    private final JLabel LinvalidSubsequentMessagesThreshold = new JLabel();
    private final JTextField TfInvalidSubsequentMessagesThreshold = new JTextField(8);
    private final Listener listener = new Listener();

    protected JunkPanel(SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    private void initialize() {
        Insets insets5555;
        this.setName("JunkPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = insets5555 = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.insets = insets5555;
        constraints.gridx = 0;
        this.add((Component)this.hideJunkMessagesCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.markJunkIdentityBadCheckBox, constraints);
        ++constraints.gridy;
        constraints.fill = 2;
        JSeparator separator = new JSeparator(0);
        this.add((Component)separator, constraints);
        constraints.fill = 0;
        ++constraints.gridy;
        this.add((Component)this.stopBoardUpdatesWhenDosedCheckBox, constraints);
        ++constraints.gridy;
        JPanel subPanel = new JPanel(new GridBagLayout());
        GridBagConstraints subConstraints = new GridBagConstraints();
        subConstraints.insets = new Insets(0, 10, 0, 10);
        subConstraints.anchor = 17;
        subConstraints.gridx = 0;
        subPanel.add((Component)this.LinvalidSubsequentMessagesThreshold, subConstraints);
        subConstraints.gridx = 1;
        subPanel.add((Component)this.TfInvalidSubsequentMessagesThreshold, subConstraints);
        this.add((Component)subPanel, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(""), constraints);
        this.stopBoardUpdatesWhenDosedCheckBox.addActionListener(this.listener);
    }

    private void refreshStopOnDosState() {
        boolean stopOnDos = this.stopBoardUpdatesWhenDosedCheckBox.isSelected();
        this.LinvalidSubsequentMessagesThreshold.setEnabled(stopOnDos);
        this.TfInvalidSubsequentMessagesThreshold.setEnabled(stopOnDos);
    }

    private void loadSettings() {
        this.hideJunkMessagesCheckBox.setSelected(this.settings.getBoolValue("junk.hideJunkMessages"));
        this.markJunkIdentityBadCheckBox.setSelected(this.settings.getBoolValue("junk.markJunkIdentityBad"));
        this.stopBoardUpdatesWhenDosedCheckBox.setSelected(this.settings.getBoolValue("dos.stopBoardUpdatesWhenDosed"));
        this.TfInvalidSubsequentMessagesThreshold.setText("" + this.settings.getIntValue("dos.invalidSubsequentMessagesThreshold"));
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.hideJunkMessagesCheckBox.setText(this.language.getString("Options.junk.hideJunkMessages"));
        this.markJunkIdentityBadCheckBox.setText(this.language.getString("Options.junk.markJunkIdentityBad"));
        this.stopBoardUpdatesWhenDosedCheckBox.setText(this.language.getString("Options.junk.stopBoardUpdatesWhenDosed"));
        this.LinvalidSubsequentMessagesThreshold.setText(this.language.getString("Options.junk.invalidSubsequentMessagesThreshold"));
    }

    private void saveSettings() {
        this.settings.setValue("junk.hideJunkMessages", this.hideJunkMessagesCheckBox.isSelected());
        this.settings.setValue("junk.markJunkIdentityBad", this.markJunkIdentityBadCheckBox.isSelected());
        this.settings.setValue("dos.stopBoardUpdatesWhenDosed", this.stopBoardUpdatesWhenDosedCheckBox.isSelected());
        this.settings.setValue("dos.invalidSubsequentMessagesThreshold", this.TfInvalidSubsequentMessagesThreshold.getText());
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == JunkPanel.this.stopBoardUpdatesWhenDosedCheckBox) {
                JunkPanel.this.refreshStopOnDosState();
            }
        }
    }
}

