/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

class ExpirationPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private final JLabel LcleanupIntervalDays = new JLabel();
    private final JTextField TfCleanupIntervalDays = new JTextField(8);
    private final JCheckBox CbCleanupNextStartup = new JCheckBox();
    private final JRadioButton RbKeepExpiredMessages = new JRadioButton();
    private final JRadioButton RbArchiveExpiredMessages = new JRadioButton();
    private final JRadioButton RbDeleteExpiredMessages = new JRadioButton();
    private final ButtonGroup BgExpiredMessages = new ButtonGroup();
    private final JLabel LmessageExpireDays = new JLabel();
    private final JTextField TfMessageExpireDays = new JTextField(8);
    private final JCheckBox CbKeepFlaggedAndStarred = new JCheckBox();
    private final JCheckBox CbKeepUnread = new JCheckBox();
    private final JCheckBox CbRemoveOfflineFilesWithKey = new JCheckBox();
    private final JLabel LofflineFilesMaxDaysOld = new JLabel();
    private final JTextField TfOfflineFilesMaxDaysOld = new JTextField(8);

    protected ExpirationPanel(JDialog owner, SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    private void initialize() {
        Insets insets0555;
        this.setName("ExpirationPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.TfMessageExpireDays, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = insets0555 = new Insets(0, 5, 5, 5);
        constraints.gridy = 0;
        JPanel subPanel = new JPanel(new GridBagLayout());
        GridBagConstraints subConstraints = new GridBagConstraints();
        subConstraints.insets = new Insets(0, 0, 0, 10);
        subConstraints.gridx = 0;
        subPanel.add((Component)this.LcleanupIntervalDays, subConstraints);
        subConstraints.gridx = 1;
        subPanel.add((Component)this.TfCleanupIntervalDays, subConstraints);
        this.add((Component)subPanel, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.CbCleanupNextStartup, constraints);
        ++constraints.gridy;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        JSeparator separator = new JSeparator(0);
        this.add((Component)separator, constraints);
        ++constraints.gridy;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        subPanel = new JPanel(new GridBagLayout());
        subConstraints = new GridBagConstraints();
        subConstraints.insets = new Insets(0, 0, 0, 10);
        subConstraints.gridx = 0;
        subPanel.add((Component)this.LmessageExpireDays, subConstraints);
        subConstraints.gridx = 1;
        subPanel.add((Component)this.TfMessageExpireDays, subConstraints);
        this.add((Component)subPanel, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.RbKeepExpiredMessages, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.RbArchiveExpiredMessages, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.RbDeleteExpiredMessages, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.CbKeepUnread, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.CbKeepFlaggedAndStarred, constraints);
        ++constraints.gridy;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        separator = new JSeparator(0);
        this.add((Component)separator, constraints);
        ++constraints.gridy;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        subPanel = new JPanel(new GridBagLayout());
        subConstraints = new GridBagConstraints();
        subConstraints.insets = new Insets(0, 0, 0, 10);
        subConstraints.gridx = 0;
        subPanel.add((Component)this.LofflineFilesMaxDaysOld, subConstraints);
        subConstraints.gridx = 1;
        subPanel.add((Component)this.TfOfflineFilesMaxDaysOld, subConstraints);
        this.add((Component)subPanel, constraints);
        ++constraints.gridy;
        this.add((Component)this.CbRemoveOfflineFilesWithKey, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(""), constraints);
        this.BgExpiredMessages.add(this.RbKeepExpiredMessages);
        this.BgExpiredMessages.add(this.RbArchiveExpiredMessages);
        this.BgExpiredMessages.add(this.RbDeleteExpiredMessages);
    }

    private void loadSettings() {
        this.TfMessageExpireDays.setText(this.settings.getValue("messageExpireDays"));
        String mode = this.settings.getValue("messageExpirationMode");
        if (mode.toUpperCase().equals("KEEP")) {
            this.RbKeepExpiredMessages.doClick();
        } else if (mode.toUpperCase().equals("ARCHIVE")) {
            this.RbArchiveExpiredMessages.doClick();
        } else if (mode.toUpperCase().equals("DELETE")) {
            this.RbDeleteExpiredMessages.doClick();
        } else {
            this.RbKeepExpiredMessages.doClick();
        }
        this.CbKeepFlaggedAndStarred.setSelected(this.settings.getBoolValue("archiveKeepFlaggedOrStarredMessages"));
        this.CbKeepUnread.setSelected(this.settings.getBoolValue("archiveKeepUnreadMessages"));
        this.CbRemoveOfflineFilesWithKey.setSelected(this.settings.getBoolValue("database.cleanup.removeOfflineFilesWithKey"));
        this.TfOfflineFilesMaxDaysOld.setText(this.settings.getValue("database.cleanup.offlineFilesMaxDaysOld"));
        this.TfCleanupIntervalDays.setText(this.settings.getValue("database.cleanup.interval"));
        if (this.settings.getLongValue("database.cleanup.lastRun") == 0L) {
            this.CbCleanupNextStartup.setSelected(true);
        } else {
            this.CbCleanupNextStartup.setSelected(false);
        }
    }

    private void saveSettings() {
        this.settings.setValue("messageExpireDays", this.TfMessageExpireDays.getText());
        if (this.RbKeepExpiredMessages.isSelected()) {
            this.settings.setValue("messageExpirationMode", "KEEP");
        } else if (this.RbArchiveExpiredMessages.isSelected()) {
            this.settings.setValue("messageExpirationMode", "ARCHIVE");
        } else if (this.RbDeleteExpiredMessages.isSelected()) {
            this.settings.setValue("messageExpirationMode", "DELETE");
        } else {
            this.settings.setValue("messageExpirationMode", "KEEP");
        }
        this.settings.setValue("archiveKeepFlaggedOrStarredMessages", this.CbKeepFlaggedAndStarred.isSelected());
        this.settings.setValue("archiveKeepUnreadMessages", this.CbKeepUnread.isSelected());
        this.settings.setValue("database.cleanup.removeOfflineFilesWithKey", this.CbRemoveOfflineFilesWithKey.isSelected());
        this.settings.setValue("database.cleanup.offlineFilesMaxDaysOld", this.TfOfflineFilesMaxDaysOld.getText());
        this.settings.setValue("database.cleanup.interval", this.TfCleanupIntervalDays.getText());
        if (this.CbCleanupNextStartup.isSelected()) {
            this.settings.setValue("database.cleanup.lastRun", 0L);
        }
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.RbKeepExpiredMessages.setText(this.language.getString("Options.expiration.keepExpiredMessages"));
        this.RbArchiveExpiredMessages.setText(this.language.getString("Options.expiration.archiveExpiredMessages"));
        this.RbDeleteExpiredMessages.setText(this.language.getString("Options.expiration.deleteExpiredMessages"));
        this.LmessageExpireDays.setText(this.language.getString("Options.expiration.numberOfDaysBeforeMessageExpires") + " (90)");
        this.CbKeepFlaggedAndStarred.setText(this.language.getString("Options.expiration.keepFlaggedAndStarredMessages"));
        this.CbKeepUnread.setText(this.language.getString("Options.expiration.keepUnreadMessages"));
        this.CbRemoveOfflineFilesWithKey.setText(this.language.getString("Options.expiration.removeOfflineFilesWithKey"));
        this.LofflineFilesMaxDaysOld.setText(this.language.getString("Options.expiration.offlineFilesMaxDaysOld") + " (30)");
        this.LcleanupIntervalDays.setText(this.language.getString("Options.expiration.cleanupIntervalDays") + " (5 " + this.language.getString("Options.common.days") + ")");
        this.CbCleanupNextStartup.setText(this.language.getString("Options.expiration.cleanupNextStartup"));
    }
}

