/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.messagetreetable;

import frost.Core;
import frost.SettingsClass;
import frost.fcp.FcpHandler;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.gui.messagetreetable.MessageTreeTableHeader;
import frost.gui.messagetreetable.MessageTreeTableSortStateBean;
import frost.gui.messagetreetable.TreeTableModel;
import frost.gui.messagetreetable.TreeTableModelAdapter;
import frost.identities.Identity;
import frost.messages.FrostMessageObject;
import frost.util.DateFun;
import frost.util.gui.IconTableHeaderRenderer;
import frost.util.gui.MiscToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MessageTreeTable
extends JTable
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MessageTreeTable.class.getName());
    protected TreeTableCellRenderer tree;
    protected Border borderUnreadAndMarkedMsgsInThread = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.blue), BorderFactory.createMatteBorder(0, 2, 0, 0, Color.green));
    protected Border borderMarkedMsgsInThread = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0), BorderFactory.createMatteBorder(0, 2, 0, 0, Color.green));
    protected Border borderUnreadMsgsInThread = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.blue), BorderFactory.createEmptyBorder(0, 2, 0, 0));
    protected Border borderEmpty = BorderFactory.createEmptyBorder(0, 4, 0, 0);
    private final StringCellRenderer stringCellRenderer = new StringCellRenderer();
    private final BooleanCellRenderer booleanCellRenderer = new BooleanCellRenderer();
    private final ImageIcon flaggedIcon = MiscToolkit.loadImageIcon("/data/flagged.gif");
    private final ImageIcon starredIcon = MiscToolkit.loadImageIcon("/data/starred.gif");
    private final ImageIcon junkIcon = MiscToolkit.loadImageIcon("/data/junk.gif");
    private final ImageIcon messageDummyIcon = MiscToolkit.loadImageIcon("/data/messagedummyicon.gif");
    private final ImageIcon messageNewIcon = MiscToolkit.loadImageIcon("/data/messagenewicon.gif");
    private final ImageIcon messageReadIcon = MiscToolkit.loadImageIcon("/data/messagereadicon.gif");
    private final ImageIcon messageNewRepliedIcon = MiscToolkit.loadImageIcon("/data/messagenewrepliedicon.gif");
    private final ImageIcon messageReadRepliedIcon = MiscToolkit.loadImageIcon("/data/messagereadrepliedicon.gif");
    public final ImageIcon receivedOneMessage = MiscToolkit.loadImageIcon("/data/bullet_red.png");
    public final ImageIcon receivedFiveMessages = MiscToolkit.loadImageIcon("/data/bullet_blue.png");
    private boolean showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
    private boolean indicateLowReceivedMessages = Core.frostSettings.getBoolValue("MessagePanel.indicateLowReceivedMessages");
    private int indicateLowReceivedMessagesCountRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.redCount");
    private int indicateLowReceivedMessagesCountLightRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.lightRedCount");
    private final int MINIMUM_ROW_HEIGHT = 20;
    private final int ROW_HEIGHT_MARGIN = 4;

    public MessageTreeTable(TreeTableModel treeTableModel) {
        Core.frostSettings.addPropertyChangeListener("showColoredRows", this);
        Core.frostSettings.addPropertyChangeListener("messageListFontName", this);
        Core.frostSettings.addPropertyChangeListener("messageListFontSize", this);
        Core.frostSettings.addPropertyChangeListener("messageListFontStyle", this);
        Core.frostSettings.addPropertyChangeListener("MessagePanel.indicateLowReceivedMessages", this);
        Core.frostSettings.addPropertyChangeListener("MessagePanel.indicateLowReceivedMessages.redCount", this);
        Core.frostSettings.addPropertyChangeListener("MessagePanel.indicateLowReceivedMessages.lightRedCount", this);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree, this));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setDefaultRenderer(String.class, this.stringCellRenderer);
        this.setDefaultRenderer(Boolean.class, this.booleanCellRenderer);
        MessageTreeTableHeader hdr = new MessageTreeTableHeader(this);
        this.setTableHeader(hdr);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        int fontSize = Core.frostSettings.getIntValue("messageListFontSize");
        this.setRowHeight(Math.max(fontSize + 4, 20));
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (!pressed) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        if (e.getKeyCode() == 37) {
            this.getTree().processKeyEvent(e);
        } else if (e.getKeyCode() == 39) {
            this.getTree().processKeyEvent(e);
        } else {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    public FrostMessageObject getRootNode() {
        return (FrostMessageObject)((DefaultTreeModel)this.tree.getModel()).getRoot();
    }

    public void setNewRootNode(TreeNode t) {
        ((DefaultTreeModel)this.tree.getModel()).setRoot(t);
    }

    public void expandAll(final boolean expand) {
        final TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        if (SwingUtilities.isEventDispatchThread()) {
            this.expandAll(new TreePath(root), expand);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageTreeTable.this.expandAll(new TreePath(root), expand);
                }
            });
        }
    }

    public void expandThread(final boolean expand, FrostMessageObject msg) {
        if (msg == null) {
            return;
        }
        final FrostMessageObject threadRootMsg = msg.getThreadRootMessage();
        if (threadRootMsg == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.expandAll(new TreePath(threadRootMsg.getPath()), expand);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageTreeTable.this.expandAll(new TreePath(threadRootMsg.getPath()), expand);
                }
            });
        }
    }

    private void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (node.getParent() == null) {
            expand = true;
        }
        if (expand) {
            if (!this.tree.isExpanded(parent)) {
                this.tree.expandPath(parent);
            }
        } else if (!this.tree.isCollapsed(parent)) {
            this.tree.collapsePath(parent);
        }
    }

    public void expandNode(final DefaultMutableTreeNode n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.expandAll(new TreePath(n.getPath()), true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageTreeTable.this.expandAll(new TreePath(n.getPath()), true);
                }
            });
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public TreeTableCellRenderer getTree() {
        return this.tree;
    }

    public int getRowForNode(DefaultMutableTreeNode n) {
        if (n.isRoot()) {
            return 0;
        }
        TreePath tp = new TreePath(n.getPath());
        return this.tree.getRowForPath(tp);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        boolean retValue = super.editCellAt(row, column, e);
        if (retValue && this.getColumnClass(column) == TreeTableModel.class) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return retValue;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.stringCellRenderer != null) {
            this.stringCellRenderer.fontChanged(font);
        }
        if (this.tree != null) {
            this.tree.fontChanged(font);
        }
        this.repaint();
    }

    public void saveLayout(SettingsClass frostSettings) {
        TableColumnModel tcm = this.getColumnModel();
        for (int columnIndexInTable = 0; columnIndexInTable < tcm.getColumnCount(); ++columnIndexInTable) {
            TableColumn tc = tcm.getColumn(columnIndexInTable);
            int columnIndexInModel = tc.getModelIndex();
            frostSettings.setValue("MessageTreeTable.tableindex.modelcolumn." + columnIndexInModel, columnIndexInTable);
            int columnWidth = tc.getWidth();
            frostSettings.setValue("MessageTreeTable.columnwidth.modelcolumn." + columnIndexInModel, columnWidth);
        }
    }

    public void loadLayout(SettingsClass frostSettings) {
        TableColumnModel tcm = this.getColumnModel();
        tcm.getColumn(0).setMinWidth(20);
        tcm.getColumn(0).setMaxWidth(20);
        tcm.getColumn(0).setPreferredWidth(20);
        tcm.getColumn(1).setMinWidth(20);
        tcm.getColumn(1).setMaxWidth(20);
        tcm.getColumn(1).setPreferredWidth(20);
        tcm.getColumn(5).setMinWidth(20);
        tcm.getColumn(5).setMaxWidth(20);
        tcm.getColumn(5).setPreferredWidth(20);
        tcm.getColumn(0).setHeaderRenderer(new IconTableHeaderRenderer(this.flaggedIcon, "Flagged"));
        tcm.getColumn(1).setHeaderRenderer(new IconTableHeaderRenderer(this.starredIcon, "Starred"));
        tcm.getColumn(5).setHeaderRenderer(new IconTableHeaderRenderer(this.junkIcon, "Junk"));
        if (!this.loadLayout(frostSettings, tcm)) {
            int[] widths = new int[]{20, 20, 185, 95, 40, 20, 130};
            for (int i = 0; i < widths.length; ++i) {
                tcm.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }

    private boolean loadLayout(SettingsClass frostSettings, TableColumnModel tcm) {
        int[] tableToModelIndex = new int[tcm.getColumnCount()];
        int[] columnWidths = new int[tcm.getColumnCount()];
        for (int x = 0; x < tableToModelIndex.length; ++x) {
            String indexKey = "MessageTreeTable.tableindex.modelcolumn." + x;
            if (frostSettings.getObjectValue(indexKey) == null) {
                return false;
            }
            int tableIndex = frostSettings.getIntValue(indexKey);
            if (tableIndex < 0 || tableIndex >= tableToModelIndex.length) {
                return false;
            }
            tableToModelIndex[tableIndex] = x;
            String widthKey = "MessageTreeTable.columnwidth.modelcolumn." + x;
            if (frostSettings.getObjectValue(widthKey) == null) {
                return false;
            }
            int columnWidth = frostSettings.getIntValue(widthKey);
            if (columnWidth <= 0) {
                return false;
            }
            columnWidths[x] = columnWidth;
        }
        TableColumn[] tcms = new TableColumn[tcm.getColumnCount()];
        for (int x = tcms.length - 1; x >= 0; --x) {
            tcms[x] = tcm.getColumn(x);
            tcm.removeColumn(tcms[x]);
            if (x == 0 || x == 1 || x == 5) continue;
            tcms[x].setPreferredWidth(columnWidths[x]);
        }
        for (int element : tableToModelIndex) {
            tcm.addColumn(tcms[element]);
        }
        return true;
    }

    public void resortTable() {
        if (MessageTreeTableSortStateBean.isThreaded()) {
            return;
        }
        FrostMessageObject root = (FrostMessageObject)this.getTree().getModel().getRoot();
        root.resortChildren();
        ((DefaultTreeModel)this.getTree().getModel()).reload();
    }

    private void fontChanged() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("messageListFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("messageListFontStyle"), fontSize = Core.frostSettings.getIntValue("messageListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            Core.frostSettings.setValue("messageListFontName", "Monospaced");
            font = new Font("Monospaced", fontStyle, fontSize);
        }
        this.setRowHeight(Math.max(fontSize + 4, 20));
        this.setFont(font);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showColoredRows")) {
            this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        } else if (evt.getPropertyName().equals("messageListFontName")) {
            this.fontChanged();
        } else if (evt.getPropertyName().equals("messageListFontSize")) {
            this.fontChanged();
        } else if (evt.getPropertyName().equals("messageListFontStyle")) {
            this.fontChanged();
        } else if (evt.getPropertyName().equals("MessagePanel.indicateLowReceivedMessages")) {
            this.indicateLowReceivedMessages = Core.frostSettings.getBoolValue("MessagePanel.indicateLowReceivedMessages");
        } else if (evt.getPropertyName().equals("MessagePanel.indicateLowReceivedMessages.redCount")) {
            this.indicateLowReceivedMessagesCountRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.redCount");
        } else if (evt.getPropertyName().equals("MessagePanel.indicateLowReceivedMessages.lightRedCount")) {
            this.indicateLowReceivedMessagesCountLightRed = Core.frostSettings.getIntValue("MessagePanel.indicateLowReceivedMessages.lightRedCount");
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new JCheckBox());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            TreeTableCellRenderer t = MessageTreeTable.this.getTree();
            boolean rv = t.isRootVisible();
            int offsetRow = rv ? r : r - 1;
            Rectangle bounds = t.getRowBounds(offsetRow);
            int offset = bounds.x;
            TreeCellRenderer tcr = t.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                Icon icon = t.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (MessageTreeTable.this.tree.isExpanded(offsetRow) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
                if (icon != null) {
                    offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                }
            }
            return component;
        }

        public boolean isCellEditable(EventObject e) {
            MouseEvent me;
            if (e instanceof MouseEvent && ((me = (MouseEvent)e).getModifiers() == 0 || me.getModifiers() == 16)) {
                for (int counter = MessageTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (MessageTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent newME = new MouseEvent(MessageTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - MessageTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    MessageTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private Font boldFont;
        private Font boldItalicFont;
        private Font normalFont;
        private boolean isDeleted = false;
        private final Color col_good = new Color(0, 128, 0);
        private final Color col_check = new Color(255, 204, 0);
        private final Color col_observe = new Color(0, 208, 0);
        private final Color col_bad = new Color(255, 0, 0);
        final EmptyBorder border = new EmptyBorder(0, 0, 0, 3);

        public StringCellRenderer() {
            this.setVerticalAlignment(0);
            Font baseFont = MessageTreeTable.this.getFont();
            this.fontChanged(baseFont);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isDeleted) {
                Dimension size = this.getSize();
                g.drawLine(0, size.height / 2, size.width, size.height / 2);
            }
        }

        public void fontChanged(Font font) {
            this.normalFont = font.deriveFont(0);
            this.boldFont = font.deriveFont(1);
            this.boldItalicFont = font.deriveFont(3);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, MessageTreeTable.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            this.setAlignmentY(0.5f);
            this.setFont(this.normalFont);
            if (!isSelected) {
                this.setForeground(Color.BLACK);
            }
            this.setToolTipText(null);
            this.setBorder(null);
            this.setHorizontalAlignment(2);
            this.setIcon(null);
            TreeTableModelAdapter model = (TreeTableModelAdapter)MessageTreeTable.this.getModel();
            Object obj = model.getRow(row);
            if (!(obj instanceof FrostMessageObject)) {
                return this;
            }
            FrostMessageObject msg = (FrostMessageObject)obj;
            obj = null;
            column = MessageTreeTable.this.getColumnModel().getColumn(column).getModelIndex();
            if (column == 3) {
                if (msg.isNew()) {
                    this.setFont(this.boldFont);
                }
                if (!isSelected) {
                    if (msg.getRecipientName() != null && msg.getRecipientName().length() > 0) {
                        this.setForeground(Color.RED);
                    } else if (msg.containsAttachments()) {
                        this.setForeground(Color.BLUE);
                    }
                }
                if (!msg.isDummy()) {
                    if (msg.isSignatureStatusVERIFIED()) {
                        Identity id = msg.getFromIdentity();
                        if (id == null) {
                            logger.severe("getFromidentity() is null for fromName: '" + msg.getFromName() + "', " + "board=" + msg.getBoard().getName() + ", msgDate=" + msg.getDateAndTimeString() + ", index=" + msg.getIndex());
                            this.setToolTipText((String)value);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            sb.append("<html>");
                            sb.append((String)value);
                            sb.append("<br>Last seen: ");
                            sb.append(DateFun.FORMAT_DATE_VISIBLE.print(id.getLastSeenTimestamp()));
                            sb.append("  ");
                            sb.append(DateFun.FORMAT_TIME_VISIBLE.print(id.getLastSeenTimestamp()));
                            sb.append("<br>Received messages: ").append(id.getReceivedMessageCount());
                            sb.append("</html>");
                            this.setToolTipText(sb.toString());
                            if (MessageTreeTable.this.indicateLowReceivedMessages) {
                                int receivedMsgCount = id.getReceivedMessageCount();
                                if (receivedMsgCount <= MessageTreeTable.this.indicateLowReceivedMessagesCountRed) {
                                    this.setIcon(MessageTreeTable.this.receivedOneMessage);
                                } else if (receivedMsgCount <= MessageTreeTable.this.indicateLowReceivedMessagesCountLightRed) {
                                    this.setIcon(MessageTreeTable.this.receivedFiveMessages);
                                }
                            }
                        }
                    } else {
                        this.setToolTipText((String)value);
                    }
                }
            } else if (column == 4) {
                this.setHorizontalAlignment(4);
                this.setBorder(this.border);
            } else if (column == 6) {
                Font f = FcpHandler.isFreenet05() ? this.boldFont : (msg.isSignatureStatusVERIFIED_V2() ? this.boldFont : this.boldItalicFont);
                if (msg.isMessageStatusGOOD()) {
                    this.setFont(f);
                    this.setForeground(this.col_good);
                } else if (msg.isMessageStatusCHECK()) {
                    this.setFont(f);
                    this.setForeground(this.col_check);
                } else if (msg.isMessageStatusOBSERVE()) {
                    this.setFont(f);
                    this.setForeground(this.col_observe);
                } else if (msg.isMessageStatusBAD()) {
                    this.setFont(f);
                    this.setForeground(this.col_bad);
                } else if (msg.isMessageStatusTAMPERED()) {
                    this.setFont(f);
                    this.setForeground(this.col_bad);
                }
            }
            this.setDeleted(msg.isDeleted());
            return this;
        }

        public void setDeleted(boolean value) {
            this.isDeleted = value;
        }
    }

    private class BooleanCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public BooleanCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            super.paintComponent(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean val = (Boolean)value;
            TableColumn tableColumn = MessageTreeTable.this.getColumnModel().getColumn(column);
            column = tableColumn.getModelIndex();
            ImageIcon iconToSet = null;
            if (val) {
                if (column == 0) {
                    iconToSet = MessageTreeTable.this.flaggedIcon;
                } else if (column == 1) {
                    iconToSet = MessageTreeTable.this.starredIcon;
                } else if (column == 5) {
                    iconToSet = MessageTreeTable.this.junkIcon;
                }
            }
            this.setIcon(iconToSet);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, MessageTreeTable.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            block0: {
                if (this.updatingListSelectionModel) break block0;
                this.updatingListSelectionModel = true;
                this.updatingListSelectionModel = false;
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = MessageTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        private Font boldFont;
        private Font normalFont;
        private boolean isDeleted;
        private String toolTipText;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.boldFont = null;
            this.normalFont = null;
            this.isDeleted = false;
            this.toolTipText = null;
            Font baseFont = MessageTreeTable.this.getFont();
            this.normalFont = baseFont.deriveFont(0);
            this.boldFont = baseFont.deriveFont(1);
            this.setCellRenderer(new OwnTreeCellRenderer());
            if (this.getUI() instanceof BasicTreeUI) {
                BasicTreeUI treeUI = (BasicTreeUI)this.getUI();
                treeUI.setLeftChildIndent(6);
                treeUI.setRightChildIndent(10);
            }
        }

        public void fontChanged(Font font) {
            this.normalFont = font.deriveFont(0);
            this.boldFont = font.deriveFont(1);
        }

        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setDeleted(boolean value) {
            this.isDeleted = value;
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (MessageTreeTable.this != null && MessageTreeTable.this.getRowHeight() != rowHeight) {
                    MessageTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, MessageTreeTable.this.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background;
            TreeTableModelAdapter model = (TreeTableModelAdapter)MessageTreeTable.this.getModel();
            FrostMessageObject msg = (FrostMessageObject)model.getRow(row);
            if (msg.isNew()) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.normalFont);
            }
            Color foreground = msg.getRecipientName() != null && msg.getRecipientName().length() > 0 ? Color.RED : (msg.containsAttachments() ? Color.BLUE : Color.BLACK);
            if (!isSelected) {
                Color newBackground;
                background = newBackground = TableBackgroundColors.getBackgroundColor(table, row, MessageTreeTable.this.showColoredLines);
            } else {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            }
            this.setDeleted(msg.isDeleted());
            this.visibleRow = row;
            this.setBackground(background);
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                ImageIcon icon;
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (isSelected) {
                    dtcr.setTextSelectionColor(foreground);
                    dtcr.setBackgroundSelectionColor(background);
                } else {
                    dtcr.setTextNonSelectionColor(foreground);
                    dtcr.setBackgroundNonSelectionColor(background);
                }
                dtcr.setBorder(null);
                if (((FrostMessageObject)msg.getParent()).isRoot()) {
                    boolean[] hasUnreadOrMarked = msg.hasUnreadOrMarkedChilds();
                    boolean hasUnread = hasUnreadOrMarked[0];
                    boolean hasMarked = hasUnreadOrMarked[1];
                    if (hasUnread && !hasMarked) {
                        dtcr.setBorder(MessageTreeTable.this.borderUnreadMsgsInThread);
                    } else if (!hasUnread && hasMarked) {
                        dtcr.setBorder(MessageTreeTable.this.borderMarkedMsgsInThread);
                    } else if (!hasUnread && !hasMarked) {
                        dtcr.setBorder(MessageTreeTable.this.borderEmpty);
                    } else {
                        dtcr.setBorder(MessageTreeTable.this.borderUnreadAndMarkedMsgsInThread);
                    }
                }
                if (msg.isDummy()) {
                    icon = MessageTreeTable.this.messageDummyIcon;
                    if (msg.getSubject() != null && msg.getSubject().length() > 0) {
                        this.setToolTipText(msg.getSubject());
                    } else {
                        this.setToolTipText(null);
                    }
                } else {
                    icon = msg.isNew() ? (msg.isReplied() ? MessageTreeTable.this.messageNewRepliedIcon : MessageTreeTable.this.messageNewIcon) : (msg.isReplied() ? MessageTreeTable.this.messageReadRepliedIcon : MessageTreeTable.this.messageReadIcon);
                    this.setToolTipText(msg.getSubject());
                }
                dtcr.setIcon(icon);
                dtcr.setLeafIcon(icon);
                dtcr.setOpenIcon(icon);
                dtcr.setClosedIcon(icon);
            }
            return this;
        }

        public void setToolTipText(String t) {
            this.toolTipText = t;
        }

        public String getToolTipText(MouseEvent event) {
            return this.toolTipText;
        }

        class OwnTreeCellRenderer
        extends DefaultTreeCellRenderer {
            int treeWidth;

            public OwnTreeCellRenderer() {
                this.setVerticalAlignment(0);
            }

            public Component getTreeCellRendererComponent(JTree lTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean lHasFocus) {
                this.treeWidth = lTree.getWidth();
                return super.getTreeCellRendererComponent(lTree, value, sel, expanded, leaf, row, lHasFocus);
            }

            public void paint(Graphics g) {
                this.setSize(new Dimension(this.treeWidth - this.getBounds().x, this.getSize().height));
                super.paint(g);
                if (TreeTableCellRenderer.this.isDeleted) {
                    Dimension size = this.getSize();
                    g.drawLine(0, size.height / 2, size.width, size.height / 2);
                }
            }
        }
    }
}

