/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatisticsDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JLabel LmsgCountLabel = null;
    private JLabel LmsgCount = null;
    private JLabel LarcMsgCountLabel = null;
    private JLabel LarcMsgCount = null;
    private JLabel LidCountLabel = null;
    private JLabel LidCount = null;
    private JLabel LfileCountLabel = null;
    private JLabel LfileCount = null;
    private JButton Bclose = null;
    private JLabel glueLabel = null;
    private JLabel LfileSizeLabel = null;
    private JLabel LfileSize = null;
    private JLabel LsharerCountLabel = null;
    private JLabel LsharerCount = null;
    Frame owner;

    public StatisticsDialog(Frame owner) {
        super(owner);
        this.owner = owner;
        this.initialize();
    }

    private void initialize() {
        this.setSize(423, 313);
        this.setTitle("StatisticsDialog.title");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.insets = new Insets(8, 5, 0, 10);
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.gridy = 3;
            this.LsharerCount = new JLabel();
            this.LsharerCount.setText("JLabel");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(8, 10, 0, 5);
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridy = 3;
            this.LsharerCountLabel = new JLabel();
            this.LsharerCountLabel.setText("Sharers");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.insets = new Insets(3, 5, 0, 10);
            gridBagConstraints8.gridy = 5;
            this.LfileSize = new JLabel();
            this.LfileSize.setText("JLabel");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(3, 10, 0, 5);
            gridBagConstraints7.gridy = 5;
            this.LfileSizeLabel = new JLabel();
            this.LfileSizeLabel.setText("File sizes");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.gridy = 7;
            this.glueLabel = new JLabel();
            this.glueLabel.setText("");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.anchor = 10;
            gridBagConstraints5.insets = new Insets(10, 5, 10, 5);
            gridBagConstraints5.gridy = 6;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(3, 5, 0, 10);
            gridBagConstraints4.gridy = 4;
            this.LfileCount = new JLabel();
            this.LfileCount.setText("JLabel");
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.insets = new Insets(3, 10, 0, 5);
            gridBagConstraints31.gridy = 4;
            this.LfileCountLabel = new JLabel();
            this.LfileCountLabel.setText("Files");
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.anchor = 13;
            gridBagConstraints21.insets = new Insets(8, 5, 0, 10);
            gridBagConstraints21.gridy = 2;
            this.LidCount = new JLabel();
            this.LidCount.setText("JLabel");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(8, 10, 0, 5);
            gridBagConstraints11.gridy = 2;
            this.LidCountLabel = new JLabel();
            this.LidCountLabel.setText("Identities");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.insets = new Insets(3, 5, 0, 10);
            gridBagConstraints3.gridy = 1;
            this.LarcMsgCount = new JLabel();
            this.LarcMsgCount.setText("JLabel");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(3, 10, 0, 5);
            gridBagConstraints2.gridy = 1;
            this.LarcMsgCountLabel = new JLabel();
            this.LarcMsgCountLabel.setText("Archived messages");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.insets = new Insets(10, 5, 0, 10);
            gridBagConstraints1.gridy = 0;
            this.LmsgCount = new JLabel();
            this.LmsgCount.setText("JLabel");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 0, 5);
            gridBagConstraints.gridy = 0;
            this.LmsgCountLabel = new JLabel();
            this.LmsgCountLabel.setText("Messages");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.LmsgCountLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.LmsgCount, gridBagConstraints1);
            this.jContentPane.add((Component)this.LarcMsgCountLabel, gridBagConstraints2);
            this.jContentPane.add((Component)this.LarcMsgCount, gridBagConstraints3);
            this.jContentPane.add((Component)this.LidCountLabel, gridBagConstraints11);
            this.jContentPane.add((Component)this.LidCount, gridBagConstraints21);
            this.jContentPane.add((Component)this.LfileCountLabel, gridBagConstraints31);
            this.jContentPane.add((Component)this.LfileCount, gridBagConstraints4);
            this.jContentPane.add((Component)this.getBclose(), gridBagConstraints5);
            this.jContentPane.add((Component)this.glueLabel, gridBagConstraints6);
            this.jContentPane.add((Component)this.LsharerCountLabel, gridBagConstraints9);
            this.jContentPane.add((Component)this.LsharerCount, gridBagConstraints10);
        }
        return this.jContentPane;
    }

    private JButton getBclose() {
        if (this.Bclose == null) {
            this.Bclose = new JButton();
            this.Bclose.setText("Close");
            this.Bclose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StatisticsDialog.this.setVisible(false);
                }
            });
        }
        return this.Bclose;
    }

    private void refreshLanguage() {
        Language language = Language.getInstance();
        this.setTitle(language.getString("StatisticsDialog.title"));
        this.Bclose.setText(language.getString("StatisticsDialog.button.close"));
        this.LmsgCountLabel.setText(language.getString("StatisticsDialog.label.messages") + ":");
        this.LarcMsgCountLabel.setText(language.getString("StatisticsDialog.label.archivedMessages") + ":");
        this.LidCountLabel.setText(language.getString("StatisticsDialog.label.identities") + ":");
        this.LsharerCountLabel.setText(language.getString("StatisticsDialog.label.sharers") + ":");
        this.LfileCountLabel.setText(language.getString("StatisticsDialog.label.files") + ":");
        this.LfileSizeLabel.setText(language.getString("StatisticsDialog.label.fileSizes") + ":");
    }

    public void startDialog(int msgCount, int arcMsgCount, int idCount, int sharerCount, int fileCount, long fileSize) {
        this.setModal(true);
        this.refreshLanguage();
        NumberFormat nf = NumberFormat.getInstance();
        this.LmsgCount.setText(nf.format(msgCount));
        this.LarcMsgCount.setText(nf.format(arcMsgCount));
        this.LidCount.setText(nf.format(idCount));
        this.LsharerCount.setText(nf.format(sharerCount));
        this.LfileCount.setText(nf.format(fileCount));
        this.LfileSize.setText(nf.format(fileSize));
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }
}

