/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.gui.SortHeaderRenderer;
import frost.gui.model.SortedTableModel;
import frost.gui.model.TableMember;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortedTable
extends JTable {
    protected int sortedColumnIndex = 0;
    protected boolean sortedColumnAscending = true;
    private SortHeaderRenderer columnHeadersRenderer = new SortHeaderRenderer();

    public SortedTable(SortedTableModel model) {
        super(model);
        model.setParentTable(this);
        this.initSortHeader();
    }

    public void sortColumn(int col, boolean ascending) {
        SortedTableModel model = null;
        model = (SortedTableModel)this.getModel();
        ArrayList list = this.getListOfSelectedItems();
        this.clearSelection();
        model.sortModelColumn(col, ascending);
        this.setSelectedItems(list);
    }

    public void resortTable() {
        this.sortColumn(this.sortedColumnIndex, this.sortedColumnAscending);
        ((SortedTableModel)this.getModel()).tableEntriesChanged();
    }

    protected void setSelectedItems(ArrayList items) {
        if (!(this.getModel() instanceof SortedTableModel)) {
            return;
        }
        SortedTableModel model = (SortedTableModel)this.getModel();
        for (int x = 0; x < model.getRowCount(); ++x) {
            TableMember item1 = model.getRow(x);
            for (Object item2 : items) {
                if (item1 != item2) continue;
                this.getSelectionModel().addSelectionInterval(x, x);
            }
        }
    }

    protected ArrayList getListOfSelectedItems() {
        ArrayList<TableMember> lst = new ArrayList<TableMember>();
        if (!(this.getModel() instanceof SortedTableModel)) {
            return lst;
        }
        SortedTableModel model = (SortedTableModel)this.getModel();
        int[] selectedRows = this.getSelectedRows();
        for (int x = 0; x < selectedRows.length; ++x) {
            lst.add(model.getRow(selectedRows[x]));
        }
        return lst;
    }

    public void setSavedSettings(int val, boolean val2) {
        if (!(this.getModel() instanceof SortedTableModel)) {
            return;
        }
        this.sortedColumnIndex = val;
        this.sortedColumnAscending = val2;
        this.sortColumn(this.sortedColumnIndex, this.sortedColumnAscending);
    }

    protected void initSortHeader() {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn column = enumeration.nextElement();
            column.setHeaderRenderer(this.columnHeadersRenderer);
        }
        this.getTableHeader().addMouseListener(new HeaderMouseListener());
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public SortedTable instance() {
        return this;
    }

    class HeaderMouseListener
    implements MouseListener {
        HeaderMouseListener() {
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
            if (event.isPopupTrigger()) {
                return;
            }
            TableColumnModel colModel = SortedTable.this.getColumnModel();
            int index = colModel.getColumnIndexAtX(event.getX());
            int modelIndex = colModel.getColumn(index).getModelIndex();
            SortedTableModel model = null;
            model = (SortedTableModel)SortedTable.this.getModel();
            boolean isSortable = false;
            if (model != null && model.isSortable(modelIndex)) {
                isSortable = true;
            }
            if (isSortable) {
                if (SortedTable.this.sortedColumnIndex == modelIndex) {
                    SortedTable.this.sortedColumnAscending = !SortedTable.this.sortedColumnAscending;
                }
                SortedTable.this.sortedColumnIndex = modelIndex;
                SortedTable.this.sortColumn(modelIndex, SortedTable.this.sortedColumnAscending);
            }
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }
    }
}

