/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.gui.SortedTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    public static Icon ICON_NONSORTED = new SortArrowIcon(0);
    public static Icon ICON_ASCENDING = new SortArrowIcon(2);
    public static Icon ICON_DECENDING = new SortArrowIcon(1);

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        TableCellRenderer defaultRenderer = table.getTableHeader().getDefaultRenderer();
        if (defaultRenderer == null) {
            if (table instanceof SortedTable) {
                Icon icon = this.getArrow((SortedTable)table, col);
                this.setIcon(icon);
            }
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
        if (defaultRenderer instanceof JLabel && table instanceof SortedTable) {
            Icon icon = this.getArrow((SortedTable)table, col);
            ((JLabel)((Object)defaultRenderer)).setIcon(icon);
        }
        return defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
    }

    private Icon getArrow(SortedTable table, int col) {
        int index = -1;
        int modelIndex = -1;
        boolean ascending = true;
        index = table.getSortedColumnIndex();
        ascending = table.isSortedColumnAscending();
        TableColumnModel colModel = table.getColumnModel();
        modelIndex = colModel.getColumn(col).getModelIndex();
        Icon icon = ascending ? ICON_ASCENDING : ICON_DECENDING;
        return modelIndex == index ? icon : ICON_NONSORTED;
    }

    static class SortArrowIcon
    implements Icon {
        public static final int NONE = 0;
        public static final int DECENDING = 1;
        public static final int ASCENDING = 2;
        protected int direction;
        protected int width = 8;
        protected int height = 8;

        public SortArrowIcon(int direction) {
            this.direction = direction;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color bg = c.getBackground();
            Color light = bg.brighter();
            Color shade = bg.darker();
            int w = this.width;
            int h = this.height;
            int m = w / 2;
            if (this.direction == 2) {
                g.setColor(shade);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x + m, y + h);
                g.setColor(light);
                g.drawLine(x + w, y, x + m, y + h);
            }
            if (this.direction == 1) {
                g.setColor(shade);
                g.drawLine(x + m, y, x, y + h);
                g.setColor(light);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + m, y, x + w, y + h);
            }
        }
    }
}

