/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.gui.SortedTable;
import frost.gui.model.SearchMessagesTableModel;
import frost.messages.FrostSearchResultMessageObject;
import frost.util.gui.IconTableHeaderRenderer;
import frost.util.gui.MiscToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SearchMessagesResultTable
extends SortedTable {
    private final CellRenderer cellRenderer = new CellRenderer();
    private final BooleanCellRenderer booleanCellRenderer = new BooleanCellRenderer();
    private final ImageIcon flaggedIcon = MiscToolkit.loadImageIcon("/data/flagged.gif");
    private final ImageIcon starredIcon = MiscToolkit.loadImageIcon("/data/starred.gif");
    private final ImageIcon messageDummyIcon = MiscToolkit.loadImageIcon("/data/messagedummyicon.gif");
    private final ImageIcon messageNewIcon = MiscToolkit.loadImageIcon("/data/messagenewicon.gif");
    private final ImageIcon messageReadIcon = MiscToolkit.loadImageIcon("/data/messagereadicon.gif");
    private final ImageIcon messageNewRepliedIcon = MiscToolkit.loadImageIcon("/data/messagenewrepliedicon.gif");
    private final ImageIcon messageReadRepliedIcon = MiscToolkit.loadImageIcon("/data/messagereadrepliedicon.gif");
    private final boolean showColoredLines;

    public SearchMessagesResultTable(SearchMessagesTableModel m) {
        super(m);
        this.setDefaultRenderer(String.class, this.cellRenderer);
        this.setDefaultRenderer(Boolean.class, this.booleanCellRenderer);
        this.sortedColumnIndex = 5;
        this.sortedColumnAscending = false;
        this.resortTable();
        this.initLayout();
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
    }

    private void initLayout() {
        TableColumnModel tcm = this.getColumnModel();
        tcm.getColumn(0).setMinWidth(20);
        tcm.getColumn(0).setMaxWidth(20);
        tcm.getColumn(0).setPreferredWidth(20);
        tcm.getColumn(1).setMinWidth(20);
        tcm.getColumn(1).setMaxWidth(20);
        tcm.getColumn(1).setPreferredWidth(20);
        tcm.getColumn(0).setHeaderRenderer(new IconTableHeaderRenderer(this.flaggedIcon));
        tcm.getColumn(1).setHeaderRenderer(new IconTableHeaderRenderer(this.starredIcon));
    }

    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        int[] widths = new int[]{20, 20, 30, 125, 80, 250, 75, 150};
        for (int i = 0; i < widths.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.cellRenderer != null) {
            this.cellRenderer.setFont(font);
        }
        this.setRowHeight(font.getSize() + 5);
    }

    private class BooleanCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public BooleanCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            super.paintComponent(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean val = (Boolean)value;
            TableColumn tableColumn = SearchMessagesResultTable.this.getColumnModel().getColumn(column);
            column = tableColumn.getModelIndex();
            if (column == 0) {
                if (val) {
                    this.setIcon(SearchMessagesResultTable.this.flaggedIcon);
                } else {
                    this.setIcon(null);
                }
            } else if (column == 1) {
                if (val) {
                    this.setIcon(SearchMessagesResultTable.this.starredIcon);
                } else {
                    this.setIcon(null);
                }
            }
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, SearchMessagesResultTable.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private Font boldFont = null;
        private Font normalFont = null;
        private boolean isDeleted = false;
        private final Color col_good = new Color(0, 128, 0);
        private final Color col_check = new Color(255, 204, 0);
        private final Color col_observe = new Color(0, 208, 0);
        private final Color col_bad = new Color(255, 0, 0);

        public CellRenderer() {
            Font baseFont = SearchMessagesResultTable.this.getFont();
            this.normalFont = baseFont.deriveFont(0);
            this.boldFont = baseFont.deriveFont(1);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isDeleted) {
                Dimension size = this.getSize();
                g.drawLine(0, size.height / 2, size.width, size.height / 2);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            SearchMessagesTableModel model = (SearchMessagesTableModel)SearchMessagesResultTable.this.getModel();
            FrostSearchResultMessageObject msg = (FrostSearchResultMessageObject)model.getRow(row);
            TableColumn tableColumn = SearchMessagesResultTable.this.getColumnModel().getColumn(column);
            column = tableColumn.getModelIndex();
            this.setIcon(null);
            this.setToolTipText(null);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, SearchMessagesResultTable.this.showColoredLines);
                this.setBackground(newBackground);
            }
            if (column == 3) {
                if (msg.getMessageObject().isNew()) {
                    this.setFont(this.boldFont);
                } else {
                    this.setFont(this.normalFont);
                }
                if (!isSelected) {
                    if (msg.getMessageObject().getRecipientName() != null && msg.getMessageObject().getRecipientName().length() > 0) {
                        this.setForeground(Color.RED);
                    } else if (msg.getMessageObject().containsAttachments()) {
                        this.setForeground(Color.BLUE);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                }
                this.setToolTipText(msg.getMessageObject().getFromName());
            } else if (column == 5) {
                ImageIcon icon = msg.getMessageObject().isDummy() ? SearchMessagesResultTable.this.messageDummyIcon : (msg.getMessageObject().isNew() ? (msg.getMessageObject().isReplied() ? SearchMessagesResultTable.this.messageNewRepliedIcon : SearchMessagesResultTable.this.messageNewIcon) : (msg.getMessageObject().isReplied() ? SearchMessagesResultTable.this.messageReadRepliedIcon : SearchMessagesResultTable.this.messageReadIcon));
                this.setIcon(icon);
                this.setToolTipText(msg.getMessageObject().getSubject());
            } else if (column == 6) {
                if (msg.getMessageObject().isMessageStatusGOOD()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_good);
                } else if (msg.getMessageObject().isMessageStatusCHECK()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_check);
                } else if (msg.getMessageObject().isMessageStatusOBSERVE()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_observe);
                } else if (msg.getMessageObject().isMessageStatusBAD()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_bad);
                } else if (msg.getMessageObject().isMessageStatusTAMPERED()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_bad);
                } else {
                    this.setFont(this.normalFont);
                    if (!isSelected) {
                        this.setForeground(Color.BLACK);
                    }
                }
            } else {
                this.setFont(this.normalFont);
                if (!isSelected) {
                    this.setForeground(Color.BLACK);
                }
            }
            this.setDeleted(msg.getMessageObject().isDeleted());
            return this;
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.normalFont = font.deriveFont(0);
            this.boldFont = font.deriveFont(1);
        }

        public void setDeleted(boolean value) {
            this.isDeleted = value;
        }
    }
}

