/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.UIManager;

public class ScrollButton
extends JButton {
    private int direction;
    private int buttonWidth;
    private boolean small;

    public ScrollButton(int direction, int width) {
        this(direction, width, true);
    }

    public ScrollButton(int direction, int width, boolean small) {
        this.direction = direction;
        this.small = small;
        this.buttonWidth = width;
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setSmallArrows(boolean small) {
        if (small != this.small) {
            this.small = small;
        }
        this.repaint();
    }

    public boolean isSmallArrows() {
        return this.small;
    }

    public void paint(Graphics g) {
        block9: {
            int arrowHeight;
            int h;
            int w;
            Color arrowColor;
            block11: {
                block10: {
                    block8: {
                        super.paint(g);
                        boolean isEnabled = this.getParent().isEnabled();
                        arrowColor = isEnabled ? UIManager.getColor("Button.foreground") : UIManager.getColor("Button.disabled");
                        int width = this.getWidth();
                        int height = this.getHeight();
                        w = width;
                        h = height;
                        if (this.direction == 7 || this.direction == 3) {
                            arrowHeight = this.small ? (width + 1) / 4 : (height > width + 5 ? (width + 1) / 2 : (width + 1) / 3);
                        } else if (this.small) {
                            arrowHeight = (height + 1) / 4;
                        } else {
                            int n = arrowHeight = width > height + 5 ? (height + 1) / 2 : (height + 1) / 3;
                        }
                        if (this.direction != 1) break block8;
                        g.setColor(arrowColor);
                        int startY = (h + 1 - arrowHeight) / 2;
                        int startX = w / 2;
                        for (int line = 0; line < arrowHeight; ++line) {
                            g.drawLine(startX - line, startY + line, startX + line + 1, startY + line);
                        }
                        break block9;
                    }
                    if (this.direction != 5) break block10;
                    g.setColor(arrowColor);
                    int startY = (h + 1 - arrowHeight) / 2 + arrowHeight - 1;
                    int startX = w / 2;
                    for (int line = 0; line < arrowHeight; ++line) {
                        g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
                    }
                    break block9;
                }
                if (this.direction != 3) break block11;
                g.setColor(arrowColor);
                int startX = (w + 1 - arrowHeight) / 2 + arrowHeight - 1;
                int startY = h / 2;
                for (int line = 0; line < arrowHeight; ++line) {
                    g.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
                }
                break block9;
            }
            if (this.direction != 7) break block9;
            g.setColor(arrowColor);
            int startX = (w + 1 - arrowHeight) / 2;
            int startY = h / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX + line, startY - line, startX + line, startY + line + 1);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.direction == 1 || this.direction == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - 1);
        }
        if (this.direction == 3 || this.direction == 7) {
            return new Dimension(this.buttonWidth - 1, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }
}

