/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewBoardDialog
extends JDialog {
    public static int CHOICE_ADD = 1;
    public static int CHOICE_CANCEL = 2;
    private Listener listener = new Listener();
    private Language language;
    private JPanel contentPanel = new JPanel();
    private JLabel detailsLabel = new JLabel();
    private JLabel descriptionLabel = new JLabel();
    private JLabel nameLabel = new JLabel();
    private JTextField nameTextField = new JTextField(40);
    private JButton cancelButton = new JButton();
    private JButton addButton = new JButton();
    private JTextArea descriptionTextArea = new JTextArea(3, 40);
    private JScrollPane descriptionScrollPane;
    private int choice = CHOICE_CANCEL;
    private String boardName;
    private String boardDescription;

    public NewBoardDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.language = Language.getInstance();
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setModal(true);
    }

    private void initialize() {
        this.contentPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setContentPane(this.contentPanel);
        this.contentPanel.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.nameTextField, this.language);
        new TextComponentClipboardMenu(this.descriptionTextArea, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        Insets insets5555 = new Insets(5, 5, 5, 5);
        Insets insets10_555 = new Insets(10, 5, 5, 5);
        constraints.insets = insets5555;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        this.contentPanel.add((Component)this.detailsLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.contentPanel.add((Component)this.nameLabel, constraints);
        constraints.gridy = 2;
        this.contentPanel.add((Component)this.nameTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        this.contentPanel.add((Component)this.descriptionLabel, constraints);
        constraints.gridy = 4;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.descriptionScrollPane = new JScrollPane(this.descriptionTextArea);
        this.contentPanel.add((Component)this.descriptionScrollPane, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 2.0;
        constraints.weighty = 0.0;
        constraints.anchor = 13;
        constraints.fill = 0;
        constraints.insets = insets10_555;
        constraints.gridx = 1;
        constraints.gridy = 5;
        this.contentPanel.add((Component)this.addButton, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        this.contentPanel.add((Component)this.cancelButton, constraints);
        this.addButton.setEnabled(false);
        this.nameTextField.getDocument().addDocumentListener(this.listener);
        this.addButton.addActionListener(this.listener);
        this.cancelButton.addActionListener(this.listener);
    }

    private void refreshLanguage() {
        this.setTitle(" " + this.language.getString("NewBoardDialog.title"));
        this.detailsLabel.setText(this.language.getString("NewBoardDialog.details"));
        this.nameLabel.setText(this.language.getString("NewBoardDialog.name"));
        this.descriptionLabel.setText(this.language.getString("NewBoardDialog.description"));
        this.addButton.setText(this.language.getString("NewBoardDialog.add"));
        this.cancelButton.setText(this.language.getString("Common.cancel"));
    }

    private void updateAddButtonState() {
        if (this.nameTextField.getText().trim().length() == 0) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    private void addButton_actionPerformed() {
        this.boardName = this.nameTextField.getText().trim();
        this.boardDescription = this.descriptionTextArea.getText().trim();
        this.choice = CHOICE_ADD;
        this.dispose();
    }

    private void cancelButton_actionPerformed() {
        this.dispose();
    }

    public int getChoice() {
        return this.choice;
    }

    public String getBoardDescription() {
        return this.boardDescription;
    }

    public String getBoardName() {
        return this.boardName;
    }

    private class Listener
    implements DocumentListener,
    ActionListener {
        private Listener() {
        }

        public void changedUpdate(DocumentEvent e) {
            if (e.getDocument() == NewBoardDialog.this.nameTextField.getDocument()) {
                NewBoardDialog.this.updateAddButtonState();
            }
        }

        public void insertUpdate(DocumentEvent e) {
            if (e.getDocument() == NewBoardDialog.this.nameTextField.getDocument()) {
                NewBoardDialog.this.updateAddButtonState();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument() == NewBoardDialog.this.nameTextField.getDocument()) {
                NewBoardDialog.this.updateAddButtonState();
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == NewBoardDialog.this.addButton) {
                NewBoardDialog.this.addButton_actionPerformed();
            } else if (e.getSource() == NewBoardDialog.this.cancelButton) {
                NewBoardDialog.this.cancelButton_actionPerformed();
            }
        }
    }
}

