/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.MainFrame;
import frost.gui.MessageTextPane;
import frost.gui.SearchMessagesConfig;
import frost.messages.FrostMessageObject;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MessageWindow
extends JFrame {
    private final FrostMessageObject message;
    private final Window parentWindow;
    private MessageTextPane messageTextPane;
    private MessageWindowTopPanel topPanel;
    private Listener listener;
    private final Language language = Language.getInstance();
    private SearchMessagesConfig searchMessagesConfig = null;
    private final boolean showReplyButton;
    private static final ImageIcon frameIcon = MiscToolkit.loadImageIcon("/data/messagebright.gif");

    public MessageWindow(Window parentWindow, FrostMessageObject message, Dimension size) {
        this(parentWindow, message, size, null, true);
    }

    public MessageWindow(Window parentWindow, FrostMessageObject message, Dimension size, boolean showReplyButton) {
        this(parentWindow, message, size, null, showReplyButton);
    }

    public MessageWindow(Window parentWindow, FrostMessageObject message, Dimension size, SearchMessagesConfig smc) {
        this(parentWindow, message, size, smc, true);
    }

    public MessageWindow(Window parentWindow, FrostMessageObject message, Dimension size, SearchMessagesConfig smc, boolean showReplyButton) {
        this.message = message;
        this.parentWindow = parentWindow;
        this.setSize(size);
        this.searchMessagesConfig = smc;
        this.showReplyButton = showReplyButton;
        this.initialize();
        this.setVisible(true);
        this.messageTextPane.update_messageSelected(message);
    }

    private void initialize() {
        this.listener = new Listener();
        this.setTitle(this.message.getSubject());
        this.getContentPane().setLayout(new BorderLayout());
        this.topPanel = new MessageWindowTopPanel(this.message);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.messageTextPane = new MessageTextPane(this, this.searchMessagesConfig);
        this.getContentPane().add((Component)this.messageTextPane, "Center");
        this.addKeyListener(this.listener);
        this.messageTextPane.addKeyListener(this.listener);
        this.topPanel.addKeyListener(this.listener);
        this.addWindowListener(this.listener);
        this.setIconImage(frameIcon.getImage());
        this.setLocationRelativeTo(this.parentWindow);
    }

    private void close() {
        this.messageTextPane.removeKeyListener(this.listener);
        this.messageTextPane.close();
        this.topPanel.removeKeyListener(this.listener);
        this.topPanel.close();
        this.dispose();
    }

    private void replyButtonPressed() {
        MainFrame.getInstance().getMessagePanel().composeReply(this.message, MainFrame.getInstance());
    }

    class MessageWindowTopPanel
    extends JPanel
    implements LanguageListener {
        private JLabel Lsubject = null;
        private JLabel Lfrom = null;
        private JLabel Lto = null;
        private JLabel Ldate = null;
        private JTextField TFsubject = null;
        private JTextField TFfrom = null;
        private JTextField TFto = null;
        private JTextField TFdate = null;
        private JLabel Lboard = null;
        private JTextField TFboard = null;
        private final FrostMessageObject innerMessage;
        private JButton Breply = null;

        public MessageWindowTopPanel(FrostMessageObject msg) {
            this.innerMessage = msg;
            this.initialize();
            this.languageChanged(null);
            MessageWindow.this.language.addLanguageListener(this);
        }

        public void addKeyListener(KeyListener l) {
            Component[] c;
            super.addKeyListener(l);
            for (Component element : c = this.getComponents()) {
                element.addKeyListener(l);
            }
        }

        public void removeKeyListener(KeyListener l) {
            Component[] c;
            super.removeKeyListener(l);
            for (Component element : c = this.getComponents()) {
                element.removeKeyListener(l);
            }
        }

        public void close() {
            MessageWindow.this.language.removeLanguageListener(this);
        }

        private void initialize() {
            this.Lboard = new JLabel();
            this.Lboard.setFont(new Font("Dialog", 1, 12));
            this.Ldate = new JLabel();
            this.Ldate.setFont(new Font("Dialog", 1, 12));
            this.Lfrom = new JLabel();
            this.Lfrom.setFont(new Font("Dialog", 1, 12));
            this.Lsubject = new JLabel();
            this.Lsubject.setFont(new Font("Dialog", 1, 12));
            this.Lto = new JLabel();
            this.Lto.setFont(new Font("Dialog", 1, 12));
            GridBagConstraints BreplyConstraints = new GridBagConstraints();
            BreplyConstraints.gridx = 5;
            BreplyConstraints.anchor = 12;
            BreplyConstraints.gridheight = 3;
            BreplyConstraints.insets = new Insets(5, 5, 5, 5);
            BreplyConstraints.gridy = 1;
            GridBagConstraints LsubjectConstraints = new GridBagConstraints();
            LsubjectConstraints.gridx = 0;
            LsubjectConstraints.insets = new Insets(1, 5, 1, 2);
            LsubjectConstraints.anchor = 17;
            LsubjectConstraints.gridy = 1;
            GridBagConstraints TFsubjectConstraints = new GridBagConstraints();
            TFsubjectConstraints.fill = 2;
            TFsubjectConstraints.gridy = 1;
            TFsubjectConstraints.weightx = 1.0;
            TFsubjectConstraints.gridwidth = 4;
            TFsubjectConstraints.insets = new Insets(1, 1, 1, 5);
            TFsubjectConstraints.anchor = 17;
            TFsubjectConstraints.gridx = 1;
            GridBagConstraints LfromConstraints = new GridBagConstraints();
            LfromConstraints.gridx = 0;
            LfromConstraints.insets = new Insets(1, 5, 1, 2);
            LfromConstraints.anchor = 17;
            LfromConstraints.gridy = 2;
            GridBagConstraints TFfromConstraints = new GridBagConstraints();
            TFfromConstraints.fill = 0;
            TFfromConstraints.gridy = 2;
            TFfromConstraints.weightx = 1.0;
            TFfromConstraints.gridwidth = 4;
            TFfromConstraints.insets = new Insets(1, 1, 1, 5);
            TFfromConstraints.anchor = 17;
            TFfromConstraints.gridx = 1;
            GridBagConstraints LtoConstraints = new GridBagConstraints();
            LtoConstraints.gridx = 0;
            LtoConstraints.insets = new Insets(1, 5, 1, 2);
            LtoConstraints.anchor = 17;
            LtoConstraints.gridy = 3;
            GridBagConstraints TFtoConstraints = new GridBagConstraints();
            TFtoConstraints.fill = 0;
            TFtoConstraints.gridy = 3;
            TFtoConstraints.weightx = 1.0;
            TFtoConstraints.gridwidth = 4;
            TFtoConstraints.insets = new Insets(1, 1, 1, 5);
            TFtoConstraints.anchor = 17;
            TFtoConstraints.gridx = 1;
            GridBagConstraints LdateConstraints = new GridBagConstraints();
            LdateConstraints.gridx = 0;
            LdateConstraints.insets = new Insets(1, 5, 1, 2);
            LdateConstraints.anchor = 17;
            LdateConstraints.gridy = 4;
            GridBagConstraints TFdateConstraints = new GridBagConstraints();
            TFdateConstraints.fill = 0;
            TFdateConstraints.gridy = 4;
            TFdateConstraints.weightx = 0.0;
            TFdateConstraints.insets = new Insets(1, 1, 1, 5);
            TFdateConstraints.anchor = 17;
            TFdateConstraints.gridx = 1;
            GridBagConstraints LboardConstraints = new GridBagConstraints();
            LboardConstraints.gridx = 2;
            LboardConstraints.insets = new Insets(1, 8, 1, 2);
            LboardConstraints.anchor = 17;
            LboardConstraints.gridy = 4;
            GridBagConstraints TFboardConstraints = new GridBagConstraints();
            TFboardConstraints.fill = 0;
            TFboardConstraints.gridy = 4;
            TFboardConstraints.weightx = 0.0;
            TFboardConstraints.anchor = 17;
            TFboardConstraints.insets = new Insets(1, 1, 1, 5);
            TFboardConstraints.gridx = 4;
            this.setLayout(new GridBagLayout());
            this.setSize(new Dimension(496, 254));
            this.add((Component)this.Lsubject, LsubjectConstraints);
            this.add((Component)this.Lfrom, LfromConstraints);
            this.add((Component)this.Ldate, LdateConstraints);
            this.add((Component)this.getTFsubject(), TFsubjectConstraints);
            this.add((Component)this.getTFfrom(), TFfromConstraints);
            if (this.innerMessage.getRecipientName() != null) {
                this.add((Component)this.Lto, LtoConstraints);
                this.add((Component)this.getTFto(), TFtoConstraints);
            }
            this.add((Component)this.getTFdate(), TFdateConstraints);
            this.add((Component)this.Lboard, LboardConstraints);
            this.add((Component)this.getTFboard(), TFboardConstraints);
            if (MessageWindow.this.showReplyButton) {
                this.add((Component)this.getBreply(), BreplyConstraints);
            }
        }

        public void languageChanged(LanguageEvent event) {
            this.Lsubject.setText(MessageWindow.this.language.getString("MessageWindow.subject") + ":");
            this.Lfrom.setText(MessageWindow.this.language.getString("MessageWindow.from") + ":");
            this.Lto.setText(MessageWindow.this.language.getString("MessageWindow.to") + ":");
            this.Ldate.setText(MessageWindow.this.language.getString("MessageWindow.date") + ":");
            this.Lboard.setText(MessageWindow.this.language.getString("MessageWindow.board") + ":");
        }

        private JTextField getTFsubject() {
            if (this.TFsubject == null) {
                this.TFsubject = new JTextField();
                this.TFsubject.setText(" " + this.innerMessage.getSubject());
                this.TFsubject.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.TFsubject.setEditable(false);
            }
            return this.TFsubject;
        }

        private JTextField getTFfrom() {
            if (this.TFfrom == null) {
                this.TFfrom = new JTextField();
                this.TFfrom.setText(" " + this.innerMessage.getFromName());
                this.TFfrom.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.TFfrom.setEditable(false);
            }
            return this.TFfrom;
        }

        private JTextField getTFto() {
            if (this.TFto == null) {
                this.TFto = new JTextField();
                this.TFto.setText(" " + this.innerMessage.getRecipientName());
                this.TFto.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.TFto.setEditable(false);
            }
            return this.TFto;
        }

        private JTextField getTFdate() {
            if (this.TFdate == null) {
                this.TFdate = new JTextField();
                this.TFdate.setText(" " + this.innerMessage.getDateAndTimeString());
                this.TFdate.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.TFdate.setEditable(false);
            }
            return this.TFdate;
        }

        private JTextField getTFboard() {
            if (this.TFboard == null) {
                this.TFboard = new JTextField();
                this.TFboard.setText(" " + this.innerMessage.getBoard().getName());
                this.TFboard.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.TFboard.setEditable(false);
            }
            return this.TFboard;
        }

        private JButton getBreply() {
            if (this.Breply == null) {
                this.Breply = new JButton();
                this.Breply.setIcon(MiscToolkit.loadImageIcon("/data/toolbar/mail-reply-sender.png"));
                this.Breply.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        MessageWindow.this.replyButtonPressed();
                    }
                });
                MiscToolkit.configureButton(this.Breply, "MessageWindow.tooltip.reply", MessageWindow.this.language);
            }
            return this.Breply;
        }
    }

    private class Listener
    extends WindowAdapter
    implements KeyListener,
    WindowListener {
        private Listener() {
        }

        public void keyPressed(KeyEvent e) {
            this.maybeDoSomething(e);
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            MessageWindow.this.close();
        }

        public void maybeDoSomething(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                MessageWindow.this.close();
            }
        }
    }
}

