/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.messages.MessageXmlFile;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class MessageUploadFailedDialog
extends JDialog {
    private static final int SECONDS_TO_WAIT = 30;
    public static final int NO_VALUE = 0;
    public static final int RETRY_VALUE = 1;
    public static final int RETRY_NEXT_STARTUP_VALUE = 2;
    public static final int DISCARD_VALUE = 3;
    private JButton retryButton;
    private JButton discardButton;
    private JButton tryOnNextStartupButton;
    private String retryButtonText;
    private RetryButtonTimer timer;
    private int userAnswer = 0;
    private MessageXmlFile failedMessage;
    private String errorString;

    public MessageUploadFailedDialog(Frame owner, MessageXmlFile fm, String error) {
        super(owner, true);
        this.failedMessage = fm;
        this.errorString = error;
        Language language = Language.getInstance();
        this.retryButtonText = language.getString("MessageUploadFailedDialog.option.retry") + " - ";
        this.setTitle(language.getString("MessageUploadFailedDialog.title"));
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.getContentPane().add(mainPanel);
        BorderLayout layout = new BorderLayout(0, 15);
        mainPanel.setLayout(layout);
        this.timer = new RetryButtonTimer(30);
        Icon warningIcon = UIManager.getIcon("OptionPane.warningIcon");
        String warningText = "  " + language.getString("MessageUploadFailedDialog.body");
        if (error != null && error.length() > 0) {
            warningText = warningText + "\n   Error  : " + this.errorString;
        }
        warningText = warningText + "\n   Sender : " + this.failedMessage.getFromName();
        warningText = warningText + "\n   Subject: " + this.failedMessage.getSubject();
        warningText = warningText + "\n   Boards : " + this.failedMessage.getAttachmentsOfType(1).size();
        warningText = warningText + "\n   Files  : " + this.failedMessage.getAttachmentsOfType(0).size();
        mainPanel.add((Component)new JLabel(warningText, warningIcon, 2), "North");
        mainPanel.add((Component)this.getButtonPanel(language), "South");
        ButtonListener bl = new ButtonListener();
        this.retryButton.addActionListener(bl);
        this.tryOnNextStartupButton.addActionListener(bl);
        this.discardButton.addActionListener(bl);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public int startDialog() {
        this.retryButton.requestFocus();
        this.timer.start();
        this.setModal(true);
        this.setVisible(true);
        return this.userAnswer;
    }

    private JPanel getButtonPanel(Language language) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 15, 0));
        this.retryButton = new JButton(this.retryButtonText + 30);
        this.discardButton = new JButton(language.getString("MessageUploadFailedDialog.option.discardMessage"));
        this.tryOnNextStartupButton = new JButton(language.getString("MessageUploadFailedDialog.option.retryOnNextStartup"));
        buttonsPanel.add(this.retryButton);
        buttonsPanel.add(this.tryOnNextStartupButton);
        buttonsPanel.add(this.discardButton);
        return buttonsPanel;
    }

    public void dispose() {
        this.timer.cancel();
        super.dispose();
    }

    private class RetryButtonTimer
    extends Timer {
        private int secs;

        public RetryButtonTimer(int secs) {
            this.secs = secs;
        }

        public void start() {
            this.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    RetryButtonTimer.this.timerTriggered();
                }
            }, 1000L, 1000L);
        }

        private void timerTriggered() {
            --this.secs;
            MessageUploadFailedDialog.this.retryButton.setText(MessageUploadFailedDialog.this.retryButtonText + this.secs);
            if (this.secs == 0) {
                MessageUploadFailedDialog.this.userAnswer = 1;
                MessageUploadFailedDialog.this.dispose();
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MessageUploadFailedDialog.this.retryButton) {
                MessageUploadFailedDialog.this.userAnswer = 1;
            } else if (e.getSource() == MessageUploadFailedDialog.this.tryOnNextStartupButton) {
                MessageUploadFailedDialog.this.userAnswer = 2;
            } else if (e.getSource() == MessageUploadFailedDialog.this.discardButton) {
                MessageUploadFailedDialog.this.userAnswer = 3;
            }
            MessageUploadFailedDialog.this.dispose();
        }
    }
}

