/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.boards.Board;
import frost.boards.Folder;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.gui.KnownBoardsManager;
import frost.gui.SearchMessagesConfig;
import frost.gui.TargetFolderChooser;
import frost.gui.model.AttachedBoardTableModel;
import frost.gui.model.AttachedFilesTableModel;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.FrostMessageObject;
import frost.util.CopyToClipboard;
import frost.util.FileAccess;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.SmileyCache;
import frost.util.gui.TextHighlighter;
import frost.util.gui.search.TextComponentFindAction;
import frost.util.gui.textpane.AntialiasedTextPane;
import frost.util.gui.textpane.MessageDecoder;
import frost.util.gui.textpane.MouseHyperlinkEvent;
import frost.util.gui.textpane.TextPane;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTextPane
extends JPanel {
    private final Language language = Language.getInstance();
    private final Logger logger = Logger.getLogger(MessageTextPane.class.getName());
    private AntialiasedTextPane messageTextArea = null;
    private JSplitPane messageSplitPane = null;
    private JSplitPane attachmentsSplitPane = null;
    private AttachedFilesTableModel attachedFilesModel;
    private AttachedBoardTableModel attachedBoardsModel;
    private JTable filesTable = null;
    private JTable boardsTable = null;
    private JScrollPane filesTableScrollPane;
    private JScrollPane boardsTableScrollPane;
    private JScrollPane messageBodyScrollPane;
    private PopupMenuAttachmentBoard popupMenuAttachmentBoard = null;
    private PopupMenuAttachmentFile popupMenuAttachmentTable = null;
    private PopupMenuHyperLink popupMenuHyperLink = null;
    private PopupMenuTofText popupMenuTofText = null;
    private FrostMessageObject selectedMessage;
    private final MainFrame mainFrame = MainFrame.getInstance();
    private final Component parentFrame;
    private PropertyChangeListener propertyChangeListener;
    private SearchMessagesConfig searchMessagesConfig = null;
    private TextHighlighter textHighlighter = null;
    private static Color highlightColor = new Color(32, 255, 32);
    private static Color idLineHighlightColor = Color.LIGHT_GRAY;
    private final TextHighlighter idLineTextHighlighter = new TextHighlighter(idLineHighlightColor);

    public MessageTextPane(Component parentFrame) {
        this(parentFrame, null);
    }

    public MessageTextPane(Component parentFrame, SearchMessagesConfig smc) {
        this.parentFrame = parentFrame;
        this.searchMessagesConfig = smc;
        this.initialize();
    }

    public void update_noBoardsFound() {
        this.messageSplitPane.setBottomComponent(null);
        this.messageSplitPane.setDividerSize(0);
        this.setMessageText(this.language.getString("MessagePane.defaultText.welcomeMessage"));
    }

    public void update_boardSelected() {
        this.messageSplitPane.setBottomComponent(null);
        this.messageSplitPane.setDividerSize(0);
        this.setMessageText(this.language.getString("MessagePane.defaultText.noMessageSelected"));
    }

    public void update_folderSelected() {
        this.messageSplitPane.setBottomComponent(null);
        this.messageSplitPane.setDividerSize(0);
        this.setMessageText(this.language.getString("MessagePane.defaultText.noBoardSelected"));
    }

    private void setMessageText(String txt) {
        this.idLineTextHighlighter.removeHighlights(this.messageTextArea);
        SmileyCache.clearCachedSmileys();
        this.messageTextArea.setText(txt);
    }

    public TextPane getTextArea() {
        return this.messageTextArea;
    }

    private int calculateCaretPosition(JTextComponent c, int offset, int linesDown) {
        int len = c.getDocument().getLength();
        try {
            int end;
            while (offset < len && (end = Utilities.getRowEnd(c, offset)) >= 0) {
                offset = end = Math.min(end + 1, len);
                if (--linesDown != 0) continue;
                return offset;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return len;
    }

    public void update_messageSelected(FrostMessageObject msg) {
        this.selectedMessage = msg;
        if (this.textHighlighter != null) {
            this.textHighlighter.removeHighlights(this.messageTextArea);
        }
        AttachmentList fileAttachments = this.selectedMessage.getAttachmentsOfType(0);
        AttachmentList boardAttachments = this.selectedMessage.getAttachmentsOfType(1);
        this.attachedFilesModel.setData(fileAttachments);
        this.attachedBoardsModel.setData(boardAttachments);
        int textViewHeight = this.positionDividers(fileAttachments.size(), boardAttachments.size());
        this.setMessageText(this.selectedMessage.getContent());
        this.messageBodyScrollPane.getVerticalScrollBar().setValueIsAdjusting(true);
        this.messageBodyScrollPane.getVerticalScrollBar().setValue(0);
        if (this.searchMessagesConfig == null) {
            int pos = this.selectedMessage.getIdLinePos();
            int len = this.selectedMessage.getIdLineLen();
            if (pos > -1 && len > 10) {
                this.idLineTextHighlighter.highlight(this.messageTextArea, pos, len, true);
            } else {
                pos = this.selectedMessage.getContent().lastIndexOf("----- " + this.selectedMessage.getFromName() + " ----- ");
            }
            if (pos >= 0) {
                int h = this.messageTextArea.getFontMetrics(this.messageTextArea.getFont()).getHeight();
                int s = textViewHeight;
                int v = s / h - 1;
                pos = this.calculateCaretPosition(this.messageTextArea, pos, v);
                this.messageTextArea.getCaret().setDot(pos);
            } else {
                pos = this.selectedMessage.getContent().length();
                this.messageTextArea.getCaret().setDot(pos);
            }
        }
        this.messageBodyScrollPane.getVerticalScrollBar().setValueIsAdjusting(false);
        if (this.searchMessagesConfig != null && this.searchMessagesConfig.content != null && this.searchMessagesConfig.content.size() > 0) {
            if (this.textHighlighter == null) {
                this.textHighlighter = new TextHighlighter(highlightColor, true);
            }
            this.textHighlighter.highlight((JTextComponent)this.messageTextArea, this.searchMessagesConfig.content, false);
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        MessageDecoder decoder = new MessageDecoder();
        decoder.setSmileyDecode(Core.frostSettings.getBoolValue("showSmileys"));
        decoder.setFreenetKeysDecode(Core.frostSettings.getBoolValue("showKeysAsHyperlinks"));
        this.messageTextArea = new AntialiasedTextPane(decoder);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setDoubleBuffered(true);
        this.messageTextArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.messageTextArea.setAntiAliasEnabled(Core.frostSettings.getBoolValue("messageBodyAA"));
        this.messageBodyScrollPane = new JScrollPane(this.messageTextArea);
        this.messageBodyScrollPane.setWheelScrollingEnabled(true);
        this.attachedFilesModel = new AttachedFilesTableModel();
        this.filesTable = new JTable(this.attachedFilesModel);
        this.attachedFilesModel.configureTable(this.filesTable);
        this.filesTableScrollPane = new JScrollPane(this.filesTable);
        this.filesTableScrollPane.setWheelScrollingEnabled(true);
        this.attachedBoardsModel = new AttachedBoardTableModel();
        this.boardsTable = new JTable(this.attachedBoardsModel){
            DescColumnRenderer descColRenderer;
            {
                this.descColRenderer = new DescColumnRenderer();
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 2) {
                    return this.descColRenderer;
                }
                return super.getCellRenderer(row, column);
            }

            class DescColumnRenderer
            extends DefaultTableCellRenderer {
                DescColumnRenderer() {
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    String sval = (String)value;
                    if (sval != null && sval.length() > 0) {
                        this.setToolTipText(sval);
                    } else {
                        this.setToolTipText(null);
                    }
                    return this;
                }
            }
        };
        this.boardsTableScrollPane = new JScrollPane(this.boardsTable);
        this.boardsTableScrollPane.setWheelScrollingEnabled(true);
        this.fontChanged();
        this.attachmentsSplitPane = new JSplitPane(0, this.filesTableScrollPane, this.boardsTableScrollPane);
        this.attachmentsSplitPane.setResizeWeight(0.5);
        this.attachmentsSplitPane.setDividerSize(3);
        this.attachmentsSplitPane.setDividerLocation(0.5);
        this.messageSplitPane = new JSplitPane(0, this.messageBodyScrollPane, this.attachmentsSplitPane);
        this.messageSplitPane.setDividerSize(0);
        this.messageSplitPane.setDividerLocation(1.0);
        this.messageSplitPane.setResizeWeight(1.0);
        this.add((Component)this.messageSplitPane, "Center");
        this.messageTextArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MessageTextPane.this.showTofTextAreaPopupMenu(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MessageTextPane.this.showTofTextAreaPopupMenu(e);
                }
            }
        });
        this.messageTextArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getKeyChar() == '\u007f' && MessageTextPane.this.parentFrame == MessageTextPane.this.mainFrame) {
                    MessageTextPane.this.mainFrame.getMessagePanel().deleteSelectedMessage();
                }
            }
        });
        TextComponentFindAction findAction = new TextComponentFindAction();
        findAction.install(this.messageTextArea);
        this.messageTextArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (!(evt instanceof MouseHyperlinkEvent)) {
                    MessageTextPane.this.logger.severe("INTERNAL ERROR, hyperlinkevent is wrong object!");
                    return;
                }
                MouseHyperlinkEvent e = (MouseHyperlinkEvent)evt;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    List<String> allKeys = ((MessageDecoder)MessageTextPane.this.messageTextArea.getDecoder()).getHyperlinkedKeys();
                    String clickedKey = e.getDescription();
                    MessageTextPane.this.showHyperLinkPopupMenu(e, clickedKey, allKeys, e.getMouseEvent().getX(), e.getMouseEvent().getY());
                }
            }
        });
        this.filesTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MessageTextPane.this.showAttachedFilesPopupMenu(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MessageTextPane.this.showAttachedFilesPopupMenu(e);
                }
            }
        });
        this.boardsTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MessageTextPane.this.showAttachedBoardsPopupMenu(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MessageTextPane.this.showAttachedBoardsPopupMenu(e);
                }
            }
        });
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("messageBodyAA")) {
                    MessageTextPane.this.messageTextArea.setAntiAliasEnabled(Core.frostSettings.getBoolValue("messageBodyAA"));
                } else if (evt.getPropertyName().equals("messageBodyFontName")) {
                    MessageTextPane.this.fontChanged();
                } else if (evt.getPropertyName().equals("messageBodyFontSize")) {
                    MessageTextPane.this.fontChanged();
                } else if (evt.getPropertyName().equals("messageBodyFontStyle")) {
                    MessageTextPane.this.fontChanged();
                } else if (evt.getPropertyName().equals("showSmileys")) {
                    ((MessageDecoder)MessageTextPane.this.messageTextArea.getDecoder()).setSmileyDecode(Core.frostSettings.getBoolValue("showSmileys"));
                    if (MessageTextPane.this.selectedMessage != null) {
                        MessageTextPane.this.update_messageSelected(MessageTextPane.this.selectedMessage);
                    } else {
                        MessageTextPane.this.setMessageText(MessageTextPane.this.messageTextArea.getText());
                    }
                } else if (evt.getPropertyName().equals("showKeysAsHyperlinks")) {
                    ((MessageDecoder)MessageTextPane.this.messageTextArea.getDecoder()).setFreenetKeysDecode(Core.frostSettings.getBoolValue("showKeysAsHyperlinks"));
                    if (MessageTextPane.this.selectedMessage != null) {
                        MessageTextPane.this.update_messageSelected(MessageTextPane.this.selectedMessage);
                    } else {
                        MessageTextPane.this.setMessageText(MessageTextPane.this.messageTextArea.getText());
                    }
                }
            }
        };
        Core.frostSettings.addPropertyChangeListener("messageBodyFontName", this.propertyChangeListener);
        Core.frostSettings.addPropertyChangeListener("messageBodyFontSize", this.propertyChangeListener);
        Core.frostSettings.addPropertyChangeListener("messageBodyFontStyle", this.propertyChangeListener);
        Core.frostSettings.addPropertyChangeListener("messageBodyAA", this.propertyChangeListener);
        Core.frostSettings.addPropertyChangeListener("showSmileys", this.propertyChangeListener);
        Core.frostSettings.addPropertyChangeListener("showKeysAsHyperlinks", this.propertyChangeListener);
    }

    private void fontChanged() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("messageBodyFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("messageBodyFontStyle"), fontSize = Core.frostSettings.getIntValue("messageBodyFontSize"));
        if (!font.getFamily().equals(fontName)) {
            this.logger.severe("The selected font was not found in your system\nThat selection will be changed to \"Monospaced\".");
            Core.frostSettings.setValue("messageBodyFontName", "Monospaced");
            font = new Font("Monospaced", fontStyle, fontSize);
        }
        this.messageTextArea.setFont(font);
    }

    private int positionDividers(int attachedFiles, int attachedBoards) {
        if (attachedFiles == 0 && attachedBoards == 0) {
            this.messageSplitPane.setBottomComponent(null);
            this.messageSplitPane.setDividerSize(0);
            this.messageSplitPane.setDividerLocation(1.0);
            return this.messageSplitPane.getDividerLocation();
        }
        this.messageSplitPane.setDividerSize(3);
        this.messageSplitPane.setDividerLocation(0.75);
        if (attachedFiles != 0 && attachedBoards == 0) {
            this.attachmentsSplitPane.setTopComponent(null);
            this.attachmentsSplitPane.setBottomComponent(null);
            this.messageSplitPane.setBottomComponent(this.filesTableScrollPane);
            return this.messageSplitPane.getDividerLocation();
        }
        if (attachedFiles == 0 && attachedBoards != 0) {
            this.attachmentsSplitPane.setTopComponent(null);
            this.attachmentsSplitPane.setBottomComponent(null);
            this.messageSplitPane.setBottomComponent(this.boardsTableScrollPane);
            return this.messageSplitPane.getDividerLocation();
        }
        if (attachedFiles != 0 && attachedBoards != 0) {
            this.attachmentsSplitPane.setTopComponent(this.filesTableScrollPane);
            this.attachmentsSplitPane.setBottomComponent(this.boardsTableScrollPane);
            this.messageSplitPane.setBottomComponent(this.attachmentsSplitPane);
        }
        return this.messageSplitPane.getDividerLocation();
    }

    public void saveMessageButton_actionPerformed() {
        FileAccess.saveDialog(MainFrame.getInstance(), this.messageTextArea.getText(), Core.frostSettings.getValue("lastUsedDirectory"), this.language.getString("MessagePane.messageText.saveDialog.title"));
    }

    private void addBoardsToKnownBoards() {
        int[] selectedRows = this.boardsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            this.boardsTable.selectAll();
            selectedRows = this.boardsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
        }
        AttachmentList boards = this.selectedMessage.getAttachmentsOfType(1);
        LinkedList<Board> addBoards = new LinkedList<Board>();
        for (int element : selectedRows) {
            BoardAttachment ba = (BoardAttachment)boards.get(element);
            addBoards.add(ba.getBoardObj());
        }
        KnownBoardsManager.addNewKnownBoards(addBoards);
    }

    private void downloadBoards(Folder targetFolder) {
        this.logger.info("adding boards");
        int[] selectedRows = this.boardsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            this.boardsTable.selectAll();
            selectedRows = this.boardsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
        }
        AttachmentList boards = this.selectedMessage.getAttachmentsOfType(1);
        for (int element : selectedRows) {
            BoardAttachment ba = (BoardAttachment)boards.get(element);
            Board fbo = ba.getBoardObj();
            String name = fbo.getName();
            Board board = this.mainFrame.getTofTreeModel().getBoardByName(name);
            if (board != null) {
                if (JOptionPane.showConfirmDialog(this, "You already have a board named " + name + ".\n" + "Are you sure you want to add this one over it?", "Board already exists", 0) != 0) continue;
                board.setPublicKey(fbo.getPublicKey());
                board.setPrivateKey(fbo.getPrivateKey());
                this.mainFrame.updateTofTree(board);
                continue;
            }
            if (targetFolder == null) {
                this.mainFrame.getTofTreeModel().addNodeToTree(fbo);
                continue;
            }
            this.mainFrame.getTofTreeModel().addNodeToTree(fbo, targetFolder);
        }
    }

    private void showAttachedBoardsPopupMenu(MouseEvent e) {
        if (this.popupMenuAttachmentBoard == null) {
            this.popupMenuAttachmentBoard = new PopupMenuAttachmentBoard();
            this.language.addLanguageListener(this.popupMenuAttachmentBoard);
        }
        this.popupMenuAttachmentBoard.show(e.getComponent(), e.getX(), e.getY());
    }

    private void showAttachedFilesPopupMenu(MouseEvent e) {
        if (this.popupMenuAttachmentTable == null) {
            this.popupMenuAttachmentTable = new PopupMenuAttachmentFile();
            this.language.addLanguageListener(this.popupMenuAttachmentTable);
        }
        this.popupMenuAttachmentTable.show(e.getComponent(), e.getX(), e.getY());
    }

    private void showHyperLinkPopupMenu(HyperlinkEvent e, String clickedKey, List<String> allKeys, int x, int y) {
        if (this.popupMenuHyperLink == null) {
            this.popupMenuHyperLink = new PopupMenuHyperLink();
            this.language.addLanguageListener(this.popupMenuHyperLink);
        }
        this.popupMenuHyperLink.setClickedKey(clickedKey);
        this.popupMenuHyperLink.setAllKeys(allKeys);
        this.popupMenuHyperLink.show(this.messageTextArea, x, y);
    }

    private void showTofTextAreaPopupMenu(MouseEvent e) {
        if (this.popupMenuTofText == null) {
            this.popupMenuTofText = new PopupMenuTofText(this.messageTextArea);
            this.language.addLanguageListener(this.popupMenuTofText);
        }
        this.popupMenuTofText.show(e.getComponent(), e.getX(), e.getY());
    }

    private DownloadModel getDownloadModel() {
        return FileTransferManager.inst().getDownloadManager().getModel();
    }

    public void close() {
        Core.frostSettings.removePropertyChangeListener("messageBodyFontName", this.propertyChangeListener);
        Core.frostSettings.removePropertyChangeListener("messageBodyFontSize", this.propertyChangeListener);
        Core.frostSettings.removePropertyChangeListener("messageBodyFontStyle", this.propertyChangeListener);
        Core.frostSettings.removePropertyChangeListener("messageBodyAA", this.propertyChangeListener);
        if (this.popupMenuAttachmentBoard != null) {
            this.language.removeLanguageListener(this.popupMenuAttachmentBoard);
        }
        if (this.popupMenuAttachmentTable != null) {
            this.language.removeLanguageListener(this.popupMenuAttachmentTable);
        }
        if (this.popupMenuTofText != null) {
            this.language.removeLanguageListener(this.popupMenuTofText);
        }
    }

    @Override
    public void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.messageTextArea.addKeyListener(l);
        this.filesTable.addKeyListener(l);
        this.boardsTable.addKeyListener(l);
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.messageTextArea.removeKeyListener(l);
        this.filesTable.removeKeyListener(l);
        this.boardsTable.removeKeyListener(l);
    }

    private class PopupMenuTofText
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JTextComponent sourceTextComponent;
        private final JMenuItem copyItem = new JMenuItem();
        private final JMenuItem cancelItem = new JMenuItem();
        private final JMenuItem saveMessageItem = new JMenuItem();

        public PopupMenuTofText(JTextComponent sourceTextComponent) {
            this.sourceTextComponent = sourceTextComponent;
            this.initialize();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.saveMessageItem) {
                MessageTextPane.this.saveMessageButton_actionPerformed();
            } else if (e.getSource() == this.copyItem) {
                String text = this.sourceTextComponent.getSelectedText();
                CopyToClipboard.copyText(text);
            }
        }

        private void initialize() {
            this.languageChanged(null);
            this.copyItem.addActionListener(this);
            this.saveMessageItem.addActionListener(this);
            this.add(this.copyItem);
            this.addSeparator();
            this.add(this.saveMessageItem);
            this.addSeparator();
            this.add(this.cancelItem);
        }

        public void languageChanged(LanguageEvent event) {
            this.copyItem.setText(MessageTextPane.this.language.getString("MessagePane.messageText.popupmenu.copy"));
            this.saveMessageItem.setText(MessageTextPane.this.language.getString("MessagePane.messageText.popupmenu.saveMessageToDisk"));
            this.cancelItem.setText(MessageTextPane.this.language.getString("Common.cancel"));
        }

        public void show(Component invoker, int x, int y) {
            if (MessageTextPane.this.selectedMessage != null && MessageTextPane.this.selectedMessage.getContent() != null) {
                if (this.sourceTextComponent.getSelectedText() != null) {
                    this.copyItem.setEnabled(true);
                } else {
                    this.copyItem.setEnabled(false);
                }
                super.show(invoker, x, y);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PopupMenuHyperLink
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem cancelItem = new JMenuItem();
        private final JMenuItem copyKeyOnlyToClipboard = new JMenuItem();
        private final JMenuItem copyFreesiteLinkToClipboard = new JMenuItem();
        private final JMenuItem copyFileLinkToClipboard = new JMenuItem();
        private final JMenuItem copyAllFileLinksToClipboard = new JMenuItem();
        private final JMenuItem downloadFile = new JMenuItem();
        private final JMenuItem downloadAllFiles = new JMenuItem();
        private String clickedKey = null;
        private List<String> allKeys = null;

        public PopupMenuHyperLink() throws HeadlessException {
            this.initialize();
        }

        public void setClickedKey(String s) {
            this.clickedKey = s;
        }

        public void setAllKeys(List<String> l) {
            this.allKeys = l;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copyKeyOnlyToClipboard) {
                this.copyToClipboard(false);
            } else if (e.getSource() == this.copyFreesiteLinkToClipboard) {
                this.copyToClipboard(false);
            } else if (e.getSource() == this.copyFileLinkToClipboard) {
                this.copyToClipboard(false);
            } else if (e.getSource() == this.copyAllFileLinksToClipboard) {
                this.copyToClipboard(true);
            } else if (e.getSource() == this.downloadFile) {
                this.downloadItems(false);
            } else if (e.getSource() == this.downloadAllFiles) {
                this.downloadItems(true);
            }
        }

        private void initialize() {
            this.languageChanged(null);
            this.copyKeyOnlyToClipboard.addActionListener(this);
            this.copyFreesiteLinkToClipboard.addActionListener(this);
            this.copyFileLinkToClipboard.addActionListener(this);
            this.copyAllFileLinksToClipboard.addActionListener(this);
            this.downloadFile.addActionListener(this);
            this.downloadAllFiles.addActionListener(this);
        }

        @Override
        public void languageChanged(LanguageEvent event) {
            this.copyKeyOnlyToClipboard.setText(MessageTextPane.this.language.getString("MessagePane.hyperlink.popupmenu.copyKeyToClipboard"));
            this.copyFreesiteLinkToClipboard.setText(MessageTextPane.this.language.getString("MessagePane.hyperlink.popupmenu.copyFreesiteLinkToClipboard"));
            this.copyFileLinkToClipboard.setText(MessageTextPane.this.language.getString("MessagePane.hyperlink.popupmenu.copyFileKeyToClipboard"));
            this.copyAllFileLinksToClipboard.setText(MessageTextPane.this.language.getString("MessagePane.hyperlink.popupmenu.copyAllFileKeysToClipboard"));
            this.downloadFile.setText(MessageTextPane.this.language.getString("MessagePane.hyperlink.popupmenu.downloadFileKey"));
            this.downloadAllFiles.setText(MessageTextPane.this.language.getString("MessagePane.hyperlink.popupmenu.downloadAllFileKeys"));
            this.cancelItem.setText(MessageTextPane.this.language.getString("Common.cancel"));
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.removeAll();
            if (this.clickedKey.indexOf("/") < 0 || !Character.isLetterOrDigit(this.clickedKey.charAt(this.clickedKey.length() - 1))) {
                this.add(this.copyKeyOnlyToClipboard);
            } else if (this.clickedKey.endsWith("/")) {
                this.add(this.copyFreesiteLinkToClipboard);
            } else {
                this.add(this.copyFileLinkToClipboard);
                if (this.allKeys.size() > 1) {
                    this.add(this.copyAllFileLinksToClipboard);
                }
                this.addSeparator();
                this.add(this.downloadFile);
                if (this.allKeys.size() > 1) {
                    this.add(this.downloadAllFiles);
                }
            }
            this.addSeparator();
            this.add(this.cancelItem);
            super.show(invoker, x, y);
        }

        private void downloadItems(boolean getAll) {
            List<String> items = this.getItems(getAll);
            if (items == null) {
                return;
            }
            for (String item : items) {
                String key = FcpHandler.isFreenet05() ? item.substring(0, item.indexOf("/")) : item;
                String name = item.substring(item.lastIndexOf("/") + 1);
                if (name.indexOf("%") > 0) {
                    try {
                        name = URLDecoder.decode(name, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        MessageTextPane.this.logger.log(Level.SEVERE, "Decode of HTML code failed", ex);
                    }
                }
                FrostDownloadItem dlItem = new FrostDownloadItem(name, key);
                MessageTextPane.this.getDownloadModel().addDownloadItem(dlItem);
            }
        }

        private List<String> getItems(boolean getAll) {
            List<String> items = getAll ? this.allKeys : Collections.singletonList(this.clickedKey);
            if (items == null || items.size() == 0) {
                return null;
            }
            return items;
        }

        private void copyToClipboard(boolean getAll) {
            String text;
            List<String> items = this.getItems(getAll);
            if (items == null) {
                return;
            }
            if (items.size() > 1) {
                StringBuilder textToCopy = new StringBuilder();
                for (String key : items) {
                    textToCopy.append(key).append("\n");
                }
                text = textToCopy.toString();
            } else {
                text = items.get(0);
            }
            CopyToClipboard.copyText(text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PopupMenuAttachmentFile
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem saveAttachmentItem = new JMenuItem();
        private final JMenuItem saveAttachmentsItem = new JMenuItem();
        private final JMenu copyToClipboardMenu = new JMenu();
        private final JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private final JMenuItem copyKeysItem = new JMenuItem();
        private final JMenuItem copyExtendedInfoItem = new JMenuItem();

        public PopupMenuAttachmentFile() throws HeadlessException {
            this.initialize();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.saveAttachmentsItem || e.getSource() == this.saveAttachmentItem) {
                this.downloadAttachments();
            } else if (e.getSource() == this.copyKeysItem) {
                CopyToClipboard.copyKeys(this.getItems().toArray());
            } else if (e.getSource() == this.copyKeysAndNamesItem) {
                CopyToClipboard.copyKeysAndFilenames(this.getItems().toArray());
            } else if (e.getSource() == this.copyExtendedInfoItem) {
                CopyToClipboard.copyExtendedInfo(this.getItems().toArray());
            }
        }

        private void initialize() {
            this.languageChanged(null);
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            if (FcpHandler.isFreenet05()) {
                this.copyToClipboardMenu.add(this.copyKeysItem);
                this.copyKeysItem.addActionListener(this);
            }
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
            this.saveAttachmentsItem.addActionListener(this);
            this.saveAttachmentItem.addActionListener(this);
        }

        @Override
        public void languageChanged(LanguageEvent event) {
            this.copyKeysItem.setText(MessageTextPane.this.language.getString("Common.copyToClipBoard.copyKeysOnly"));
            this.copyKeysAndNamesItem.setText(MessageTextPane.this.language.getString("Common.copyToClipBoard.copyKeysWithFilenames"));
            this.copyExtendedInfoItem.setText(MessageTextPane.this.language.getString("Common.copyToClipBoard.copyExtendedInfo"));
            this.copyToClipboardMenu.setText(MessageTextPane.this.language.getString("Common.copyToClipBoard") + "...");
            this.saveAttachmentsItem.setText(MessageTextPane.this.language.getString("MessagePane.fileAttachmentTable.popupmenu.downloadAttachments"));
            this.saveAttachmentItem.setText(MessageTextPane.this.language.getString("MessagePane.fileAttachmentTable.popupmenu.downloadSelectedAttachment"));
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.removeAll();
            this.add(this.copyToClipboardMenu);
            this.addSeparator();
            if (MessageTextPane.this.filesTable.getSelectedRow() == -1) {
                this.add(this.saveAttachmentsItem);
            } else {
                this.add(this.saveAttachmentItem);
            }
            super.show(invoker, x, y);
        }

        private void downloadAttachments() {
            for (FileAttachment fa : this.getItems()) {
                String filename = fa.getFilename();
                if (filename.indexOf("%") > 0) {
                    try {
                        filename = URLDecoder.decode(filename, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        MessageTextPane.this.logger.log(Level.SEVERE, "Decode of HTML code failed", ex);
                    }
                }
                FrostDownloadItem dlItem = new FrostDownloadItem(filename, fa.getKey(), fa.getFileSize());
                MessageTextPane.this.getDownloadModel().addDownloadItem(dlItem);
            }
        }

        private List<FileAttachment> getItems() {
            LinkedList items = null;
            int[] selectedRows = MessageTextPane.this.filesTable.getSelectedRows();
            if (selectedRows.length == 0) {
                items = MessageTextPane.this.selectedMessage.getAttachmentsOfType(0);
            } else {
                AttachmentList attachments = MessageTextPane.this.selectedMessage.getAttachmentsOfType(0);
                items = new LinkedList();
                for (int element : selectedRows) {
                    FileAttachment fo = (FileAttachment)attachments.get(element);
                    items.add(fo);
                }
            }
            return items;
        }
    }

    private class PopupMenuAttachmentBoard
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenuItem saveBoardsItem = new JMenuItem();
        private final JMenuItem saveBoardsToFolderItem = new JMenuItem();
        private final JMenuItem addBoardsToKnownBoards = new JMenuItem();

        public PopupMenuAttachmentBoard() {
            this.initialize();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.saveBoardsItem) {
                MessageTextPane.this.downloadBoards(null);
            } else if (e.getSource() == this.saveBoardsToFolderItem) {
                TargetFolderChooser tfc = new TargetFolderChooser(MessageTextPane.this.mainFrame.getTofTreeModel());
                Folder targetFolder = tfc.startDialog();
                if (targetFolder != null) {
                    MessageTextPane.this.downloadBoards(targetFolder);
                }
            } else if (e.getSource() == this.addBoardsToKnownBoards) {
                MessageTextPane.this.addBoardsToKnownBoards();
            }
        }

        private void initialize() {
            this.languageChanged(null);
            this.saveBoardsItem.addActionListener(this);
            this.saveBoardsToFolderItem.addActionListener(this);
            this.addBoardsToKnownBoards.addActionListener(this);
        }

        public void languageChanged(LanguageEvent event) {
            this.saveBoardsItem.setText(MessageTextPane.this.language.getString("MessagePane.boardAttachmentTable.popupmenu.addBoards"));
            this.saveBoardsToFolderItem.setText(MessageTextPane.this.language.getString("MessagePane.boardAttachmentTable.popupmenu.addBoardsToFolder") + " ...");
            this.addBoardsToKnownBoards.setText(MessageTextPane.this.language.getString("MessagePane.boardAttachmentTable.popupmenu.addBoardsToKnownBoards"));
        }

        public void show(Component invoker, int x, int y) {
            this.removeAll();
            this.add(this.saveBoardsItem);
            this.add(this.saveBoardsToFolderItem);
            this.add(this.addBoardsToKnownBoards);
            super.show(invoker, x, y);
        }
    }
}

