/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.boards.Board;
import frost.gui.KnownBoard;
import frost.storage.perst.FrostFilesStorage;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownBoardsManager {
    private static KnownBoardsManager instance = null;

    private KnownBoardsManager() {
    }

    public static KnownBoardsManager getInstance() {
        if (instance == null) {
            instance = new KnownBoardsManager();
        }
        return instance;
    }

    public static List<KnownBoard> getKnownBoardsList() {
        return FrostFilesStorage.inst().getKnownBoards();
    }

    public static int addNewKnownBoards(List<Board> lst) {
        if (lst == null || lst.size() == 0) {
            return 0;
        }
        int added = FrostFilesStorage.inst().addNewKnownBoards(lst);
        return added;
    }

    public static void deleteKnownBoard(Board b) {
        FrostFilesStorage.inst().deleteKnownBoard(b);
    }

    public HashSet<String> loadHiddenBoardNames() {
        return FrostFilesStorage.inst().loadHiddenBoardNames();
    }

    public void saveHiddenBoardNames(HashSet<String> names) {
        FrostFilesStorage.inst().saveHiddenBoardNames(names);
    }
}

